#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

###
### Утилита для снятия дампа и файла трассировки приложения WEB-Сервер-КС (dotnet-dump,dotnet-trace)
###
### Версия 20221228
###

### В Astra Linux проблемы со снятием дампа вида: Write dump failed - HRESULT: 0x80004005
### Решение: astra-ptrace-lock disable && systemctl is-enabled astra-ptrace-lock
###          В итоге вывод должен быть: disabled
###          reboot #перегрузите сервер
### Проверьте, что параметр ptrace_scope=0
### docker exec wsks-3.1.24_443 /bin/bash -c "cat /proc/sys/kernel/yama/ptrace_scope"



# Цвета
ErrColor='\033[1;31m'
SuccColor='\033[0;32m'
WarnColor='\033[0;33m'
NoColor='\033[0m'

sOK="[===${SuccColor}OK${NoColor}===]="
wOK="[==${WarnColor}Инфо${NoColor}==]="
eRR="[=${ErrColor}Ошибка${NoColor}=]="
emptE="==========="


clear
echo ""
echo -e "${WarnColor}=========================================================================================${NoColor}"
echo -e "${WarnColor}=        Утилита для снятия дампа и файла трассировки приложения WEB-Сервер-КС          =${NoColor}"
echo -e "${WarnColor}=========================================================================================${NoColor}"
echo ""

if [[ $EUID != 0 ]]; then
    echo -e "${eRR}Скрипт должен выполняться root правами!"
    exit 1;
fi;


format() {
        printf "%-$1s\n" $2
}


function fn_file_clr(){
cat > $1 << EOF
EOF
}

####Выбор контейнера WEB-Сервер-КС
function wsks_instance() {
    wsks_servs="$(echo $(systemctl --type=service | grep 'wsks-' | grep loaded | sed -e 's/^ *//' | cut -f1,2,3 -d"."))"
    IFS=' ' read -r -a wsks_servs <<< "$wsks_servs"
    unset IFS

    wsks_count=${#wsks_servs[*]}
    if [ $wsks_count == 0 ]; then
        echo -e "${eRR}WEB-Сервер-КС  не найдены, возможно это не сервер WEB-Сервер-КС!"
        exit 1;
    fi;

    echo "Всего найдено $wsks_count WEB-Сервер-КС:"
    wsks_servs[$(($wsks_count+1))]="Выход"

    PS3="Выберите WEB-Сервер-КС: "
    select menu in "${wsks_servs[@]}" ; do
       if ((${REPLY}<=${wsks_count})) && [[ ${REPLY} =~ ^[0-9]+$ ]]; then
           wsks_inst=$menu
           break
       else
           if ((${REPLY}==$(($wsks_count+1)))) ; then
              exit
           else
              echo "Недопустимое действие $REPLY"
           fi;
       fi;
    done

    wsks_ver=$(echo $wsks_inst | cut -f1 -d"_" | cut -f2 -d"-")
    wsks_port=$(echo $wsks_inst | cut -f2 -d"_")
    echo ""
    echo -e "${wOK}Выбран WEB-Сервер-КС: $wsks_inst"
    echo -e "                       - версия: $wsks_ver"
    echo -e "                         - порт: $wsks_port"
    echo ""
}


#### Выбор приложения
function wsks_app() {
 dks_bashfile_dir="/opt/${wsks_inst}/ctl"
 dks_inst_path=$(${dks_bashfile_dir}/ws_const_var.sh dks_inst_path)
 search_filter="*"
 contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)

 echo -e "${wOK}Приложения ${contsoft}:"
 echo -e "----------------------------------------------------------------------------------------------------"
 echo -e "Тип        Kestrel Каталог         Расположение                                  Наименование"
 echo -e "----------------------------------------------------------------------------------------------------"
 i=0
 for app_info_file in `find ${dks_inst_path}/www/html -type d -name "wsks_${search_filter}" | sort`
  do
    if [ -f "${app_info_file}/wskstype" ]; then
      wskstype="${app_info_file}/wskstype"
      app_catalog[$i]="${app_info_file}"
      app_type[$i]=$(echo $(cat ${wskstype} | grep "type=") | sed 's|.*=||')

      app_type_name_tmp=$(echo $(cat ${wskstype} | grep "type_name=") | sed 's|.*=||')
      app_type_name[$i]=$(echo  ${app_type_name_tmp} | sed 's/ /_/g')
      if [ -z "${app_type_name[$i]}" ]; then
        app_type_name[$i]=$(${dks_bashfile_dir}/ws_getntype.sh ${app_type})
      fi;

      app_port[$i]=$(echo $(cat ${wskstype} | grep "kestrel_port=") | sed 's|.*=||')
      app_virt[$i]=" "
      app_virt[$i]=$(echo $(cat ${wskstype} | grep "virt_catalog=") | sed 's|.*=||')
      app_full[$i]=$(echo "$(format 7 ${app_type[$i]}) $(format 7 ${app_port[$i]}) $(format 15 ${app_virt[$i]}) $(format 45 ${app_catalog[$i]}) $(format 30 ${app_type_name[$i]})")
      i=$(($i+1))
    fi;
 done
 app_full_count=$((${#app_full[*]}))
 app_full[$(($app_full_count+1))]="Выход"

 echo ""
 PS3="Выберите приложение:"
 select menu in "${app_full[@]}" ; do
    if ((${REPLY}<=${app_full_count})) && [[ ${REPLY} =~ ^[0-9]+$ ]]; then
        app_port_sel=${app_port[${REPLY}-1]}
        break
    else
       if ((${REPLY}==$(($app_full_count+1)))) ; then
          exit
       else
          echo "Недопустимое действие $REPLY"
       fi;
    fi;
 done
 #echo ${app_port_sel}
}


### BEGIN

MENU=(
    "Утилита для сбора и анализа дампа dotnet-dump"
    "Утилита анализа производительности dotnet-trace"
    "Выход"
)
PS3="Выберите действие: "
select menu in "${MENU[@]}" ; do
case $REPLY in
    1) action=$REPLY
       break ;;
    2) action=$REPLY
       break ;;
    3) exit  ;;
    *) echo "Недопустимое действие $REPLY" ;;
esac
done


bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
wsks_instance
wsks_app
dotnet_dump_exist=$(${contsoft} exec $wsks_inst /bin/bash -c "if [ -f /opt/.dotnet/dotnet-dump ]; then echo "000-1"; else echo "000-0"; fi;")
dotnet_trace_exist=$(${contsoft} exec $wsks_inst /bin/bash -c "if [ -f /opt/.dotnet/dotnet-trace ]; then echo "000-1"; else echo "000-0"; fi;")

# Обе утилиты пригодятся, поэтому скачаем и установим в контейнер на будущее
if [ ${dotnet_dump_exist} = "000-0" ]; then
    wget -O "${bashfile_dir}/dotnet-dump" "https://keysystems.ru/files/web/Scripts/wsks/dotnet-dump" --no-check-certificate
    ${contsoft} cp ${bashfile_dir}/dotnet-dump $wsks_inst:/opt/.dotnet/dotnet-dump
    ${contsoft} exec $wsks_inst /bin/bash -c "chown root:root /opt/.dotnet/dotnet-dump"
    ${contsoft} exec $wsks_inst /bin/bash -c "chmod 755 /opt/.dotnet/dotnet-dump"
else
    if [ ${dotnet_dump_exist} != "000-1" ]; then
       echo -e "${eRR}Ошибка доступа к контейнеру $wsks_inst!"
       exit 1;
    fi;
fi;
if [ ${dotnet_trace_exist} = "000-0" ]; then
    wget -O "${bashfile_dir}/dotnet-trace" "https://keysystems.ru/files/web/Scripts/wsks/dotnet-trace" --no-check-certificate
    ${contsoft} cp ${bashfile_dir}/dotnet-trace $wsks_inst:/opt/.dotnet/dotnet-trace
    ${contsoft} exec $wsks_inst /bin/bash -c "chown root:root /opt/.dotnet/dotnet-trace"
    ${contsoft} exec $wsks_inst /bin/bash -c "chmod 755 /opt/.dotnet/dotnet-trace"
else
    if [ ${dotnet_trace_exist} != "000-1" ]; then
       echo -e "${eRR}Ошибка доступа к контейнеру $wsks_inst!"
       exit 1;
    fi;
fi;

echo -e ""
echo -e "${wOK}Процессы выбранного приложения в контейнере $wsks_inst:"
echo -e "----------------------------------------------------------------------------------------------------"
echo -e "PID       Имя                 Команда                                                                    "
echo -e "----------------------------------------------------------------------------------------------------"

# Выбор нужного PID из контейнера
if [ $action == "1" ] ; then
    ${contsoft} exec $wsks_inst /bin/bash -c "export DOTNET_ROOT=/opt/.dotnet && /opt/.dotnet/dotnet-dump ps | grep wsks_${app_port_sel}"
fi;
if [ $action == "2" ] ; then
    ${contsoft} exec $wsks_inst /bin/bash -c "export DOTNET_ROOT=/opt/.dotnet && /opt/.dotnet/dotnet-trace ps | grep wsks_${app_port_sel}"
fi;
read -p "Укажите PID:" pid_id
pid_id=$(echo $pid_id | tr -d '[:space:]') #удаляем все пробелы
if [ -z "${pid_id}" ] || ! [[ ${pid_id} =~ ^[0-9]+$ ]]; then
    echo ""
    echo -e "${eRR}PID не указан! Выполнение прервано!"
    exit 1;
fi;

# Снимем дамп утилитой dotnet-dump
if [ $action == "1" ] ; then
 ${contsoft} exec $wsks_inst /bin/bash -c "export DOTNET_ROOT=/opt/.dotnet && /opt/.dotnet/dotnet-dump collect -p ${pid_id} -o /opt/wsks-${wsks_ver}/ctl/app/${app_port_sel}_${pid_id}_dump"
 if [ $? = "0" ]; then
   echo -e "${sOK}Дамп приложения создан по адресу: ${dks_inst_path}/ctl/app/${app_port_sel}_${pid_id}_dump"
   echo ""
 else
   echo -e "${eRR}Ошибка создания дампа!"
   exit 1;
 fi;
fi;

# Выполним трассировку dotnet-trace
if [ $action == "2" ] ; then
 ${contsoft} exec -ti $wsks_inst /bin/bash -c "export DOTNET_ROOT=/opt/.dotnet && /opt/.dotnet/dotnet-trace collect -p ${pid_id} -o /opt/wsks-${wsks_ver}/ctl/app/${app_port_sel}_${pid_id}_trace --providers Microsoft-Windows-DotNETRuntime,Microsoft-DotNETCore-SampleProfiler,Microsoft-Extensions-DependencyInjection,System.Buffers.ArrayPoolEventSource,System.Net.Http,System.Net.NameResolution,System.Net.Sockets,System.Threading.Tasks.TplEventSource,Microsoft.AspNetCore"
 if [ $? = "0" ]; then
   echo -e "${sOK}dotnet-trace создал файл по адресу: ${dks_inst_path}/ctl/app/${app_port_sel}_${pid_id}_trace"
   echo ""
 else
   echo -e "${eRR}dotnet-trace: ошибка создания файла!"
   exit 1;
 fi;
fi;

# Архивация
if [ -z $(which tar) ]; then
  # Отсутствует утилита tar
  echo -e "${eRR}Отсутствует архиватор \"tar\"."
  echo -e "${emptE}Выполните установку с помощью менеджера пакетов."
  exit 1;
fi;
if [ $action == "1" ] ; then
 cd ${dks_inst_path}/ctl/app && tar -cvzf ${app_port_sel}_${pid_id}_dump.tar.gz ${app_port_sel}_${pid_id}_dump
 if [ $? = "0" ]; then
   rm -f ${app_port_sel}_${pid_id}_dump
   echo -e "${sOK}Архив дампа создан по адресу: ${dks_inst_path}/ctl/app/${app_port_sel}_${pid_id}_dump.tar.gz"
   echo ""
 else
   echo -e "${eRR}Ошибка архивации!"
   exit 1;
 fi;
fi;
if [ $action == "2" ] ; then
 cd ${dks_inst_path}/ctl/app && tar -cvzf ${app_port_sel}_${pid_id}_trace.tar.gz ${app_port_sel}_${pid_id}_trace
 if [ $? = "0" ]; then
   rm -f ${app_port_sel}_${pid_id}_trace
   echo -e "${sOK}Архив файла dotnet-trace создан по адресу: ${dks_inst_path}/ctl/app/${app_port_sel}_${pid_id}_trace.tar.gz"
   echo ""
 else
   echo -e "${eRR}Ошибка архивации!"
   exit 1;
 fi;
fi;
