#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###




# Удаление web приложения:
# Парамеры:
# $1 внутренний порт kestrel

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -p|--kestrel_port)
        kestrel_port="$2"
        ;;
      -q|--quiet)
        quiet="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -p  | --kestrel_port   54430          кестрел порт развернутого приложения
 -q  | --quiet                         выполнение операции удаления без подтверждения
"
exit 1;
fi;

if [ -z "${kestrel_port}" ]; then
  kestrel_port="54430"
fi;

function fn_file_clr(){
cat > $1 << EOF
EOF
}

# Путь установки
dks_inst_path=$($dks_bashfile_dir/ws_const_var.sh dks_inst_path)
dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
host_stdout=$($dks_bashfile_dir/ws_const_var.sh   host_stdout)
cont_stdout=$($dks_bashfile_dir/ws_const_var.sh   cont_stdout)
dks_serv_name="${dks_cont_name}.service"
contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)

# Находим приложение и виртуальный каталог
wskstype="${dks_inst_path}/www/html/wsks_${kestrel_port}/wskstype"

if [ -f ${wskstype} ]; then
  app_type=$(echo $(cat ${wskstype} | grep "type=") | sed 's|.*=||')
  app_virt=$(echo $(cat ${wskstype} | grep "virt_catalog=") | sed 's|.*=||')
  app_note=$(echo $(cat ${wskstype} | grep "note") | sed 's|.*=||')
  app_type_name=$($dks_bashfile_dir/ws_getntype.sh ${app_type})
fi;


WarnColor='\033[0;33m'
NoColor='\033[0m'
uQY="[ ${WarnColor}Запрос${NoColor} ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~   Удаление прикладного приложения WEB-Сервер-КС       "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~                                                       "
echo "           ~    Порт кестрел : ${kestrel_port}"
if [ -f ${wskstype} ]; then
echo "           ~    Тип          : ${app_type} - ${app_type_name}"
echo "           ~    Вирт.каталог : ${app_virt}"
if ! [ -z "${app_note}" ]; then
echo "           ~    Примечание   : ${app_note}"
fi;
fi;
echo "           ~                                                       "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"


if [ -z "${quiet}" ]; then
  echo ""
  echo -n -e "${uQY}Вы действительно хотите удалить приложение по Kestrel порту \"${kestrel_port}\"?
           ([да;y]/[N;нет;n]): "

  read item
  case "$item" in
    y|Y|да)
        ;;
    n|N|нет) echo -e "${emptE}Операция удаления приложения прервана."; echo "";
        exit;
        ;;
    *) echo -e "${emptE}Операция удаления приложения прервана."; echo "";
        exit;
        ;;
  esac
fi;


echo ""

if [ -z "${kestrel_port}" ]; then
  echo -e "${emptE}Не указан Kestrel порт, по которому нужно удалить приложение."
  echo -e ""
  exit 1;
fi;

# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)

# тип http сервера
ws_type=$(${dks_bashfile_dir}/ws_const_var.sh ws_type)

target_app_start_file="${dks_bashfile_dir}/app/${kestrel_port}_app.sh"
target_app_start_err_file="${dks_bashfile_dir}/app/${kestrel_port}_app.err"
target_app_conf_etc_catalog="${dks_inst_path}/conf.etc"
target_apache_conf_file="${dks_inst_path}/conf.ks/vhost.ks/${kestrel_port}_ks.conf"
target_apache_conf_vh_file="${dks_inst_path}/conf.ks/vhost.ks/${kestrel_port}_vh.conf"
target_app_catalog="${dks_inst_path}/www/html/wsks_${kestrel_port}"
isDel="no"

if [ "${ws_type}" = "nginx" ]; then
  ws_servername="Nginx"
fi;

if [ "${ws_type}" = "angie" ]; then
  ws_servername="Angie"
fi;

if [ "${ws_type}" = "apache2" ]; then
  ws_servername="Apache"
fi;

# Останавливаем приложение
bash ${dks_bashfile_dir}/ws_ctlapp.sh -p "${kestrel_port}" -m "stop"


if [ -d "${target_app_catalog}" ]; then
  rm -R ${target_app_catalog}
  echo -e "${sOK}Удаление каталога приложения: ${target_app_catalog}."
  isDel="yes"
fi;

if [ -f "${target_app_start_file}" ]; then
  rm ${target_app_start_file} -f
  rm ${target_app_start_err_file} -f
  echo -e "${sOK}Удаление файла запуска приложения: ${target_app_start_file}."
  isDel="yes"
fi;


target_prometheus_json_file="${target_app_conf_etc_catalog}/prometheus/sd_files/${kestrel_port}_prometheus.json"
if [ -f "${target_prometheus_json_file}" ]; then
  rm ${target_prometheus_json_file} -f
  rm ${target_prometheus_json_file} -f
  echo -e "${sOK}Удаление файла конфига prometheus приложения: ${target_prometheus_json_file}."
  isDel="yes"
fi;


if [ -f "${target_apache_conf_file}" ]; then
  rm ${target_apache_conf_file} -f
  echo -e "${sOK}Удаление файла конфигурации ${ws_servername} для приложения: ${target_apache_conf_file}."
  isDel="yes"
fi;

if [ -f "${target_apache_conf_vh_file}" ]; then
  rm ${target_apache_conf_vh_file} -f
  echo -e "${sOK}Удаление файла конфигурации ${ws_servername} для приложения: ${target_apache_conf_vh_file}."
  isDel="yes"
fi;


if [ "${isDel}" = "no" ]; then
  echo -e "${wOK}Нет данных для удаления по порту: ${kestrel_port}."
  echo ""
  exit 1;
fi;

# Проверяем наличие хоть одного приложения, т.к.
# запускать без приложений не имеет смысла
exists_app=$(dir ${dks_bashfile_dir}/app | grep "_app.sh")

if [ -z "${exists_app}" ];then
  systemctl stop ${dks_serv_name}
  echo -e "${wOK}Остановка сервиса ${dks_serv_name}."
  echo -e "${emptE}Отсутствуют установленные приложения."
  echo -e "${emptE}Для установки приложений используйте скрипт ws_addapp.sh."
  echo -e "${emptE}См. инструкцию по развертыванию ${dks_bashfile_dir}/readme.txt"
  echo ""
  exit 0;
fi;

if systemctl -q is-active ${dks_serv_name}; then
  # Если сервис запущен, то перегружаем конфигурации
  if [ "${ws_type}" = "nginx" ]; then
    reload_cmd="/usr/sbin/nginx -c /etc/nginx/conf.ks/nginx.conf -s reload"
  fi;

  if [ "${ws_type}" = "angie" ]; then
    reload_cmd="/usr/sbin/angie -c /etc/angie/conf.ks/angie.conf -s reload"
  fi;

  if [ "${ws_type}" = "apache2" ]; then
    reload_cmd="/usr/sbin/apache2ctl -f /etc/apache2/conf.ks/apache2.conf -k graceful"
  fi;

  fn_file_clr ${host_stdout}
  chmod 777 ${host_stdout}
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${reload_cmd}" -noout


  echo -e "${sOK}Перезагрузка конфигурации http сервера ${ws_type}."
fi;


echo ""

exit 0;