#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -app| --app_monitor)
        app_monitor="$2"
        ;;

      -m| --mode)
        mode="$2"
        ;;


      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры                по умолчанию   описание
 ----------------------   ------------   ------------------------------------------------------
 -app | --app_monitor     prometheus     приложение мониторинга:
                                          - prometheus

 -m   | --mode            restart        Выполняемое действие:
                                          - restart, остановить и запустить
                                          - stop, остановить
                                          - start, запустить

"
exit 1;
fi;

if [ -z "${app_monitor}" ]; then
  app_monitor="prometheus"
fi;

if [ -z "${mode}" ]; then
  mode="restart"
else
  if [ "${mode}" != "start" ] && [ "${mode}" != "stop" ]; then
    mode="restart"
  fi;
fi;

if [ "${app_monitor}" != "prometheus" ]; then
  echo -e "${eRR}Проверка управляемого приложения."
  echo -e "${emptE}Допустимые значения параметра -app: prometheus."
  exit 1;
fi;



# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)

ws_port=$(${dks_bashfile_dir}/ws_const_var.sh ws_port)
ws_type=$(${dks_bashfile_dir}/ws_const_var.sh ws_type)

# Путь установки
dks_inst_path=$($dks_bashfile_dir/ws_const_var.sh dks_inst_path)
dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
tag_name=$($dks_bashfile_dir/ws_const_var.sh      tag_name)
contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)

echo ""

# sudo
is_root=$($dks_bashfile_dir/ws_const_var.sh is_root)
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi

# Проверка и запуск контейнера если не запущен
# Проверяем существование контейнера в docker
dks_exists=$(${contsoft} container ls -a | grep ${dks_cont_name})
if [ -z "$dks_exists" ]; then
  echo -e "${eRR}Проверка существования контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнера ${dks_cont_name} не существует. Операция запуска невозможна."
  echo ""
  exit 1;
fi;

if [ "${app_monitor}" != "prometheus" ]; then
  echo -e "${eRR}Проверка управляемого приложения."
  echo -e "${emptE}Допустимые значения параметра -app: prometheus."
  echo -e "${emptE}Операция запуска невозможна."
  exit 1;
fi;



# управляющий файл приложения
appctlfile_host="${dks_inst_path}/ctl/app/${app_monitor}_sm.sh"
appctlfile_cont="/opt/${tag_name}/ctl/app/${app_monitor}_sm.sh"

uid_whost=$(id -u ks-www-data)
chk_cmd="ps -u ${uid_whost} -ef | grep -E \"/usr/local/bin/prometheus --config.file /etc/prometheus/prometheus_${ws_port}.yml\" | grep -v \"grep -E /usr/local/bin/prometheus --config.file /etc/prometheus/prometheus_${ws_port}.yml\""


if [ -f "${appctlfile_host}" ]; then

  #Остановка
  if [ "${mode}" = "stop" ] || [ "${mode}" = "restart" ]; then

    # Проверяем что уже запущено
    exists_prometheus=$(eval ${chk_cmd})

    if ! [ -z "${exists_prometheus}" ]; then

      bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                       -cn "${dks_cont_name}" \
                                                       -c  "kill -9 \\\$(pidof /usr/local/bin/prometheus)"
      echo -e "${sOK}Остановка приложения ${app_monitor}."
    else
      echo -e "${wOK}Приложение ${app_monitor} уже остановлено."
    fi;

  fi;


  if [ "${mode}" = "start" ] || [ "${mode}" = "restart" ]; then

    # Проверяем что уже запущено
    exists_prometheus=$(eval ${chk_cmd})

    if [ -z "${exists_prometheus}" ]; then

      # Запускаем приложения .NetCore (dotnet)
      start_cmd="/sbin/start-stop-daemon -Sbvx ${appctlfile_cont} \"start\""
      bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                       -cn "${dks_cont_name}" \
                                                       -c  "${start_cmd}"     \
                                                       -u  "www-data"         \
                                                       -noout

      echo -e "${sOK}Запуск приложения ${app_monitor}."
    else
       echo -e "${wOK}Приложение ${app_monitor} уже запущено."
       echo ""
       exit 0;
    fi;

  fi;

else

  echo -e "${eRR}Проверка существования управляющего файла."
  echo -e "${emptE}Файл ${appctlfile_host} не существует."
  echo -e "${emptE}Операция \"${mode}\" невозможна."
  echo ""
  exit 1;

fi;

echo ""

exit 0;
