#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -p| --kestrel_port)
        kestrel_port="$2"
        ;;

      -m| --mode)
        mode="$2"
        ;;


      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры             по умолчанию   описание
 -------------------   ------------   ------------------------------------------------------
 -p | --kestrel_port   54430          кестрел порт развернутого приложения
 -m | --mode           restart        Выполняемое действие:
                                        - restart, остановить и запустить
                                        - stop, остановить
                                        - start, запустить

"
exit 1;
fi;

if [ -z "${kestrel_port}" ]; then
  kestrel_port="54430"
fi;

if [ -z "${mode}" ]; then
  mode="restart"
else
  if [ "${mode}" != "start" ] && [ "${mode}" != "stop" ]; then
    mode="restart"
  fi;
fi;


# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh NoColor)

sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)

ws_type=$(${dks_bashfile_dir}/ws_const_var.sh ws_type)

# Путь установки
dks_inst_path=$($dks_bashfile_dir/ws_const_var.sh dks_inst_path)
dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
tag_name=$($dks_bashfile_dir/ws_const_var.sh      tag_name)
contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)

echo ""

# sudo
is_root=$($dks_bashfile_dir/ws_const_var.sh is_root)
if [ "${is_root}" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi

# Проверка и запуск контейнера если не запущен
# Проверяем существование контейнера в docker
dks_exists=$(${contsoft} container ls -a | grep ${dks_cont_name})
if [ -z "$dks_exists" ]; then
  echo -e "${eRR}Проверка существования контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнера ${dks_cont_name} не существует. Операция запуска невозможна."
  echo ""
  exit 1;
fi;


# управляющий файл приложения
appctlfile_host="${dks_inst_path}/ctl/app/${kestrel_port}_app.sh"
appctlfile_cont="/opt/${tag_name}/ctl/app/${kestrel_port}_app.sh"

# файл для pid процессов
apppidfile_host="${dks_inst_path}/ctl/app/tmp_${kestrel_port}_terminate.txt"

uid_whost=$(id -u ks-www-data)

if [ -f "${appctlfile_host}" ]; then

  #Остановка
  ps -u ${uid_whost} -ef | grep -E "dotnet /var/www/html/wsks_${kestrel_port}" | grep -v "grep" > ${apppidfile_host}

  pid_for_kill=""

  while read LINE
    do
       strfile="$LINE";
       strfile=$(echo ${strfile}  | sed -e "s/[[:space:]]\+/ /g" | cut -f2 -d" ")
       pid_for_kill="${pid_for_kill} ${strfile}"
  done < ${apppidfile_host}

  if ! [ -z "${pid_for_kill}" ]; then

    # если чистый режим старта, то выходим, т.к. уже запущено
    if [ "${mode}" = "start" ]; then
       echo -e "${wOK}Приложение wsks_${kestrel_port} уже запущено."
       echo ""
       exit 0;
    fi;

    kill -9 ${pid_for_kill}
    echo -e "${sOK}Остановка приложения wsks_${kestrel_port}."
    echo -e "${emptE}Pid процесса(ов) хоста для остановки: ${pid_for_kill}"

  fi;

  rm -f ${apppidfile_host}

  if [ "${mode}" = "start" ] || [ "${mode}" = "restart" ]; then

    # Запускаем приложения .NetCore (dotnet)
    start_cmd="/sbin/start-stop-daemon -Sbvx ${appctlfile_cont} \"start\""
    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                     -cn "${dks_cont_name}" \
                                                     -c  "${start_cmd}"     \
                                                     -u  "www-data"         \
                                                     -noout

    echo -e "${sOK}Запуск приложения wsks_${kestrel_port}."
  fi;

else

  echo -e "${eRR}Проверка существования управляющего файла."
  echo -e "${emptE}Файл ${appctlfile_host} не существует."
  echo -e "${emptE}Операция \"${mode}\" невозможна."
  echo ""
  exit 1;

fi;

echo ""

exit 0;
