#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -n|--dns_name)
        dns_name="$2"
        ;;

      -r|--replace)
        replace="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

dks_inst_path=$($dks_bashfile_dir/ws_const_var.sh dks_inst_path)

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры             по умолчанию           описание
 -------------------   ---------------------  ---------------------------------------------------------
 -n | --dns_name       %dns_name_not_define%  доменное имя или ip хоста
 -r | --replace        0                      значение:
                                              - 1, перезаписать файл ${dks_inst_path}/www/html/index.html
                                              - 0, не перезаписывать

"
exit 1;
fi;


if [ -z "${dns_name}" ]; then
  dns_name="%dns_name_not_define%"
fi;

if [ -z "${replace}" ]; then
  replace="0"
fi;


tag_ver=$($dks_bashfile_dir/ws_const_var.sh tag_ver)
ws_port=$($dks_bashfile_dir/ws_const_var.sh ws_port)
ws_type=$($dks_bashfile_dir/ws_const_var.sh ws_type)

ind_file="${dks_bashfile_dir}/index.html"
dns_name="https://${dns_name}:${ws_port}"


cat > ${ind_file} << EOF
<!DOCTYPE html>
<html>
  <head>
    <title>WEB-Сервер-КС ${tag_ver}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  </head>

  <body>
    <i>

  <b>WEB-Сервер-КС ${tag_ver} (${ws_type})</b><br><br>
  Информация о развернутых сервисах:<br><br>

EOF

  for app_info_file in `find ${dks_inst_path}/www/html -type d -name "wsks_*" | sort`
  do
    if [ -f "${app_info_file}/wskstype" ]; then
      wskstype="${app_info_file}/wskstype"

      app_catalog="${app_info_file}"
      app_type=$(echo $(cat ${wskstype} | grep "type=") | sed 's|.*=||')
      app_type_name=$($dks_bashfile_dir/ws_getntype.sh ${app_type})
      app_port=$(echo $(cat ${wskstype} | grep "kestrel_port=") | sed 's|.*=||')
      app_virt=$(echo $(cat ${wskstype} | grep "virt_catalog=") | sed 's|.*=||')
      app_note=$(echo $(cat ${wskstype} | grep "note") | sed 's|.*=||')
      app_ver=$(echo $(cat ${wskstype}  | grep "version") | sed 's|.*=||')

      if [ -z "${app_note}" ]; then
        app_note=${app_type_name}
      fi;

cat << EOF >> ${ind_file}
  <u>${app_type_name}</u>&nbsp&nbsp&nbsp&nbsp&nbsp(версия <b>${app_ver}</b>; id ${app_port})<br>
  &nbsp Адрес: <b><a href="${dns_name}/${app_virt}" target="_blank">${dns_name}/${app_virt}</a></b></br>
  &nbsp Примечание: ${app_note}</br></br>

EOF

    fi;
  done

cat << EOF >> ${ind_file}
  </br></br></br></br>
  </i>
  </body>
</html>

EOF


if [  "${replace}" = "1" ]; then
  cp ${ind_file} ${dks_inst_path}/www/html/index.html
fi;

exit;