#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -m|--mode)
        mode="$2"
        ;;
      -s|--source_dks_name)
        source_dks_name="$2"
        ;;
      -p|--app_port)
        app_port="$2"
        ;;
      -vc|--virt_catalog_in)
        virt_catalog_in="$2"
        ;;


      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры                по умолчанию   описание
 ----------------------   ------------   ---------------------------------------------------------------
 -m | --mode              full            режим:
                                           - full     -- полное клонирование, только для нового приемника
                                           - replace  -- замена существующего на новый с отключением первого
                                           - one      -- клонирование только одного приложения

 -s  | --source_dks_name  443             целевое имя источника для клонирования или замены

 -p  | --app_port                         порт приложения, которое будет копироваться в режиме -m one

 -vc | --virt_catalog_in                  переопределение\назначение виртуального каталога в режиме -m one

"
exit 1;
fi;

if [ -z "${mode}" ]; then
  mode="full";
fi;

source_inst="/opt/${source_dks_name}"

dks_inst_path=$($dks_bashfile_dir/ws_const_var.sh dks_inst_path)
dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
ws_port=$(${dks_bashfile_dir}/ws_const_var.sh     ws_port)
ws_type=$(${dks_bashfile_dir}/ws_const_var.sh     ws_type)
tag_name=$($dks_bashfile_dir/ws_const_var.sh      tag_name)
contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)

# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh      ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh     SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh     WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh       NoColor)

sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)


appMaskAccess400="400"
appMaskAccess755="755"
appMaskAccess777="777"

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~        Клонирование WEB-Сервер-КС 3.1.xxx             "
echo "           ~  Источник: ${source_dks_name}                         "
echo "           ~  Приемник: ${dks_cont_name}                           "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""



# Проверки:
if [ -z "${source_dks_name}" ]; then
  echo -e "${eRR}Не указан параметр источника для клонирования/замены -s (--source_dks_name)."
  echo ""
  exit 1;
fi;


isOK="no"
case "full replace one" in  *"${mode}"*) isOK="yes" ;; esac

if [ ${isOK} = "no" ]; then
  echo -e "${eRR}Неверный параметр режима -m(--mode)."
  echo ""
  exit 1;
fi;

# a) на источнике каталоги /www/html/ не пустые
if ! [ -d "${source_inst}/www/html" ]; then
  echo -e "${eRR}Отсутствует каталог источника ${source_dks_name}."
  echo ""
  exit 1;
fi;

# b) на приемнике каталог /www/html/ пустой или < 10
cnt=0;
# фильтр по всем приложениям
filter_app="*_app.sh"

for target_dir in `find ${dks_inst_path}/www/html -type d -name "wsks_*" | sort`
do
  cnt=$((cnt+1));
done

if [ "${mode}" = "full" ] || [ "${mode}" = "replace" ]; then
  if ! [ "${cnt}" = "0" ]; then
    echo -e "${eRR}Для режима клонирования\замены на приемнике не должно быть"
    echo -e "${emptE}установленных приложений."
    echo ""
    exit 1;
  fi;
fi;

if [ "${mode}" = "one" ]; then
  if ! [ -d "${source_inst}/www/html/wsks_${app_port}" ]; then
    echo -e "${eRR}Отсутствует каталог источника ${source_dks_name} по порту ${app_port}."
    echo ""
    exit 1;
  fi;

  if  [ ${cnt} -ge 100 ]; then
    echo -e "${eRR}Для режима копирования по порту на приемнике"
    echo -e "${emptE}должно быть установлено меньше 100 приложений."
    echo ""
    exit 1;
  fi;

  # фильтр по конкретному приложению
  filter_app="${app_port}_app.sh"
fi;


###########################################
# 1) - остановка сервиса источника и приемника в режимах full и replace
#    - остановка только приложения в режиме one

if [ "${mode}" = "full" ] || [ "${mode}" = "replace" ]; then
  if systemctl -q is-active ${source_dks_name}; then
    systemctl stop ${source_dks_name} 2>/dev/null
    echo -e "${sOK}Остановка сервиса источника ${source_dks_name}."
  else
    echo -e "${sOK}Сервис источника ${source_dks_name} уже остановлен."
  fi;

  if systemctl -q is-active ${dks_cont_name}; then
    systemctl stop ${dks_cont_name} 2>/dev/null
    echo -e "${sOK}Остановка сервиса приемника ${dks_cont_name}."
  else
    echo -e "${sOK}Сервис приемника ${dks_cont_name} уже остановлен."
  fi;
fi;


if [ "${mode}" = "one" ]; then

  bash ${source_inst}/ctl/ws_ctlapp.sh -m stop -p ${app_port}

fi;


###########################################
# 2) источник. список портов + тип + виртуальных каталогов

remote_dir_from_path=$(echo "${source_inst}/ctl/app/"| sed 's/\//\\\//g')
source_ports=""

# порты источника, возможно рабочие, нужно добавить в исключения, за
# исключением полной замены
if [ "${mode}" = "full" ] || [ "${mode}" = "one" ]; then

  for source_port_file in `find ${source_inst}/ctl/app -type f -name "${filter_app}" | sort`
  do
    source_port_file=$(echo ${source_port_file} | sed 's/'${remote_dir_from_path}'/ /g')
    source_port=$(echo ${source_port_file} | sed 's/_app.sh//g')
    source_ports="${source_ports} ${source_port}"
  done

fi;

for port_file in `find ${source_inst}/ctl/app -type f -name "${filter_app}" | sort`
do
  port_file=$(echo ${port_file} | sed 's/'${remote_dir_from_path}'/ /g')
  port=$(echo ${port_file} | sed 's/_app.sh//g')

  # Получили кандидата-порт на рассмотрение
  # echo ${port}
  echo -e "${sOK}Определение порта источника для копирования: ${port}."

  # Проверка существования директории:
  if [ -d ${source_inst}/www/html/wsks_${port} ]; then

    # получаем тип и другие свойства
    wskstype="${source_inst}/www/html/wsks_${port}/wskstype"

    if [ -f "${wskstype}" ]; then

      ###############################################################
      # основные реквизиты

      app_type=$(echo $(cat ${wskstype} | grep "type=") | sed 's|.*=||')
      app_type_name=$(echo $(cat ${wskstype} | grep "type_name=") | sed 's|.*=||')
      virt_catalog=$(echo $(cat ${wskstype} | grep "virt_catalog=") | sed 's|.*=||')

      # для одиночного режима, если виртуальный каталог не определился
      # берем переданный или присваиваем "дежурныый"
      virt_catalog_save=${virt_catalog}
      if [ "${mode}" = "one" ]; then
        if ! [ -z "${virt_catalog_in}" ]; then
           virt_catalog_save=${virt_catalog_in}
        else
          # если пустой, то ставим дежурный
          if [ -z "${virt_catalog_save}" ]; then
            virt_catalog_save="wsks_${kestrel_port}"
          fi;
        fi;
      fi;

      kestrel_port=$(${dks_bashfile_dir}/ws_getport.sh "${ws_port}" "${source_ports}")
      echo -e "${emptE}- новый порт приемника: ${kestrel_port}; тип: ${app_type}; вирт.каталог: ${virt_catalog_save}."

      target_app_start_file="${dks_bashfile_dir}/app/${kestrel_port}_app.sh"
      target_app_conf_etc_catalog="${dks_inst_path}/conf.etc"
      target_app_conf_file="${dks_inst_path}/conf.ks/vhost.ks/${kestrel_port}_ks.conf"
      target_app_catalog="${dks_inst_path}/www/html/wsks_${kestrel_port}"
      target_var_lib_catalog="/var/lib/${dks_cont_name}"


      ###############################################################
      # создаем структуру на приемнике

      # - создать /opt/${dks_inst_path}/www/html/wsks_${port} и дать права
      mkdir -p ${target_app_catalog}
      echo -e "${emptE}- создание каталога ${target_app_catalog}."

      ###############################################################
      # - создать /opt/${dks_inst_path}/ctl/app/${port}_app.sh

      cat ${dks_inst_path}/template/5xxx_app.sh.t | sed 's/@kestrel_port@/'"${kestrel_port}"'/g' > ${target_app_start_file}
      sed -i -e 's/@app_type@/'"${app_type}"'/'                                                    ${target_app_start_file}
      # экранируем символ '/', для избежания ошибок
      app_startdll=""
      app_startdll=$(echo "${app_startdll}"| sed 's/\//\\\//g')
      sed -i -e 's/@app_startdll@/'"${app_startdll}"'/' ${target_app_start_file}

      # стартовая dll стационарная
      startdll=$(${dks_bashfile_dir}/ws_getstartfname.sh "${app_type}")
      sed -i -e 's/@startdll@/'"${startdll}"'/' ${target_app_start_file}

      chown ks-www-data:ks-www-data   ${target_app_start_file}
      chmod ${appMaskAccess755} ${target_app_start_file}

      echo -e "${emptE}- создание файла запуска ${target_app_start_file}."

      ###############################################################
      # - создать /opt/${dks_inst_path}/conf.ks/vhost.ks

      virt_catalog_template=$(echo "${virt_catalog_save}"| sed 's/\//\\\//g')
      cat ${dks_inst_path}/template/5xxx_ks.conf.t | sed 's/@kestrel_port@/'"${kestrel_port}"'/g' > ${target_app_conf_file}
      sed -i 's/@virt_catalog@/'"${virt_catalog_template}"'/g'                                      ${target_app_conf_file}

      echo -e "${emptE}- создание файла конфигурации хоста ${target_app_conf_file}."

      ###############################################################
      # копируем файлы прикладных приложений

      cp -r ${source_inst}/www/html/wsks_${port}/. ${target_app_catalog}
      echo -e "${emptE}- копирование файлов прикладного приложения."
      chown -R ks-www-data:ks-www-data ${target_app_catalog}


      ###############################################################
      # копируем файлы метрик prometeus

      target_prometheus_json_file="${target_app_conf_etc_catalog}/prometheus/sd_files/${kestrel_port}_prometheus.json"

      cp ${dks_inst_path}/template/5xxx_prometheus.json.t    ${target_prometheus_json_file}
      sed -i -e 's/@app_type_name@/'"${app_type_name}"'/'    ${target_prometheus_json_file}
      sed -i -e 's/@kestrel_port@/'"${kestrel_port}"'/'      ${target_prometheus_json_file}

      ###############################################################
      # копирование файлов данных /var/lib/${source_dks_name}/wsks_${port}
      #                           ${target_var_lib_catalog}/wsks_${kestrel_port}

      if [ -d "/var/lib/${source_dks_name}/wsks_${port}" ]; then

         mkdir -p "${target_var_lib_catalog}/wsks_${kestrel_port}"
         cp -r /var/lib/${source_dks_name}/wsks_${port}/. ${target_var_lib_catalog}/wsks_${kestrel_port}
         chown -R ks-www-data:ks-www-data "${target_var_lib_catalog}/wsks_${kestrel_port}"

      fi;


      ###############################################################
      # меняем порт на новый в appsetting.Production.json и wskstype

      appSetProd="appsettings.Production.json"
      if [ -f "${target_app_catalog}/${appSetProd}" ]; then

        sed -i -e 's/http:\/\/0.0.0.0:'"${port}"'/http:\/\/0.0.0.0:'"${kestrel_port}"'/' ${target_app_catalog}/${appSetProd}
        sed -i -e 's/\/var\/www\/html\/wsks_'"${port}"'\//\/var\/www\/html\/wsks_'"${kestrel_port}"'\//' ${target_app_catalog}/${appSetProd}

        echo -e "${emptE}- корректировка порта в файле ${appSetProd}."

      fi;

      wskstype="${target_app_catalog}/wskstype"
      if [ -f "${wskstype}" ]; then

        sed -i -e 's/kestrel_port='"${port}"'/kestrel_port='"${kestrel_port}"'/' ${wskstype}
        sed -i -e 's/virt_catalog='"${virt_catalog}"'/virt_catalog='"${virt_catalog_save}"'/' ${wskstype}

        echo -e "${emptE}- корректировка порта в файле wskstype."

      fi;

      ###############################################################
      # дополнительная корректировка файлов конфига от типа приложения
      # меняем имя контейнера, тюк он совпадает с путями в /var/lib

      if [ "${app_type}" = "sSiUp" ]; then

        appUplConf="uploadservice.config"

        #//<add key="Storage.Location" value="/var/lib/wsks-3.1.18_443/wsks_54432" />

        sed -i -e 's/'"${source_dks_name}"'/'"${dks_cont_name}"'/'       "${target_app_catalog}/${appUplConf}"
        sed -i -e 's/wsks_'"${port}"'/'wsks_"${kestrel_port}"'/'         "${target_app_catalog}/${appUplConf}"
        echo -e "${emptE}- дополнительная корректировка в файле ${appUplConf}."

      fi;

      if [ "${app_type}" = "sUPDS" ]; then

        appUpdConf="updateservice.config"

        sed -i -e 's/'"${source_dks_name}"'/'"${dks_cont_name}"'/'       "${target_app_catalog}/${appUpdConf}"
        sed -i -e 's/wsks_'"${port}"'/'wsks_"${kestrel_port}"'/'         "${target_app_catalog}/${appUpdConf}"
        echo -e "${emptE}- дополнительная корректировка в файле ${appUpdConf}."

      fi;

      if [ "${app_type}" = "wSBck" ]; then

        sed -i -e 's/'"${source_dks_name}"'/'"${dks_cont_name}"'/'         "${target_app_catalog}/${appSetProd}"
        echo -e "${emptE}- дополнительная корректировка в файле ${appSetProd}."

      fi;

      # Проверка поддержки виртуальных каталогов
      is_support_vc=$(echo $(cat ${target_app_catalog}/${appSetProd} | grep "PathBase"))

      if [ -z "${is_support_vc}" ]; then

        echo -e "${wOK}В файле ${appSetProd} отсутствует значение для виртуального каталога."
        echo -e "${emptE}Приложение может работать не корректно или не работать совсем."
        echo -e "${emptE}Для корректной работы необходимо в секциях \"ServiceSettings\": или \"SystemSettings\":"
        echo -e "${emptE}указать значение для виртуального каталога, в формате \"PathBase\": \"<вирт.каталог>\"."
        echo -e "${emptE}Например:"
        echo -e ""
        echo -e "${emptE}  \"ServiceSettings\": {"
        echo -e "${emptE}    \"PathBase\": \"${virt_catalog_save}\""
        echo -e "${emptE}   }"

      fi;

      echo ""
    else

      echo -e "${wOK}Отсутствует файл ${wskstype}."
      echo ""

    fi;

  else

    echo -e "${wOK}Каталог ${source_inst}/www/html/wsks_${port} отсутствует."
    echo ""

  fi;


  #"ServiceSettings": или "SystemSettings": необходимо указать свойства "PathBase": ""


done


if [ "${mode}" = "full" ] || [ "${mode}" = "replace" ]; then

  if [ "${mode}" = "replace" ]; then

    # отключаем сервис источника
    systemctl disable ${source_dks_name} 2>/dev/null
    echo -e "${sOK}Отключение сервиса источника ${source_dks_name}."

  else

    # запускаем сервис источника
    systemctl start ${source_dks_name} 2>/dev/null
    echo -e "${sOK}Запуск сервиса источника ${source_dks_name}."

  fi;

  # запускаем сервис приемника
  systemctl start ${dks_cont_name} 2>/dev/null
  echo -e "${sOK}Запуск сервиса приемника ${dks_cont_name}."
  echo ""
fi;

if [ "${mode}" = "one" ]; then

  # если сервис приемника запущен, то запускаем приложение
  if systemctl -q is-active ${dks_cont_name}; then


    # Если сервис запущен, то перегружаем конфигурации
    if [ "${ws_type}" = "nginx" ]; then
      reload_cmd="/usr/sbin/nginx -c /etc/nginx/conf.ks/nginx.conf -s reload"
    fi;

    if [ "${ws_type}" = "angie" ]; then
      reload_cmd="/usr/sbin/angie -c /etc/angie/conf.ks/angie.conf -s reload"
    fi;

    if [ "${ws_type}" = "apache2" ]; then
      reload_cmd="/usr/sbin/apache2ctl -f /etc/apache2/conf.ks/apache2.conf -k graceful"
    fi;

    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${reload_cmd}" -noout

    echo -e "${sOK}Перезагрузка конфигурации http сервера ${ws_type}."

    bash ${dks_bashfile_dir}/ws_ctlapp.sh -m -p ${kestrel_port}

  fi;

fi;


exit;


