#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

param_in=$1

#============== Основные определяющие переменные ========
tag_ver="@ws_ver@"
tag_name="wsks-"$tag_ver
#========================================================

# Порт и тип http сервера
ws_port="@ws_port@"
ws_type="@ws_type@"
ws_host="@ws_host@"
contsoft="@contsoft@"
locale="@locale@"
prometheus_port="@prometheus_port@"
dks_version="@dks_version@"

# Контейнер
dks_inst_path="/opt/${tag_name}_@ws_port@"
dks_cont_name="${tag_name}_@ws_port@"

# Цвета
ErrColor='\033[1;31m'
SuccColor='\033[0;32m'
WarnColor='\033[0;33m'
NoColor='\033[0m'

sOK="[###${SuccColor}OK${NoColor}###]#"
wOK="[##${WarnColor}Инфо${NoColor}##]#"
eRR="[#${ErrColor}Ошибка${NoColor}#]#"
emptE="###########"

# Файл обмена
host_stdout="/opt/${tag_name}_@ws_port@/log/dks.stdout"
cont_stdout="/var/log/${ws_type}/dks.stdout"

# sudo
is_root=$EUID
#==========================================================



case ${param_in} in
      tag_ver)
          param_out=${tag_ver}
          ;;
      tag_name)
          param_out=${tag_name}
          ;;

      ws_host)
          param_out=${ws_host}
          ;;
      ws_port)
          param_out=${ws_port}
          ;;
      ws_type)
          param_out=${ws_type}
          ;;
      contsoft)
          param_out=${contsoft}
          ;;
      locale)
          param_out=${locale}
          ;;
      prometheus_port)
          param_out=${prometheus_port}
          ;;


      dks_inst_name)
          param_out=${dks_inst_name}
          ;;
      dks_inst_path)
          param_out=${dks_inst_path}
          ;;
      dks_cont_name)
          param_out=${dks_cont_name}
          ;;
      dks_serv_name)
          param_out=${dks_serv_name}
          ;;

      host_stdout)
          param_out=${host_stdout}
          ;;
      cont_stdout)
          param_out=${cont_stdout}
          ;;


      ErrColor)
          param_out=${ErrColor}
          ;;
      SuccColor)
          param_out=${SuccColor}
          ;;
      WarnColor)
          param_out=${WarnColor}
          ;;
      NoColor)
          param_out=${NoColor}
          ;;

      sOK)
          param_out=${sOK}
          ;;
      wOK)
          param_out=${wOK}
          ;;
      eRR)
          param_out=${eRR}
          ;;
      emptE)
          param_out=${emptE}
          ;;


      is_root)
          param_out=${is_root}
          ;;

     *)
          param_out="Неизвестный параметр ${param_in}."
          ;;
esac

echo ${param_out}

exit;
