#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###

_param_name=$1
_param_value=$2
_param_app_type=$3

# Определяем каталог выполнения текущего скрипта
_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

_sOK=$(echo $(${_bashfile_dir}/ws_const_var.sh   sOK) | tr '#' ' ')
_wOK=$(echo $(${_bashfile_dir}/ws_const_var.sh   wOK) | tr '#' ' ')
_eRR=$(echo $(${_bashfile_dir}/ws_const_var.sh   eRR) | tr '#' ' ')
_emptE=$(echo $(${_bashfile_dir}/ws_const_var.sh emptE) | tr '#' ' ')
_emptEsh=$(${_bashfile_dir}/ws_const_var.sh      emptE)

#---------- app_type -------------------------------------------------
if [ ${_param_name} = "app_type" ]; then

  _isTypeOK="no"
  _allType=($(${_bashfile_dir}/ws_getntype.sh allType))

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}Проверка типа добавляемого приложения."
    echo -e "${_emptE}Не указан тип приложения (параметр \"-t\")."
    echo -e "${_emptE}Значение типа должно быть: ${_allType[@]}."
    echo ""
    exit 1;
  else
    # Проверка типа из массива доступных _allType
    for _i in ${!_allType[@]}; do
      if [ "${_allType[$_i]}" = "${_param_value}" ];then
        _isTypeOK="yes"
      fi;
    done;

    if [ "${_isTypeOK}" = "no" ] ; then
      echo -e "${_eRR}Проверка типа добавляемого приложения."
      echo -e "${_emptE}Некорректное значение типа приложения - ${_param_value}."
      echo -e "${_emptE}Значение типа должно быть: ${_allType[@]}."
      echo -e ""
      exit 1;
    fi;
  fi;
fi;


#---------- cryptovendor ----------------------------------------------
if [ ${_param_name} = "cryptovendor" ]; then

  if [ "${_param_value}" != "cpro" ] && [ "${_param_value}" != "vnet" ] && [ "${_param_value}" != "nocheck" ]; then
    echo -e "${_eRR}Некорректное имя провайдера ЭЦП (параметр \"-crtv\")."
    echo -e "${_emptE}Допустимые значения \"cpro\", \"vnet\" и \"nocheck\"."
    echo -e ""
    exit 1;
  fi;

  # Проверка наличия провайдера
  if [ "${_param_value}" = "cpro" ]; then
    if [ ! -f "/opt/cprocsp/lib/amd64/libcapi10.so.4" ]; then
      echo -e "${_eRR}Не установлен модули для работы ЭЦП."
      echo -e "${_emptE}Для установки приложения необходимо установить КриптоПро CSP 4.0 и выше"
      echo -e ""
      exit 1;
    fi;
  fi;

  if [ "${_param_value}" = "vnet" ]; then
    if [ ! -f "/opt/itcs/lib/libcrypt32.so" ]; then
      echo -e "${_eRR}Не установлен модули для работы ЭЦП."
      echo -e "${_emptE}Для установки приложения необходимо установить ViPNet CSP 4.2 и выше."
      echo -e ""
      exit 1;
    fi;
  fi;
  exit 0;

fi;

_msg_header1="Для выбранного типа приложения не указан один из обязательных параметров."
_msg_header2="Необходимо указать параметр"

#---------- crtkey ----------------------------------------------------
if [ ${_param_name} = "crtkey" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-crtk\":"
    echo -e "${_emptE} - ключ шифрования информации в БД."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;

#---------- upd_source ----------------------------------------------------
if [ ${_param_name} = "upd_source" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-u\":"
    echo -e "${_emptE} - внешний сервис источника данных."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;



#---------- mqconn ----------------------------------------------------
if [ ${_param_name} = "mqconn" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-mq\":"
    echo -e "${_emptE} - строка соединения к брокеру сообщений."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;

#---------- dbuser ----------------------------------------------------
if [ ${_param_name} = "dbuser" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-du\":"
    echo -e "${_emptE} - имя пользователя для соединения с БД."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;


#---------- dbpwd  ----------------------------------------------------
if [ ${_param_name} = "dbpwd" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-dpwd\":"
    echo -e "${_emptE} - пароль пользователя БД."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;


#---------- wsuser ----------------------------------------------------
if [ ${_param_name} = "wsuser" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-wu\":"
    echo -e "${_emptE} - имя пользователя-администратора сайта приложения."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;


#---------- wspwd  ----------------------------------------------------
if [ ${_param_name} = "wspwd" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-wpwd\":"
    echo -e "${_emptE} - пароль пользователя-администратора сайта приложения."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;


#---------- servertype  ----------------------------------------------------
if [ ${_param_name} = "servertype" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-st\":"
    echo -e "${_emptE} - тип источника данных (СУБД)."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;


#---------- servername  ----------------------------------------------------
if [ ${_param_name} = "servername" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-sn\":"
    echo -e "${_emptE} - имя источника данных (СУБД)."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;


#---------- dbname  --------------------------------------------------------
if [ ${_param_name} = "dbname" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-dn\":"
    echo -e "${_emptE} - имя базы данных источника данных (СУБД)."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;


#---------- certificate  --------------------------------------------------------
if [ ${_param_name} = "certificate" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-cert\":"
    echo -e "${_emptE} - сертификат для подпиcывания токена."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;

if [ ${_param_name} = "clientid" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-ci\":"
    echo -e "${_emptE} - идентификатор клиентского приложения."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;

if [ ${_param_name} = "clientsecret" ]; then

  if [ -z "${_param_value}" ]; then
    echo -e "${_eRR}${_msg_header1}"
    echo -e "${_emptE}${_msg_header2} \"-cs\":"
    echo -e "${_emptE} - секрет клиентского приложения."
    echo ""
    exit 1;
  fi;
  exit 0;

fi;

#---------- virtual_catalog  ----------------------------------------------------
# проверка "жестких" виртуальных каталогов в соответствии с типом
# или просто зарезервируемых

if [ ${_param_name} = "virt_catalog" ]; then

  _is_passed="1"

  if [[ "${_param_value}" = "ViewerHub" ]] || [[ "${_param_value}" = "viewerhub" ]] ||
     [[ "${_param_value}" = "CasterHub" ]] || [[ "${_param_value}" = "casterhub" ]] ||
     [[ "${_param_value}" = "AgentHub" ]]  || [[ "${_param_value}" = "agenthub" ]]  ||
     [[ "${_param_value}" = "ksmon" && "${_param_app_type}" != "wSM" ]] ||
     [[ "${_param_value}" = "oauth" && "${_param_app_type}" != "sID" ]] ||
     [[ "${_param_value}" = "oauthadmin" && "${_param_app_type}" != "wIDA" ]]; then
    _is_passed="0"
  fi;

  if [ ${_is_passed} = "0" ]; then
    echo -e "${_eRR}Имя виртуального каталога \"${_param_value}\" зарезервировано"
    echo -e "${_emptE}и не может использоваться для типа \"${_param_app_type}\"."
    echo ""
    exit 1;
  fi;

  if [[ "${_param_value}" != "ksmon" && "${_param_app_type}" = "wSM" ]] ||
     [[ "${_param_value}" != "oauth" && "${_param_app_type}" = "sID" ]] ||
     [[ "${_param_value}" != "oauthadmin" && "${_param_app_type}" = "wIDA" ]]; then

    if [ "${_param_app_type}" = "wSM" ];  then _param_value_default="ksmon";      fi;
    if [ "${_param_app_type}" = "sID" ];  then _param_value_default="oauth";      fi;
    if [ "${_param_app_type}" = "wIDA" ]; then _param_value_default="oauthadmin"; fi;

    _is_passed="0"
  fi;

  if [ ${_is_passed} = "0" ]; then
    echo -e "${_eRR}Для приложение с типом \"${_param_app_type}\""
    echo -e "${_emptE}необходимо указать значение виртуального каталога: -vc \"${_param_value_default}\"."
    echo ""
    exit 1;
  fi;

  exit 0;
fi;


exit 0;

