#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2024, ООО "Кейсистемс"
###


# Тестирование запуска прикладного приложения
# Для получения описания параметров выполните ./ws_checkapp.sh --help

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -t|--app_type)
        app_type="$2"
        ;;

      -p|--kestrel_port)
        kestrel_port="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры                 по умолчанию   описание
 -------------------       ------------   ------------------------------------------------------------------------------------
 -t   | --app_type                        Тип обновляемого приложения, например: \"wBKS\".

 -p   | --kestrel_port     54430          Кестрел порт, назначенный приложению. Используется для всех типов приложений.


"
exit 1;
fi;

if [ -z "${kestrel_port}" ]; then
  kestrel_port="54430"
fi;


# Путь установки
dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)
tag_name=$($dks_bashfile_dir/ws_const_var.sh      tag_name)
ws_port=$($dks_bashfile_dir/ws_const_var.sh       ws_port)


echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~    Отладка запуска прикладного приложения WEB-Сервер-КС   "
echo "           ~    Порт : ${kestrel_port}                                 "
echo "           ~    Тип  : ${app_type}                                     "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

echo ""


 # по типу вытаскиваем стартовую dll
 startdll=$(${dks_bashfile_dir}/ws_getstartfname.sh "${app_type}")
 startfile_host="/opt/wsks-6.0.9_${ws_port}/ctl/app/${kestrel_port}_app_debug.sh"
 startfile_cont="/opt/wsks-6.0.9/ctl/app/${kestrel_port}_app_debug.sh"

cat > ${startfile_host} << EOF
#!/bin/bash

  __sOK="[   OK   ] "
  __eRR="[  Ошибка  ] "
  __emptE="           "
  __fileError="/opt/${tag_name}/ctl/app/${kestrel_port}_app_debug.err"

  if [ -f \${__fileError} ]; then
    rm \${__fileError}
  fi;

  cd /var/www/html/wsks_${kestrel_port}
  timeout --preserve-status 10s /opt/.dotnet/dotnet /var/www/html/wsks_${kestrel_port}/${startdll} &>\${__fileError}
  __result=\$?

  if [ "\${__result}" = "0" ]; then
    echo "\${__sOK}Статус возврата выполнения команды @Result=\${__result}."
    echo "\${__emptE}Приложение было запущено без ошибок или истекло время запуска."
    if [ -f \${__fileError} ]; then
      cat \${__fileError}
    fi;
  else
    if [ -f \${__fileError} ]; then
      cat \${__fileError}
    fi;
    echo ""
    echo "\${__eRR}Статус возврата выполнения команды @Result=\${__result}."
  fi;

  if [ -f \${__fileError} ]; then
    rm \${__fileError}
  fi;

  echo "";

exit 0;
EOF

 chown ks-www-data:ks-www-data ${startfile_host}
 chmod 777 ${startfile_host}

 start_cmd="su - www-data -c\"${startfile_cont}\""

 bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                  -cn "${dks_cont_name}" \
                                                  -c  "${start_cmd}"


exit 0;




