#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2022, ООО "Кейсистемс"
###


# Добавление нового dotnet приложения:
# Для получения описания параметров выполните ./ws_addapp.sh --help

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -t|--app_type)
        app_type="$2"
        ;;

      -a|--app_tar_archive)
        app_tar_archive="$2"
        ;;

      -p|--kestrel_port)
        kestrel_port="$2"
        ;;

      -vc|--virt_catalog)
        virt_catalog="$2"
        ;;

      -st  | --servertype)
        servertype="$2"
        ;;

      -sn  | --servername)
        servername="$2"
        ;;

      -dn  | --dbname)
        dbname="$2"
        ;;

      -du  | --dbuser)
        dbuser="$2"
        ;;

      -dpwd| --dbpwd)
        dbpwd="$2"
        ;;

      -wu  | --wsuser)
        wsuser="$2"
        ;;
      -wpwd| --wspwd)
        wspwd="$2"
        ;;

      -crtk| --crtkey)
        crtkey="$2"
        ;;

      -crtv| --cryptovendor)
        cryptovendor="$2"
        ;;

      -mq  | --mqconn)
        mqconn="$2"
        ;;

      -s|--inet_source)
        inet_source="$2"
        ;;

      -u|--upd_source)
        upd_source="$2"
        ;;


      -cert|--certificate)
        certificate="$2"
        ;;

      -ci|--clientid)
        clientid="$2"
        ;;

      -cs|--clientsecret)
        clientsecret="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

# показываем help по параметрам
if [ ! -z "${show_help}" ]; then
 bash ${dks_bashfile_dir}/ws_showhelp.sh
 exit 1;
fi;


# Путь установки
dks_inst_path=$($dks_bashfile_dir/ws_const_var.sh dks_inst_path)
dks_cont_name=$($dks_bashfile_dir/ws_const_var.sh dks_cont_name)
host_stdout=$($dks_bashfile_dir/ws_const_var.sh   host_stdout)
cont_stdout=$($dks_bashfile_dir/ws_const_var.sh   cont_stdout)
dks_serv_name="${dks_cont_name}.service"
contsoft=$($dks_bashfile_dir/ws_const_var.sh      contsoft)
tag_name=$($dks_bashfile_dir/ws_const_var.sh      tag_name)

# Цвета
ErrColor=$($dks_bashfile_dir/ws_const_var.sh      ErrColor)
SuccColor=$($dks_bashfile_dir/ws_const_var.sh     SuccColor)
WarnColor=$($dks_bashfile_dir/ws_const_var.sh     WarnColor)
NoColor=$($dks_bashfile_dir/ws_const_var.sh       NoColor)

sOK=$(echo $($dks_bashfile_dir/ws_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/ws_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/ws_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/ws_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/ws_const_var.sh emptE)

function fn_file_clr(){
cat > $1 << EOF
EOF
}


function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
done
}


echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~    Установка прикладного приложения WEB-Сервер-КС     "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

echo ""

# Переменные по умолчанию ###########################
webType=($(${dks_bashfile_dir}/ws_getntype.sh webType))

isHttpService="yes"
app_startdll=""
isTypeOK="no"
isTypeweb="no"

appMaskAccess400="400"
appMaskAccess755="755"
appMaskAccess777="777"


####################################################

if [ -z "${cryptovendor}" ]; then
  cryptovendor="cpro"
fi;

if [ "${kestrel_port}" = "auto" ]; then
  kestrel_port=""
fi;


# Определяем порт кестрела и тип http сервера
ws_port=$(${dks_bashfile_dir}/ws_const_var.sh ws_port)
ws_type=$(${dks_bashfile_dir}/ws_const_var.sh ws_type)
ws_host=$(${dks_bashfile_dir}/ws_const_var.sh ws_host)

# параметр ws_host появился с версии 3.1.24.020,
# поэтому для совместимости проверяем на "пусто" и возврат из ws_const_var.sh -> "Неизвестный параметр ws_host."
# (если этот параметр не описан) и пытаемся его определить
if [ -z "${ws_host}" ] || [[ "${ws_host}" == *ws_host* ]]; then
  ip_host=$(${dks_bashfile_dir}/sys/sys_hostip.sh)

  if ! [ -z "${ip_host}" ]; then
    ws_host="${ip_host}"
  else
    ws_host="127.0.0.1"
  fi;
fi;


# вычисляем порт, если не передан
if [ -z "${kestrel_port}" ]; then
  kestrel_port=$(${dks_bashfile_dir}/ws_getport.sh ${ws_port})

  # если порт пустой, значит все занято...
  if [ -z "${kestrel_port}" ]; then

    if [ "${ws_port}" = "443" ]; then
       pfive="5"
    fi;

    echo -e "${eRR}Определение значения порта kestrel для добавляемого приложения."
    echo -e "${emptE}Все порты хоста в диапазоне ${pfive}${ws_port}0 - ${pfive}${ws_port}9 для автоматического присваивания заняты."
    echo -e "${emptE}Для установки приложения необходимо указать порт вручную через параметр -p."
    echo -e "${emptE}Значение порта должно быть в диапазоне [54430-65535]."
    echo ""
    exit 1;
  fi;
fi;

if [ -z "${virt_catalog}" ]; then

  # получаем наименование виртуального каталога по умолчанию (если есть конечно)
  virt_catalog=($(${dks_bashfile_dir}/ws_defparams.sh "${app_type}" "virt_catalog"))

  if [ -z "${virt_catalog}" ]; then
    virt_catalog="${app_type}_${kestrel_port}"
  fi;
fi;
virt_catalog_template=$(echo "${virt_catalog}"| sed 's/\//\\\//g')



# Примечание для файла описания (пока не используем, но возможность оставляем)
app_note=""



# Обработка параметра типа с переданной запускающей dll
# формат передачи <тип>:<имя dll>
app_type_all=${app_type}
if [[ "${app_type_all}" == *:* ]]; then
  app_type=$(echo "${app_type_all}" | sed -r 's/:.+//')
  app_startdll=$(echo "${app_type_all}" | sed 's|.*:||')
else
  app_type=${app_type_all}
fi;


# Проверки передачи параметров

# app_type
bash ${dks_bashfile_dir}/ws_checkparams.sh "app_type" "${app_type}"
if [ $? = "1" ]; then exit 1; fi;

# Проверка соответствия зарезервируемых виртуальных каталогов для типов wSM, sID, wIDA
bash ${dks_bashfile_dir}/ws_checkparams.sh "virt_catalog" "${virt_catalog}" "${app_type}"
if [ $? = "1" ]; then exit 1; fi;



# Параметры соединения для web приложений
case "${webType[@]}" in *"${app_type}"*) isTypeweb="yes" ;; esac
if [ "${isTypeweb}" = "yes" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "servertype" "${servertype}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "servername" "${servername}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbname"     "${dbname}"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Параметры для сервиса новостей
if [ "${app_type}" = "wNEWS" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbuser" "${dbuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbpwd"  "${dbpwd}"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Параметры для IDM
if [ "${app_type}" = "wIDM" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbuser" "${dbuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbpwd"  "${dbpwd}"
  if [ $? = "1" ]; then exit 1; fi;

fi;



# Параметры для сервиса авторизации
if [ "${app_type}" = "wSA" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "crtkey" "${crtkey}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbuser" "${dbuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbpwd"  "${dbpwd}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wsuser" "${wsuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wspwd"  "${wspwd}"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Параметры для сервиса воркеров
if [ "${app_type}" = "wSWrk" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "mqconn" "${mqconn}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbuser" "${dbuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbpwd"  "${dbpwd}"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Параметры для сервиса лицензирования
if [ "${app_type}" = "wLs" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbuser" "${dbuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbpwd"  "${dbpwd}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wsuser" "${wsuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wspwd"  "${wspwd}"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Параметры для сервиса лицензирования
if [ "${app_type}" = "wCs" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wsuser" "${wsuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wspwd"  "${wspwd}"
  if [ $? = "1" ]; then exit 1; fi;

fi;


# Параметры для сервиса первички
if [ "${app_type}" = "sSiUp" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "cryptovendor" "${cryptovendor}"
  if [ $? = "1" ]; then exit 1; fi;

fi;


# Параметры для сервиса аутинтификации
if [ "${app_type}" = "sID" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "servertype" "${servertype}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "servername" "${servername}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbname"     "${dbname}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbuser" "${dbuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbpwd"  "${dbpwd}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wsuser" "${wsuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wspwd"  "${wspwd}"
  if [ $? = "1" ]; then exit 1; fi;


  bash ${dks_bashfile_dir}/ws_checkparams.sh "certificate"  "${certificate}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "clientid"  "${clientid}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "clientsecret"  "${clientsecret}"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Параметры для сервиса аутинтификации (администрирование)
if [ "${app_type}" = "wIDA" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "clientsecret"  "${clientsecret}"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Параметры для сервиса планировщика
if [ "${app_type}" = "sTSH" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wsuser" "${wsuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wspwd"  "${wspwd}"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Параметры для МЦУ
if [ "${app_type}" = "wMCU" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "servername" "${servername}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbname"     "${dbname}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbuser" "${dbuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "dbpwd"  "${dbpwd}"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Параметры для КС Центр Администрирования
if [ "${app_type}" = "wAC" ]; then

  bash ${dks_bashfile_dir}/ws_checkparams.sh "upd_source" "${upd_source}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wsuser" "${wsuser}"
  if [ $? = "1" ]; then exit 1; fi;

  bash ${dks_bashfile_dir}/ws_checkparams.sh "wspwd"  "${wspwd}"
  if [ $? = "1" ]; then exit 1; fi;

fi;




# Проверка архива приложения
target_app_tar_file="${dks_bashfile_dir}/tar_files/${app_tar_archive}"
target_app_start_file="${dks_bashfile_dir}/app/${kestrel_port}_app.sh"
target_app_conf_etc_catalog="${dks_inst_path}/conf.etc"
target_app_conf_file="${dks_inst_path}/conf.ks/vhost.ks/${kestrel_port}_ks.conf"
target_app_conf_vh_file="${dks_inst_path}/conf.ks/vhost.ks/${kestrel_port}_vh.conf"
target_app_catalog="${dks_inst_path}/www/html/wsks_${kestrel_port}"
target_var_lib_catalog="/var/lib/${dks_cont_name}"


app_msg_title=$(${dks_bashfile_dir}/ws_getntype.sh ${app_type})

## Порт, проверка только для http сервисов
if [ ${isHttpService} = "yes" ]; then

  bash ${dks_bashfile_dir}/sys/sys_checkport.sh "interval" "${kestrel_port}" "${app_msg_title}" "54430" "65535"
  if [ $? = "1" ]; then exit 1; fi;

fi;

# Проверка "свободности" порта на хосте
bash ${dks_bashfile_dir}/sys/sys_checkport.sh "free" "${kestrel_port}" "${app_msg_title}"
if [ $? = "1" ]; then exit 1; fi;


# Проверка существования приложения с указанным портом
# Определяем по наличию файла запуска приложения

if [ -f "${target_app_start_file}" ]; then
  echo -e "${eRR}Порт ${kestrel_port} уже используется другим приложением. Укажите другой порт."
  echo -e "${emptE}Обнаружен запускающий файл ${target_app_start_file}. Возможно было некорректное удаление предыдущего приложения."
  echo -e "${emptE}Операция установки будет прервана."
  echo ""
  exit 1;
fi;

# Готовим каталог для распаковки + дополнительно проверяем его существование
if [ -d "${target_app_catalog}" ]; then
    echo -e "${eRR}Проверка существования каталога приложения."
    echo -e "${emptE}Каталог уже существует. Возможно было некорректное удаление предыдущего приложения."
    echo -e "${emptE}Операция установки будет прервана."
    echo -e ""
    exit;
fi;


# Назначенный виртуальный каталог
is_exists_virt="0"
for app_info_file in `find ${dks_inst_path}/www/html -type d -name "wsks_*"`
  do
    if [ -f "${app_info_file}/wskstype" ]; then
      wskstype="${app_info_file}/wskstype"
      _app_virt_catalog_check=$(echo $(cat "${wskstype}" | grep "virt_catalog=") | sed 's|.*=||')
      if [ "${_app_virt_catalog_check}" = "${virt_catalog}" ]; then
        is_exists_virt="1"
        break;
      fi;
    fi;
  done


if [ "${is_exists_virt}" = "1" ]; then
  echo -e "${eRR}Проверка виртуального каталога \"${virt_catalog}\"."
  echo -e "${emptE}Приложение с указанным виртуальным каталогом уже существует."
  echo -e "${emptE}Укажите другое имя виртуального каталога."
  echo -e "${emptE}Операция установки будет прервана."
  echo -e ""
  exit;
else
  echo -e "${sOK}Проверка виртуального каталога \"${virt_catalog}\"."
fi;


# Если есть источник для закачки, то пробуем закачать
if ! [ -z "${inet_source}" ]; then
  force_install="yes"
  bash ${dks_bashfile_dir}/ws_wget.sh ${inet_source} ${app_tar_archive} ${force_install}
  if ! [ "$?" == "0" ]; then
    # ошибка закачки файлов или отсутствие новых файлов для обновления
    echo ""
    exit 1;
  fi;
fi;

if [ ! -f "${target_app_tar_file}" ]; then
    echo -e "${eRR}Не найден файл архива добавляемого приложения."
    echo -e "${emptE}Файл архива необходимо поместить в каталог - ${dks_bashfile_dir}/tar_files/."
    echo -e ""
    exit 1;
fi;


# Готовим каталог для распаковки + дополнительно проверяем его существование
if [ -d "${target_app_catalog}" ]; then
    echo -e "${eRR}Проверка существования каталога приложения."
    echo -e "${emptE}Каталог уже существует. Возможно было некорректное удаление предыдущего приложения."
    echo -e "${emptE}Операция установки будет прервана."
    echo -e ""
    exit;
else
  # создаем каталог
  mkdir -p ${target_app_catalog}
  # распаковываем архив
  tar zxf ${target_app_tar_file} -C ${target_app_catalog} --strip-components 1
  if [ $? = "0" ]; then
    echo -e "${sOK}Распаковка архива обновления \"${app_tar_archive}\" в рабочий каталог."
  else
    # удаляем временный каталог обновления
    rm -rf ${target_app_catalog}
    echo -e "${eRR}Ошибка распаковки архива обновления \"${app_tar_archive}\" в рабочий каталог."
    echo -e "${emptE}Операция установки будет прервана."
    echo -e ""
    exit 1;
  fi;


  # считаем хеш файла архива
  archivehash=$(sha1sum "${target_app_tar_file}" | awk '{ print $1 }')

  # определяем версию приложения
  app_file_ver=$(${dks_bashfile_dir}/ws_getverfname.sh "${app_type}")
  app_version=$(${dks_bashfile_dir}/ws_getver.sh "${target_app_catalog}/${app_file_ver}")


  # создаем файл-информатор развертываемого приложения
  echo "type=${app_type}"             > ${target_app_catalog}/wskstype
  app_type_name=$(${dks_bashfile_dir}/ws_getntype.sh ${app_type})
  echo "type_name=${app_type_name}"   >> ${target_app_catalog}/wskstype
  echo "kestrel_port=${kestrel_port}" >> ${target_app_catalog}/wskstype
  echo "virt_catalog=${virt_catalog}" >> ${target_app_catalog}/wskstype
  echo "note=${app_note}"             >> ${target_app_catalog}/wskstype
  echo "archive=${app_tar_archive}"   >> ${target_app_catalog}/wskstype
  echo "archivehash=${archivehash}"   >> ${target_app_catalog}/wskstype
  echo "version=${app_version}"       >> ${target_app_catalog}/wskstype


  # права доступа и владелец
  if [ -d "${target_app_catalog}/" ]; then
    echo -e "${sOK}Создание каталога приложения ${target_app_catalog}."
  else
    echo -e "${eRR}Ошибка создания каталога приложения ${target_app_catalog}."
    echo -e "${emptE}Операция установки будет прервана."
    echo ""
    exit 1;
  fi;

fi;

# Файл запуска\остановки ############################################################################################
cat ${dks_inst_path}/template/5xxx_app.sh.t | sed 's/@kestrel_port@/'"${kestrel_port}"'/g' > ${target_app_start_file}
sed -i -e 's/@app_type@/'"${app_type}"'/'                                                    ${target_app_start_file}

# стартовая dll, переданная на входе
# экранируем символ '/', для избежания ошибок
app_startdll=$(echo "${app_startdll}"| sed 's/\//\\\//g')
sed -i -e 's/@app_startdll@/'"${app_startdll}"'/' ${target_app_start_file}

# стартовая dll стационарная
startdll=$(${dks_bashfile_dir}/ws_getstartfname.sh "${app_type}")
sed -i -e 's/@startdll@/'"${startdll}"'/' ${target_app_start_file}


# Файл для работы мониторнга (prometheus) ##########################################################################
target_prometheus_json_file="${target_app_conf_etc_catalog}/prometheus/sd_files/${kestrel_port}_prometheus.json"

cp ${dks_inst_path}/template/5xxx_prometheus.json.t    ${target_prometheus_json_file}
sed -i -e 's/@app_type_name@/'"${app_type_name}"'/'    ${target_prometheus_json_file}
sed -i -e 's/@kestrel_port@/'"${kestrel_port}"'/'      ${target_prometheus_json_file}

if [ -f "${target_app_start_file}" ]; then
  echo -e "${sOK}Создание файла запуска приложения ${target_app_start_file}."

  if [ "${ws_type}" = "no_http" ]; then
    echo -e "${emptE}Приложение будет доступно по адресу - http://${ws_host}:${kestrel_port}."
  else
    echo -e "${emptE}Приложение будет доступно по адресу - https://${ws_host}:${ws_port}/${virt_catalog}."
  fi;

else
  echo -e "${eRR}Ошибка создания файла запуска приложения ${target_app_start_file}."
  echo -e "${emptE}Операция установки будет прервана."
  echo ""
  exit 1;
fi;

# права доступа и владелец на bash файл запуска
chown ks-www-data:ks-www-data   ${target_app_start_file}
chmod ${appMaskAccess755} ${target_app_start_file}

chown ks-www-data:ks-www-data   ${target_prometheus_json_file}
chmod ${appMaskAccess755} ${target_prometheus_json_file}


##########################################################################################################################

if [ ${isHttpService} = "yes" ]; then

  # Файл конфигурации виртуального хоста##################################################################################
  if ! [ "${ws_type}" = "no_http" ]; then

    cat ${dks_inst_path}/template/5xxx_ks.conf.t | sed 's/@kestrel_port@/'"${kestrel_port}"'/g' > ${target_app_conf_file}

    sed -i 's/@virt_catalog@/'"${virt_catalog_template}"'/g'                                      ${target_app_conf_file}

    if [ -f "${target_app_conf_file}" ]; then
      echo -e "${sOK}Создание файла конфигурации для приложения ${target_app_conf_file}."
    else
      echo -e "${eRR}Ошибка создания файла конфигурации для приложения ${target_app_conf_file}."
      echo -e "${emptE}Операция установки будет прервана."
      echo ""
      exit 1;
    fi;

    # Файл конфигурации EndPoint SignalR ####################################################################################
    if [ "${app_type}" = "wKSRD" ]; then
      cat ${dks_inst_path}/template/5xxx_vh.conf.t | sed 's/@kestrel_port@/'"${kestrel_port}"'/g' > ${target_app_conf_vh_file}
      sed -i 's/@ws_port@/'"${ws_port}"'/g'                                                         ${target_app_conf_vh_file}
      if [ -f "${target_app_conf_vh_file}" ]; then
        echo -e "${sOK}Создание файла конфигурации для приложения ${target_app_conf_vh_file}."
      else
        echo -e "${eRR}Ошибка создания файла конфигурации для приложения ${target_app_conf_vh_file}."
        echo -e "${emptE}Операция установки будет прервана."
        echo ""
        exit 1;
      fi;
    fi;
  fi;


  # Файл настроек для приложения ###########################################################################################

  # Если есть символ '\', то меняем его на '\\' -  так надо в файле настроек json
  # servername=$(echo "${servername}" | sed 's/\\/\\\\/g')
  servername=$(echo "${servername}" | sed 's/\\/\\\\\\\\/g')

  # целевой файл настроек приложения
  appSetProd="appsettings.Production.json"
  t_appSetProd=${appSetProd}

  # в зависимости от приложения, свой шаблон, если существует в папке с шаблонами
  if [ -f "${dks_inst_path}/template/${app_type}.appsettings.Production.json.t" ]; then
    t_appSetProd="${app_type}.appsettings.Production.json"
  fi;

  # для web приложений типа NEXT одинаковый шаблон
  if [ "${app_type}" = "wBKS" ]  || [ "${app_type}" = "wDWH" ] || [ "${app_type}" = "wRVZ" ] ||
     [ "${app_type}" = "wSVOD" ] || [ "${app_type}" = "wADM" ] || [ "${app_type}" = "dDWH" ] ||
     [ "${app_type}" = "wSMT" ]  || [ "${app_type}" = "wMSS" ]; then
    t_appSetProd="web.appsettings.Production.json"
  fi;


  if [ "${app_type}" = "wSWrk" ] || [ "${app_type}" = "wSBck" ] || [ "${app_type}" = "wSM" ] || [ "${app_type}" = "wKSRD" ] || [ "${app_type}" = "wNEWS" ] || [ "${app_type}" = "wMCU" ]; then
    # т.к. порт вынесен в отдельный ключ, вытаскиваем его из параметра servername
    servername_full=${servername}
    if [[ "${servername_full}" == *:* ]]; then
      servername=$(echo "${servername_full}" | sed -r 's/:.+//')
      serverport=$(echo "${servername_full}" | sed 's|.*:||')
    else
      servername=${servername_full}
    fi;
  fi;

  if [ "${app_type}" = "wAC" ]; then
   # Вычисляем md5 пароля пользователя
   temp_hash=$(echo -n "${virt_catalog}${kestrel_port}" | md5sum)
   crtkey=$(echo "md5${temp_hash}" | sed -r 's/ .+//')
  fi;


  # Если есть символ '/', то экранируем его для использования в sed
  # для всех возможных переменных
  servertype=$(echo "${servertype}"| sed 's/\//\\\//g')
  servername=$(echo "${servername}"| sed 's/\//\\\//g')
  serverport=$(echo "${serverport}"| sed 's/\//\\\//g')

  dbname=$(echo "${dbname}"| sed 's/\//\\\//g')
  dbuser=$(echo "${dbuser}"| sed 's/\//\\\//g')
  dbpwd=$(echo "${dbpwd}"| sed 's/\//\\\//g')

  wsuser=$(echo "${wsuser}"| sed 's/\//\\\//g')
  wspwd=$(echo "${wspwd}"| sed 's/\//\\\//g')
  crtkey=$(echo "${crtkey}"| sed 's/\//\\\//g')
  mqconn=$(echo "${mqconn}"| sed 's/\//\\\//g')

  certificate=$(echo "${certificate}"| sed 's/\//\\\//g')
  clientsecret=$(echo "${clientsecret}"| sed 's/\//\\\//g')
  clientid=$(echo "${clientid}"| sed 's/\//\\\//g')

  upd_source=$(echo "${upd_source}"| sed 's/\//\\\//g')


  # создаем файл конфигурации и настроек
  cp ${dks_inst_path}/template/${t_appSetProd}.t    "${target_app_catalog}/${appSetProd}"

  sed -i -e 's/@kestrel_port@/'"${kestrel_port}"'/' "${target_app_catalog}/${appSetProd}"

  sed -i -e 's/@servertype@/'"${servertype}"'/' "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@servername@/'"${servername}"'/' "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@serverport@/'"${serverport}"'/' "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@dbname@/'"${dbname}"'/'         "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@dbuser@/'"${dbuser}"'/'         "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@dbpwd@/'"${dbpwd}"'/'           "${target_app_catalog}/${appSetProd}"

  sed -i -e 's/@ws_host@/'"${ws_host}"'/'       "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@ws_port@/'"${ws_port}"'/'       "${target_app_catalog}/${appSetProd}"

  sed -i -e 's/@wsuser@/'"${wsuser}"'/'         "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@wspwd@/'"${wspwd}"'/'           "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@crtkey@/'"${crtkey}"'/'         "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@mqconn@/'"${mqconn}"'/'         "${target_app_catalog}/${appSetProd}"

  sed -i -e 's/@certificate@/'"${certificate}"'/'    "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@clientsecret@/'"${clientsecret}"'/'  "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@clientid@/'"${clientid}"'/'          "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@upd_source@/'"${upd_source}"'/'      "${target_app_catalog}/${appSetProd}"

  sed -i 's/@virt_catalog@/'"${virt_catalog_template}"'/g'   "${target_app_catalog}/${appSetProd}"
  sed -i -e 's/@token@/'"$(cat /dev/urandom | tr -dc 'a-zA-Z0-9' | head -c 32; echo)"'/'  "${target_app_catalog}/${appSetProd}"


  # для классических веб\смарт приложений создаем каталог для возможного использования кеша SQlite
  # что должно обеспечить работу из "коробки"

  _CreateDbDir="no"
  case "web.appsettings.Production.json appsettings.Production.json wSWrk.appsettings.Production.json" in  *"${t_appSetProd}"*) _CreateDbDir="yes" ;; esac
  if [ ${_CreateDbDir} = "yes" ]; then
    mkdir -p ${target_app_catalog}/temp/db
  fi;

  ##########################################################################################################################

  if [ -f "${target_app_catalog}/${appSetProd}" ]; then
    echo -e "${sOK}Создание файла настроек для приложения ${target_app_catalog}/${appSetProd}."
  else
    echo -e "${eRR}Ошибка создания файла настроек для приложения ${target_app_catalog}/${appSetProd}."
    echo -e "${emptE}Операция установки будет прервана."
    echo ""
    exit 1;
  fi;
fi;

# рабочий каталог данных вне контейнера
data_catalog="${target_var_lib_catalog}/wsks_${kestrel_port}"

# Для сервиса первички корректируем тип провайдера в конфиге приложения + каталог данных
if [ "${app_type}" = "sSiUp" ]; then

  appUplConf="uploadservice.config"

  if [ "${cryptovendor}" = "vnet" ]; then
    # Указываем провайдера и отключаем логирование (по умолчанию провайдер cpro)
    sed -i -e 's/value=\"cpro\"/value=\"vnet\"/; s/.Logging\" value=\"On\"/.Logging\" value=\"Off\"/' ${target_app_catalog}/${appUplConf}
  fi;

  mkdir -p ${data_catalog}/UPLOADS

  # для sed экранируем путевые слеши
  data_catalog_template=$(echo "${data_catalog}"| sed 's/\//\\\//g')

  # Прописываем каталог хранения на хосте
  sed -i -e 's/value=\"App_Data\"/value=\"'${data_catalog_template}'\"/' ${target_app_catalog}/${appUplConf}

  # Поддержка виртуального каталога
  sed -i -e 's/key=\"HttpRequest.PathBase\" value=\"\"/key=\"HttpRequest.PathBase\" value=\"'${virt_catalog_template}'\"/' ${target_app_catalog}/${appUplConf}


  echo -e "${sOK}Корректировка файла настроек ${target_app_catalog}/${appUplConf} для режимов работы с ЭЦП."

fi;

# Для сервиса обновлений корректируем каталог данных и виртуальный каталог
if [ "${app_type}" = "sUPDS" ]; then

  appUpdConf="updateservice.config"

  mkdir -p ${data_catalog}/UPDATES

  # для sed экранируем путевые слеши
  data_catalog_template=$(echo "${data_catalog}"| sed 's/\//\\\//g')

  # Прописываем каталог хранения на хосте
  sed -i -e 's/value=\"App_Data/value=\"'${data_catalog_template}'/' ${target_app_catalog}/${appUpdConf}

  # Поддержка виртуального каталога
  sed -i -e 's/key=\"HttpRequest.PathBase\" value=\"\"/key=\"HttpRequest.PathBase\" value=\"'${virt_catalog_template}'\"/' ${target_app_catalog}/${appUpdConf}

  echo -e "${sOK}Корректировка файла настроек ${target_app_catalog}/${appUpdConf}."

fi;


# для сервиса бакапов создаем каталог данных
if [ "${app_type}" = "wSBck" ]; then

   mkdir -p ${data_catalog}/Files
   data_catalog_template=$(echo "${data_catalog}/Files"| sed 's/\//\\\//g')
   sed -i -e 's/@data_catalog@/'"${data_catalog_template}"'/'         "${target_app_catalog}/${appSetProd}"
   sed -i -e 's/@virt_catalog@/'"${virt_catalog_template}"'/'         "${target_app_catalog}/${appSetProd}"

fi;

if systemctl -q is-active ${dks_serv_name}; then

  # коррекция прав на каталоги
  bash ${dks_bashfile_dir}/ws_setright.sh "${target_app_catalog}"

  right_cmd="chown -R www-data:www-data /var/www/html/wsks_${kestrel_port}"
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${right_cmd}" -noout

  right_cmd="chown -R www-data:www-data ${target_var_lib_catalog}"
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${right_cmd}" -noout

  # Запускаем приложения .NetCore (dotnet)

  start_cmd="bash /opt/${tag_name}/ctl/app/${kestrel_port}_app.sh \"start\""
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                   -cn "${dks_cont_name}" \
                                                   -c  "${start_cmd}"     \
                                                   -u  "www-data"         \
                                                   -noout                 \
                                                   -d                     \

  echo -e "${sOK}Запуск .NET Core приложения."

  # Если сервис запущен, то перегружаем конфигурации
  if [ "${ws_type}" = "nginx" ]; then
    reload_cmd="/usr/sbin/nginx -c /etc/nginx/conf.ks/nginx.conf -s reload"
  fi;

  if [ "${ws_type}" = "angie" ]; then
    reload_cmd="/usr/sbin/angie -c /etc/angie/conf.ks/angie.conf -s reload"
  fi;

  if [ "${ws_type}" = "apache2" ]; then
    reload_cmd="/usr/sbin/apache2ctl -f /etc/apache2/conf.ks/apache2.conf -k graceful"
  fi;


  fn_file_clr ${host_stdout}
  chmod 777 ${host_stdout}
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${reload_cmd}" -noout

  echo -e "${sOK}Перезагрузка конфигурации http сервера ${ws_type}."

else

  # коррекция прав на каталоги (перед запуском службы, чтоб прикладное приложение стратануло)
  bash ${dks_bashfile_dir}/ws_setright.sh "${target_app_catalog}"

  systemctl start ${dks_serv_name}

  # Проверяем что служба запустилась
  if systemctl -q is-active ${dks_serv_name}; then

    right_cmd="chown -R www-data:www-data /var/www/html/wsks_${kestrel_port}"
    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${right_cmd}" -noout

    right_cmd="chown -R www-data:www-data ${target_var_lib_catalog}"
    bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${right_cmd}" -noout

    echo -e "${sOK}Запуск сервиса ${dks_serv_name}."

  else
    echo -e "${eRR}Запуск сервиса ${dks_serv_name}."
    echo -e "${emptE}Была предпринята неудачная попытка запуска сервиса ${dks_serv_name}."
    echo -e "${emptE}Если сервис не будет запущен, то контейнер ${dks_cont_name} не запустится после перезагрузки хоста."
    echo -e "${emptE}Обязательно свяжитесь со свои системным администратором."
    echo ""
    exit 1;
  fi;

fi;

echo ""

exit 0;



