#!/bin/bash

###
### Настройка ротации логов
###
### Copyright (c) 2022, ООО Кейсистемс
###
### Версия 1.0.2
###

_target_logdir=$1
_target_ident=$2
_target_text=$3
_target_user=$4


# === Определяем каталог выполнения текущего скрипта ==========================
_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# файл констант
_const_file="${_bashfile_dir}/sys_const_var.sh"

# файлы лога
_logfiles="${_target_logdir}/*.log"

# файл конфига logrotate
_logrotateconf="/etc/logrotate.d/${_target_ident}.conf"

# пользователь + группа отличные от root
_su_user=""
if ! [ -z "$_target_user" ]; then
   _su_user="su $_target_user $_target_user"
fi;

# Цвета
_sOK=$(echo $(${_const_file} sOK) | tr '#' ' ')
_wOK=$(echo $(${_const_file} wOK) | tr '#' ' ')
_eRR=$(echo $(${_const_file} eRR) | tr '#' ' ')
_emptE=$(echo $(${_const_file} emptE) | tr '#' ' ')
_emptEsh=$(${_const_file}      emptE)

# sudo
_is_root=$(${_const_file} is_root)

# Проверка прав суперпользователя
if [ "${_is_root}" -ne 0 ]; then
  echo -e "${_eRR}Настройка ротации логов ПО \"${_target_text}\"."
  echo -e "${_emptE}Для выполнения текущей операции необходимы права суперпользователя."
  echo -e "${_emptE}Операция настройки ротации логов отменена."
  exit 1;
fi;


# Наличие модуля logrotate
logrotate_exists=$(which logrotate 2>/dev/null)
if [ -z "${logrotate_exists}" ]; then
  echo -e "${_wOK}Настройка ротации логов ПО \"${_target_text}\"."
  echo -e "${_emptE}Отсутствует утилита logrotate."
  echo -e "${_emptE}Операция настройки ротации логов будет отменена."
  exit 1;
fi;

cat > ${_logrotateconf} << EOF
 ${_logfiles} {
     daily
     copytruncate
     rotate 3
     size 1M
     compress
     delaycompress
     ${_su_user}
 }

#
#    daily             - Производить ротацию раз в день
#    copytruncate      - Создать копию оригинального log-файла, а потом его 'обнулить',
#                        таким образом сам файл не удаляется и не меняется его дескриптор
#    rotate 3          - Количество хранимых файлов
#    size 10K          - Производить ротацию, если log-файл превысил указанный размер
#                        указывается в байтах, килобайтах (k), мегабайтах (M)
#    compress          - Архивировать файлы (по умолчанию gzip)
#    delaycompress     - Не сжимать 'свеже' созданный архив
#    su <user> <group> - Обрабатывать журналы с родительскими каталогами, имеющими групповые разрешения,
#                         которые позволяют группам, отличным от root, записывать в эти каталоги

EOF

if [ -f ${_logrotateconf} ]; then
  echo -e "${_sOK}Настройка ротации логов ПО \"${_target_text}\"."
fi;

exit 0;


