#!/bin/bash

###
### Проверка прав root
###
### Copyright (c) 2022, ООО "Кейсистемс"
###
### Версия 1.0.0
###

_mode=$1

if [ -z "${_mode}" ]; then
  _mode="run"
fi;

# === Определяем каталог выполнения текущего скрипта ==========================
_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# файл констант
_sys_const_file="${_bashfile_dir}/sys_const_var.sh"

_sOK=$(echo $(${_sys_const_file} sOK) | tr '#' ' ')
_wOK=$(echo $(${_sys_const_file} wOK) | tr '#' ' ')
_eRR=$(echo $(${_sys_const_file} eRR) | tr '#' ' ')
_emptE=$(echo $(${_sys_const_file} emptE) | tr '#' ' ')
_is_root=$(${_sys_const_file} is_root)

# Проверка прав суперпользователя
if [ "${_is_root}" -ne 0 ]; then

  _msg1="Проверка прав суперпользователя."
  _msg2="Для выполнения текущей операции необходимы права суперпользователя."

  if [ "${_mode}" = "install" ]; then
    echo -e "${_eRR}${_msg1}"
    echo -e "${_emptE}${_msg2}"
    echo -e "${_emptE}Операция установки прервана."
  fi;

  if [ "${_mode}" = "uninstall" ]; then
    echo -e "${_eRR}${_msg1}"
    echo -e "${_emptE}${_msg2}"
    echo -e "${_emptE}Операция удаления прервана."
  fi;

  if [ "${_mode}" = "run" ]; then
    echo -e "${_eRR}${_msg1}"
    echo -e "${_emptE}${_msg2}"
  fi;

  echo -e ""
  exit 1;
fi;

exit 0;