#!/bin/bash

###
### Установка разрешений firewall
###
### Copyright (c) 2022, ООО "Кейсистемс"
###
### Версия 1.0.0
###

_ports=$1
_port_type=$2

# === Определяем каталог выполнения текущего скрипта ==========================
_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# файл констант
_const_file="${_bashfile_dir}/sys_const_var.sh"

if [ -z "${_port_type}" ]; then
  _port_type="tcp"
fi;

_sOK=$(echo $(${_const_file}   sOK)   | tr '#' ' ')
_wOK=$(echo $(${_const_file}   wOK)   | tr '#' ' ')
_eRR=$(echo $(${_const_file}   eRR)   | tr '#' ' ')
_emptE=$(echo $(${_const_file} emptE) | tr '#' ' ')
_emptEsh=$(${_const_file}      emptE)
_host_stdout=$(${_const_file}  host_stdout)


function _fn_file_clr(){
cat > $1 << EOF
EOF
}

function _fn_file_echo() {
local _LeftSpace=$2
_LeftSpace=$(echo ${_LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${_LeftSpace}$line"
 done
}

# Анализируем наличие FireWall и пытаемся добавить правило для открытия порта СУБД
if hash firewall-cmd 2>/dev/null; then
  if systemctl -q is-active firewalld; then
    echo -e "${_sOK}FireWall: Создание\проверка правила для разрешения соединений по порту(ам)."

    for __port in ${_ports[@]}; do

      firewall-cmd --add-port=${__port}/${_port_type}  --permanent >/dev/null 2>${_host_stdout}
      _fn_file_echo ${_host_stdout} ${_emptEsh}
      _fn_file_clr ${_host_stdout}

    done;
    firewall-cmd --reload >/dev/null 2>${_host_stdout}
    #показываем
    _fn_file_echo ${_host_stdout} ${_emptEsh}
    _fn_file_clr ${_host_stdout}

  else
    echo -e "${_wOK}Firewalld не запущен."
    echo -e "${_emptE}Возможно после его запуска нужно будет создать правило для разрешения соединений по портy(ам)."

    for __port in ${_ports[@]}; do

      echo -e "${_emptE}firewall-cmd --add-port=${__port}/${_port_type}  --permanent"

    done;

    echo -e "${_emptE}firewall-cmd --reload"
  fi;
fi;

rm -f ${_host_stdout}

exit 0;
