#!/bin/bash

###
### Системный файл констант
###
### Copyright (c) 2022, ООО Кейсистемс
###
### Версия 1.0.0
###

param_in=$1

_host_stdout="file.stdout"

# Цвета
_ErrColor='\033[1;31m'
_SuccColor='\033[0;32m'
_WarnColor='\033[0;33m'
_NoColor='\033[0m'

_sOK="[###${_SuccColor}OK${_NoColor}###]#"
_wOK="[##${_WarnColor}Инфо${_NoColor}##]#"
_eRR="[#${_ErrColor}Ошибка${_NoColor}#]#"
_emptE="###########"

# sudo
_is_root=$EUID
#==========================================================



case ${param_in} in

      host_stdout)
          param_out=${_host_stdout}
          ;;

      ErrColor)
          param_out=${_ErrColor}
          ;;
      SuccColor)
          param_out=${_SuccColor}
          ;;
      WarnColor)
          param_out=${_WarnColor}
          ;;
      NoColor)
          param_out=${_NoColor}
          ;;

      sOK)
          param_out=${_sOK}
          ;;
      wOK)
          param_out=${_wOK}
          ;;
      eRR)
          param_out=${_eRR}
          ;;
      emptE)
          param_out=${_emptE}
          ;;


      is_root)
          param_out=${_is_root}
          ;;

     *)
          param_out="Неизвестный параметр ${param_in}."
          ;;
esac

echo ${param_out}

exit;
