#!/bin/bash

###
### Проверка и ожидание запуска процесса
###
### Copyright (c) 2022, ООО "Кейсистемс"
###
### Версия 1.0.0
###

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -cs)
        _oci_type="$2"
        ;;
      -cn)
        _cont_name="$2"
        ;;
      -c)
        _cmd_check="$2"
        ;;
      -sn)
        _soft_name="$2"
        ;;

      -t)
        _timeout="$2"
        ;;

      --help)
        _show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${_show_help}" ]; then

echo -e "

    параметры     по умолчанию   описание
    ----------    ------------   ------------------------------------------------------
    -cs           docker         ПО контейнерезации (docker или podman)

    -cn                          наименование контейнера

    -c                           команда-процесс, проверяемая на запуск в контейнере

    -sn                          наименование ПО (заголовок)

    -t            90             время ожидания запуска в секундах

"
exit 1;
fi;

if [ -z ${_oci_type} ]; then
  _oci_type="docker"
fi;

if [ -z ${_timeout} ]; then
  _timeout="90"
fi;

# === Определяем каталог выполнения текущего скрипта ==========================
_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# файл констант
_const_file="${_bashfile_dir}/sys_const_var.sh"

_sOK=$(echo $(${_const_file} sOK) | tr '#' ' ')
_wOK=$(echo $(${_const_file} wOK) | tr '#' ' ')
_eRR=$(echo $(${_const_file} eRR) | tr '#' ' ')
_emptE=$(echo $(${_const_file} emptE) | tr '#' ' ')


# файл логов и результатов
_log_file="${_bashfile_dir}/sys_result.log"

# команда проверки
_cmd_check_run="ps -ef | grep -E '"${_cmd_check}"' | grep -v 'grep'"


_is_exist="no"
for ((_i=1;_i<${_timeout};_i++))
do
  sleep 1
  bash ${_bashfile_dir}/sys_exec_cont_ex.sh -cs "${_oci_type}"       \
                                            -cn "${_cont_name}"      \
                                            -c  "${_cmd_check_run}"  \
                                            -noerr                   \
                                            >   "${_log_file}"

  if [ -s ${_log_file} ]; then
    _is_exist="yes";
    break;
  fi;
done;

rm -f ${_log_file}

if [ "${_is_exist}" = "no" ]; then
  echo -e "${_eRR}Проверка запуска ПО \"${_soft_name}\"."
  echo -e "${_emptE}Процесс \"${_cmd_check}\" не запущен (время ожидания ${_timeout} сек.)."
  echo -e "${_emptE}Операция установки будет прервана."
  echo ""
  exit 1;
fi;

exit 0;


