#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2023, ООО "Кейсистемс"
###

ws_port=$1

if [ -z "${ws_port}" ] ; then
  ws_port=""
fi;

# === Определяем каталог выполнения текущего скрипта ==========================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

tag_name=$($dks_bashfile_dir/dks_const_var.sh  tag_name)
ws_ver=$(${dks_bashfile_dir}/dks_const_var.sh  ws_ver)
dks_version=$(sed -n 1,1p ${dks_bashfile_dir}/dks_version)

# Цвета
sOK=$(echo $($dks_bashfile_dir/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/dks_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/dks_const_var.sh emptE)

# sudo
is_root=$($dks_bashfile_dir/dks_const_var.sh is_root)
is_upgrade="no"

function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}

# Проверка прав суперпользователя
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "install"
if [ $? = "1" ]; then exit 1; fi;


# получаем список каталогов
for inst_dir in $(find /opt -maxdepth 1 -type d | grep -e "${tag_name}_${ws_port}" | grep -v "/opt/dks-${tag_name}")
do
  echo -e ""
  is_upgrade="y"
  echo -e "${sOK}Определение экземпляра ${inst_dir}."


  if [ -d "${inst_dir}/ctl/sys" ]; then

    cp ${dks_bashfile_dir}/sys/sys_exec_cont.sh               ${inst_dir}/ctl/sys/sys_exec_cont.sh
    cp ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh            ${inst_dir}/ctl/sys/sys_exec_cont_ex.sh
    cp ${dks_bashfile_dir}/sys/sys_checkport.sh               ${inst_dir}/ctl/sys/sys_checkport.sh
    cp ${dks_bashfile_dir}/sys/sys_const_var.sh               ${inst_dir}/ctl/sys/sys_const_var.sh
    cp ${dks_bashfile_dir}/sys/sys_checkproc.sh               ${inst_dir}/ctl/sys/sys_checkproc.sh
    cp ${dks_bashfile_dir}/sys/sys_hostip.sh                  ${inst_dir}/ctl/sys/sys_hostip.sh

    echo -e "${sOK}Обновление файлов каталога ${inst_dir}/ctl/sys."

  else

    echo -e "${wOK}Не найден каталог ${inst_dir}/ctl/sys."

  fi;


  if [ -d "${inst_dir}/ctl" ]; then

    # управляющие файлы
    cp $(find ${dks_bashfile_dir}/wsks_files/ctl/ -name "app_*.sh") ${inst_dir}/ctl/
    cp $(find ${dks_bashfile_dir}/wsks_files/ctl/ -name "ws_*.sh")  ${inst_dir}/ctl/

    # Формируем через шаблон -> @ws_ver@
    cp ${dks_bashfile_dir}/wsks_files/ctl/ws_start.sh.t       ${inst_dir}/ctl/ws_start.sh
    sed -i 's/@ws_ver@/'${ws_ver}'/g'                         ${inst_dir}/ctl/ws_start.sh

    # переписываем файл шаблона для web серверов
    if [ "${ws_type}" = "nginx" ]; then
      cp ${dks_bashfile_dir}/wsks_files/template/nginx_5xxx_ks.conf.t   ${inst_dir}/template/5xxx_ks.conf.t
      cp ${dks_bashfile_dir}/wsks_files/template/nginx_5xxx_vh.conf.t   ${inst_dir}/template/5xxx_vh.conf.t
    fi;

    if [ "${ws_type}" = "apache2" ]; then
      cp ${dks_bashfile_dir}/wsks_files/template/apache2_5xxx_ks.conf.t ${inst_dir}/template/5xxx_ks.conf.t
      cp ${dks_bashfile_dir}/wsks_files/template/apache2_5xxx_vh.conf.t ${inst_dir}/template/5xxx_vh.conf.t
    fi;

    if [ "${ws_type}" = "angie" ]; then
      cp ${dks_bashfile_dir}/wsks_files/template/angie_5xxx_ks.conf.t   ${inst_dir}/template/5xxx_ks.conf.t
      cp ${dks_bashfile_dir}/wsks_files/template/angie_5xxx_vh.conf.t   ${inst_dir}/template/5xxx_vh.conf.t
    fi;


    echo -e "${sOK}Обновление файлов каталога ${inst_dir}/ctl."

  else

    echo -e "${wOK}Не найден каталог ${inst_dir}/ctl."

  fi;


  if [ -d "${inst_dir}/template" ]; then

    cp ${dks_bashfile_dir}/wsks_files/template/5xxx_app.sh.t   ${inst_dir}/template/5xxx_app.sh.t

    # копирование шаблонов файлов конфигураций
    cp $(find ${dks_bashfile_dir}/wsks_files/template/ -name "*.appsettings.Production.json.t") ${inst_dir}/template/

    # определяем тип web сервера
    ws_type=$(${inst_dir}/ctl/ws_const_var.sh ws_type)

    # переписываем файл шаблона для web серверов
    if [ "${ws_type}" == "nginx" ]; then
      cp ${dks_bashfile_dir}/wsks_files/template/nginx_5xxx_ks.conf.t    ${inst_dir}/template/5xxx_ks.conf.t
      cp ${dks_bashfile_dir}/wsks_files/template/nginx_5xxx_vh.conf.t    ${inst_dir}/template/5xxx_vh.conf.t
    fi;

    if [ "${ws_type}" == "apache2" ]; then
      cp ${dks_bashfile_dir}/wsks_files/template/apache2_5xxx_ks.conf.t  ${inst_dir}/template/5xxx_ks.conf.t
      cp ${dks_bashfile_dir}/wsks_files/template/apache2_5xxx_vh.conf.t  ${inst_dir}/template/5xxx_vh.conf.t
    fi;

    if [ "${ws_type}" == "angie" ]; then
      cp ${dks_bashfile_dir}/wsks_files/template/angie_5xxx_ks.conf.t    ${inst_dir}/template/5xxx_ks.conf.t
      cp ${dks_bashfile_dir}/wsks_files/template/angie_5xxx_vh.conf.t    ${inst_dir}/template/5xxx_vh.conf.t
    fi;


    echo -e "${sOK}Обновление файлов каталога ${inst_dir}/template."

  else

    echo -e "${wOK}Не найден каталог ${inst_dir}/template."

  fi;

  # файл версии
  rm -f ${inst_dir}/dks_version
  echo "${dks_version}" > ${inst_dir}/dks_version

done;

if [ "${is_upgrade}" = "no" ]; then
  echo -e ""
  echo -e "${wOK}Нет данных для обновления."
  echo -e "${emptE}Не найдено ни одного установленного экземпляра."
fi;

echo ""

exit;




