#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2023, ООО "Кейсистемс"
###

ws_port=$1
mode=$2

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

#============== Основные переменные ============================================
tag_name=$($dks_bashfile_dir/dks_const_var.sh tag_name)
dks_cont_name=$($dks_bashfile_dir/dks_const_var.sh dks_cont_name)
dks_inst_path=$($dks_bashfile_dir/dks_const_var.sh dks_inst_path)
app_inst_path=$($dks_bashfile_dir/dks_const_var.sh app_inst_path)
app_var_lib_path=$($dks_bashfile_dir/dks_const_var.sh app_var_lib_path)

# Цвета
sOK=$(echo $($dks_bashfile_dir/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/dks_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/dks_const_var.sh emptE)

# Цвета
ErrColor=$($dks_bashfile_dir/dks_const_var.sh ErrColor)
SuccColor=$($dks_bashfile_dir/dks_const_var.sh SuccColor)
WarnColor=$($dks_bashfile_dir/dks_const_var.sh WarnColor)
NoColor=$($dks_bashfile_dir/dks_const_var.sh NoColor)


function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}

#==========================================================

echo ""
is_delete="no"

# Файл обмена
dks_stdout=$($dks_bashfile_dir/dks_const_var.sh dks_stdout)

fn_file_clr $dks_stdout
chmod 777 $dks_stdout


# Проверка прав суперпользователя
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "install"
if [ $? = "1" ]; then exit 1; fi;

# Проверка не пустого порта в диапазоне [5444-5493]
port_correct="no"
if [ "${ws_port}" = "443" ]; then
  port_correct="yes"
else
  bash ${dks_bashfile_dir}/sys/sys_checkport.sh "interval" "${ws_port}" "${wsks_msg_title}" "5444" "5493"
  if [ $? = "1" ]; then exit 1; fi;
  port_correct="yes"
fi;



# Окончательные пути развернутого контейнера
inst_path="${app_inst_path}_${ws_port}"
dks_cont_name="${dks_cont_name}_${ws_port}"
dks_serv_name="${dks_cont_name}.service"


#ПО контейнеризации, определяем по файлу, если он есть
if [ -f "${inst_path}/ctl/ws_const_var.sh" ]; then

  contsoft=$(${inst_path}/ctl/ws_const_var.sh contsoft)

  # Удаление принудительно контейнер+образ
  ${contsoft} container inspect ${dks_cont_name} >/dev/null 2>&1
  if [ $? -eq 0 ]; then
    echo -e "${sOK}Удаление контейнера ${dks_cont_name}."
    ${contsoft} rm -f ${dks_cont_name} >/dev/null
  fi;

  ${contsoft} image inspect ${dks_cont_name} >/dev/null 2>&1
  if [ $? -eq 0 ]; then
    echo -e "${sOK}Удаление образа ${dks_cont_name}."
    ${contsoft} rmi -f ${dks_cont_name} >/dev/null
  fi;

  ${contsoft} image inspect ${tag_name} >/dev/null 2>&1
  if [ $? -eq 0 ]; then
    echo -e "${sOK}Удаление базового образа ${tag_name}."
    ${contsoft} rmi -f ${tag_name} >/dev/null
  fi;

fi;

# Если есть сервис то удаляем его
if [ -f "/lib/systemd/system/${dks_serv_name}" ]; then
  rm /lib/systemd/system/${dks_serv_name} -f
  echo -e "${sOK}Удаление сервиса /lib/systemd/system/${dks_serv_name}."
  is_delete="yes"
fi;

# файл конфига logrotate
if [ -f "/etc/logrotate.d/${tag_name}_${ws_port}.conf" ]; then
  rm -f "/etc/logrotate.d/${tag_name}_${ws_port}.conf"
fi;


# Если задан режим полной очистки, то удаляем и каталог
if [ "${mode}" = "all" ]; then
  if [ -d "${inst_path}" ]; then
    echo -e "${sOK}Задан режим полного удаления."
    rm -R ${inst_path} -f
    echo -e "${emptE}Удаление каталога ${inst_path}."
    rm -R ${app_var_lib_path}_${ws_port}
    echo -e "${emptE}Удаление каталога ${app_var_lib_path}_${ws_port}."
    is_delete="yes"
  fi;
fi;


if [ "${is_delete}" = "no" ]; then
  echo -e "${wOK}Нет данных для удаления."
fi

rm ${dks_stdout}

echo ""
exit;

