#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2023, ООО "Кейсистемс"
###

ws_port=$1
contsoft=$2
locale=$3
prometheus_port=$4

if [ -z "${ws_port}" ] ; then
  ws_port=""
fi;

# === Определяем каталог выполнения текущего скрипта ==========================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

tag_name=$($dks_bashfile_dir/dks_const_var.sh  tag_name)
ws_ver=$(${dks_bashfile_dir}/dks_const_var.sh  ws_ver)
dks_version=$(sed -n 1,1p ${dks_bashfile_dir}/dks_version)

# Цвета
sOK=$(echo $($dks_bashfile_dir/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/dks_const_var.sh emptE) | tr '#' ' ')
emptEsh=$($dks_bashfile_dir/dks_const_var.sh emptE)

# sudo
is_root=$($dks_bashfile_dir/dks_const_var.sh is_root)
is_upgrade="no"

function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}

# Проверка прав суперпользователя
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "install"
if [ $? = "1" ]; then exit 1; fi;

is_rebuild="no"

# получаем список каталогов
for inst_dir in $(find /opt -maxdepth 1 -type d | grep -e "${tag_name}_${ws_port}" | grep -v "/opt/dks-${tag_name}")
do
  echo -e ""
  is_rebuild="yes"
  is_can_rebuild="yes"

  echo -e "${sOK}Определение экземпляра ${inst_dir}."

  inst_info_file="${inst_dir}/ctl/ws_const_var.sh"
  if [ -f "${inst_info_file}" ]; then

    ws_port=$(${inst_info_file} ws_port)
    ws_host=$(${inst_info_file} ws_host)
    ws_type=$(${inst_info_file} ws_type)

    if [ -z "${prometheus_port}" ]; then
      prometheus_port=$(${inst_info_file} prometheus_port)

      if [ -z "${prometheus_port}" ] || ! [ -z "$(echo ${prometheus_port} | grep prometheus_port)" ]; then
        echo -e "${eRR}Не указан порт ПО prometheus."
        is_can_rebuild="no"
      fi;
    fi;

    if [ -z "${contsoft}" ]; then
      contsoft=$(${inst_info_file} contsoft)
      if [ -z "${contsoft}" ] || ! [ -z "$(echo ${contsoft} | grep contsoft)" ]; then
        echo -e "${eRR}Не указан ПО контейнеризации."
        is_can_rebuild="no"
      fi;
    fi;

    if [ -z "${locale}" ]; then
      locale=$(${inst_info_file} locale)
      if [ -z "${locale}" ] || ! [ -z "$(echo ${locale} | grep locale)" ]; then
        echo -e "${eRR}Не указана locale."
        is_can_rebuild="no"
      fi;
    fi;

    rebuild="1"


    if [ "${is_can_rebuild}" = "yes" ];then

      echo ""
      echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
      echo "           ~     Пересоздание контейнера WEB-Сервер-КС           "
      echo "           ~        http сервер: ${ws_type}                     "
      echo "           ~           порт\\id : ${ws_port}                     "
      echo "           ~   контейнеризация : ${contsoft}                    "
      echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

      bash ${dks_bashfile_dir}/dks_create.sh "${ws_host}"         \
                                             "${ws_port}"         \
                                             "${ws_type}"         \
                                             "${prometheus_port}" \
                                             "${contsoft}"        \
                                             "${locale}"          \
                                             "${rebuild}"

    fi;
  else

    echo -e "${eRR}Не найден информационный файл ${inst_info_file}."

  fi;


done;

if [ "${is_rebuild}" = "no" ]; then
  echo -e ""
  echo -e "${wOK}Нет данных для пересоздания."
  echo -e "${emptE}Не найдено ни одного установленного экземпляра."
fi;

echo ""

exit;




