#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2023, ООО "Кейсистемс"
###

param_in=$1
versoft="6.0.9"

#============== Основные определяющие переменные ========
tag_ver="${versoft}"
tag_name="wsks-${tag_ver}"
tag_year="2023"
#========================================================


# Контейнер
dks_inst_path="/opt/dks-${tag_name}"
dks_cont_name=${tag_name}
app_inst_path="/opt/${tag_name}"
app_var_lib_path="/var/lib/${tag_name}"

# Цвета
ErrColor='\033[1;31m'
SuccColor='\033[0;32m'
WarnColor='\033[0;33m'
NoColor='\033[0m'

sOK="[###${SuccColor}OK${NoColor}###]#"
wOK="[##${WarnColor}Инфо${NoColor}##]#"
eRR="[#${ErrColor}Ошибка${NoColor}#]#"
emptE="###########"

# Файл обмена
dks_stdout="${dks_inst_path}/sh/dks.stdout"

# порты сторонних программ (по умолчанию)
prometheus_port="9093"

# sudo
is_root=$EUID
#==========================================================



case ${param_in} in
      tag_ver)
          param_out=${tag_ver}
          ;;
      ws_ver)
          param_out=${tag_ver}
          ;;
      tag_name)
          param_out=${tag_name}
          ;;

      dks_inst_name)
          param_out=${dks_inst_name}
          ;;
      dks_inst_path)
          param_out=${dks_inst_path}
          ;;
      dks_cont_name)
          param_out=${dks_cont_name}
          ;;
      dks_stdout)
          param_out=${dks_stdout}
          ;;


      app_inst_path)
          param_out=${app_inst_path}
          ;;
      app_var_lib_path)
          param_out=${app_var_lib_path}
          ;;

      ErrColor)
          param_out=${ErrColor}
          ;;
      SuccColor)
          param_out=${SuccColor}
          ;;
      WarnColor)
          param_out=${WarnColor}
          ;;
      NoColor)
          param_out=${NoColor}
          ;;

      sOK)
          param_out=${sOK}
          ;;
      wOK)
          param_out=${wOK}
          ;;
      eRR)
          param_out=${eRR}
          ;;
      emptE)
          param_out=${emptE}
          ;;

      prometheus_port)
          param_out=${prometheus_port}
          ;;

      is_root)
          param_out=${is_root}
          ;;

     *)
          param_out="Неизвестный параметр ${param_in}."
          ;;
esac

echo ${param_out}

exit;
