#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2023, ООО "Кейсистемс"
###

# === Определяем каталог выполнения текущего скрипта ==================================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
versoft="6.0.9"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -p|--ws_port)
        ws_port="$2"
        ;;

      -pp|--prometheus_port)
        prometheus_port="$2"
        ;;


      -cs|--contsoft)
        contsoft="$2"
        ;;

      -l|--locale)
        locale="$2"
        ;;

      -q|--quiet)
        quiet="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры                по умолчанию   описание
 ----------------------   ------------   ------------------------------------------------------
 -p  | --ws_port                         рабочий порт\\id экземпляра, если не указан,
                                         то перестраиваются все установленные экземпляры

 -pp | --prometheus_port                 рабочий http порт модуля мониторинга prometheus

 -cs | --contsoft                        ПО контейнеризации (docker или podman)

 -l  | --locale                          локаль для инициализации в контейнере

 -q  | --quiet                           выполнение операции удаления без подтверждения

"
exit 1;
fi;

WarnColor='\033[0;33m'
NoColor='\033[0m'
uQY="[ ${WarnColor}Запрос${NoColor} ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~  Пересоздание контейнеров WEB-Сервер-КС ${versoft} "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""

if [ -z "${quiet}" ]; then
  echo ""
  echo -n -e "${uQY}Вы действительно хотите персоздать контейнеры по порту(ам)\\id \"${ws_port}\"?
           ([да;y]/[N;нет;n]): "

  read item
  case "$item" in
    y|Y|да)
        ;;
    n|N|нет|"") echo -e "${emptE}Операция пересоздания прервана."; echo "";
        exit;
        ;;
    *) echo -e "${emptE}Операция пересоздания прервана."; echo "";
        exit;
        ;;
  esac
fi;




bash ${dks_bashfile_dir}/sh/dks_rebuild.sh "${ws_port}"         \
                                           "${contsoft}"        \
                                           "${locale}"          \
                                           "${prometheus_port}"

exit 0;
