#!/bin/bash

###
### WEB-Сервер-КС
###
### Copyright (c) 2023, ООО "Кейсистемс"
###

# === Определяем каталог выполнения текущего скрипта ==================================
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
versoft="6.0.9"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -p|--ws_port)
        ws_port="$2"
        ;;

      -pp|--prometheus_port)
        prometheus_port="$2"
        ;;

      -ws|--ws_type)
        ws_type="$2"
        ;;

      -cs|--contsoft)
        contsoft="$2"
        ;;

      -l|--locale)
        locale="$2"
        ;;


      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры                по умолчанию   описание
 ----------------------   ------------   ------------------------------------------------------
 -ws | --ws_type          nginx          тип используемого http сервера:
                                             - nginx   -> Nginx
                                             - apache2 -> Apache
                                             - angie   -> Angie
                                             - no_http -> http сервер не устанавливается

 -h  | --ws_host          127.0.0.1      ip адрес хоста

 -p  | --ws_port          443            рабочий порт http сервера

 -pp | --prometheus_port  9093           рабочий http порт модуля мониторинга prometheus

 -cs | --contsoft         docker         ПО контейнеризации (docker или podman)

 -l  | --locale           ru_RU.UTF-8    локаль для инициализации в контейнере

"
exit 1;
fi;

if [ -z "${ws_host}" ] ; then
  ws_host="127.0.0.1"
fi;

if [ -z "${ws_port}" ] ; then
  ws_port="443"
fi;

if [ -z "${prometheus_port}" ] ; then
  prometheus_port="9093"
fi;

if [ -z "${ws_type}" ] || [[ "${ws_type}" != "apache2" && "${ws_type}" != "angie" && "${ws_type}" != "no_http" ]]; then
  ws_type="nginx"
fi;

if [ -z "${contsoft}" ]; then
  contsoft="docker"
fi;

if [ ! ${contsoft} = "docker" ]; then
  contsoft="podman"
fi;

if [ -z "${locale}" ]; then
  locale="ru_RU.UTF-8"
fi;



echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~     Установка контейнера WEB-Сервер-КС             "
echo "           ~        http сервер: ${ws_type}                     "
echo "           ~           порт\\id : ${ws_port}                     "
echo "           ~   контейнеризация : ${contsoft}                    "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

bash ${dks_bashfile_dir}/sh/dks_create.sh "${ws_host}"         \
                                          "${ws_port}"         \
                                          "${ws_type}"         \
                                          "${prometheus_port}" \
                                          "${contsoft}"        \
                                          "${locale}"

exit 0;
