#!/bin/bash

###
### Резервное копирование баз СУБД-КС с помощью задачи cron
###
### Copyright (c) 2023, ООО Кейсистемс
###
### Версия 20230227

#          Порядок установки:
# 1. Установите параметры скрипта.
# 2. Дайте скрипту права на выполнение.
# 3. Пропишите запуск задания в Cron данного скрипта в указанное время.
#    Логи будут лежать в каталогах с бэкапами.

# ========================= Параметры скрипта =========================
pgsqlks_ver="pgsqlks-14.10"		 		# версия pgsqlks
pgsqlks_port="5434" 					# порт pgsqlks
DbNames="test:test2"		 			# имена резервируемых баз через знак ":", например budget2022:budget2023
pgsqlks_back="/var/lib/pgsqlks-14.10_5435/backups"	# путь к резервным копиям должен быть доступен из контейнера, копии будут в подпапках
v_days=7;						# количество дней, в течение которых будет храниться резервная копия базы данных
#======================================================================


bashfile_name="${0##*/}"
bashfile_log_name="${0##*/}.log"
dks_bashfile_dir="$( cd $( dirname ${BASH_SOURCE[0]} ) >/dev/null 2>&1 && pwd )"

# ротация лога скрипта, по умолчанию 15000 строк
if [ -f "${dks_bashfile_dir}/${bashfile_log_name}" ]; then
    if [[ $((RANDOM%100)) -lt 30 && -f "${dks_bashfile_dir}/${bashfile_log_name}" ]]; then
       tail --lines=15000 --silent "${dks_bashfile_dir}/${bashfile_log_name}" > "${dks_bashfile_dir}/${bashfile_log_name}.cut"
       mv "${dks_bashfile_dir}/${bashfile_log_name}.cut" "${dks_bashfile_dir}/${bashfile_log_name}"
    fi
fi

echo "" >> ${dks_bashfile_dir}/${bashfile_log_name}
echo "=================================================================" >> ${dks_bashfile_dir}/${bashfile_log_name}
echo "Скрипт \"${bashfile_name}\" запущен: $(date +'%d.%m.%Y %H:%M:%S')" >> ${dks_bashfile_dir}/${bashfile_log_name}
echo "=================================================================" >> ${dks_bashfile_dir}/${bashfile_log_name}

# определяем под кем запущен процесс ${pgsqlks_ver}_${pgsqlks_port}
pgsqlks_user=$(ps -e --format="uname cmd" | grep ${pgsqlks_ver}_${pgsqlks_port} | grep -v grep | awk -F ' ' '{print $1}' | tr -d '[:space:]')
if [ -z "${pgsqlks_user}" ]; then
    echo -e "Не удалось определить имя пользователя для ${pgsqlks_ver}_${pgsqlks_port}!"
    echo -e "* Не удалось определить имя пользователя для ${pgsqlks_ver}_${pgsqlks_port}!" >> ${dks_bashfile_dir}/${bashfile_log_name}
    echo -e "* Выполнение скрипта прервано!" >> ${dks_bashfile_dir}/${bashfile_log_name}
    exit 1;
fi;
if [ $(echo ${pgsqlks_user: -1:1}) == "+" ]; then
    pgsqlks_user=$(cat /etc/passwd | grep $(echo ${pgsqlks_user: 0:7}) | awk -F ':' '{print $1}')
    # если длина пользователя больше 8 символов, то полное имя ищем в /etc/passwd
fi;
echo "* СУБД-КС \"${pgsqlks_ver}_${pgsqlks_port}\" запущен под пользователем \"${pgsqlks_user}\"" >> ${dks_bashfile_dir}/${bashfile_log_name}

# определяем перечень баз
IFS=':' read -r -a DbNames_array <<< "${DbNames}"
unset IFS
DbNames_array_count=${#DbNames_array[*]}
if [ $DbNames_array_count == 0 ]; then
   echo -e "Базы для резервного копирования не указаны!"
   echo -e "* Базы для резервного копирования не указаны!" >> ${dks_bashfile_dir}/${bashfile_log_name}
   echo -e "* Выполнение скрипта прервано!" >> ${dks_bashfile_dir}/${bashfile_log_name}
   exit 1;
fi;

for DbName in ${DbNames_array[@]}; do
    # проверяем существование БД в инстансе СУБД-КС
    db_exist="$(bash /opt/$pgsqlks_ver/utility/$pgsqlks_port/psql.sh -h 127.0.0.1 -t 36000 -k "-t " -c "SELECT 1 FROM pg_database WHERE datname='${DbName}'" | grep -v "Docker_sql_command_completed" | sed 's/Ожидание завершения выполнения SQL команды.*сек.)//' | tr -d '[:space:]')"
    #db_exist="1"

    if [[ ${db_exist} == "1" ]]; then
        # генерируем имена файлов
        date_tmp=$(date "+%Y%m%d_%H%M%S")
        back_file="${DbName}_${date_tmp}.bak"		 # имя бекапа 
        back_log="${DbName}_${date_tmp}.log"		 # имя лога бекапа
        clean_log="clean.log"				 # имя лога удаления старых бекапов
        pgsqlks_back_path="${pgsqlks_back}/${DbName}"	 # путь бекапа текущей базы

        # создаем каталоги для бекапов
        mkdir -p ${pgsqlks_back_path}
        chown -R ${pgsqlks_user}:${pgsqlks_user} ${pgsqlks_back_path}
        chmod -R 770 ${pgsqlks_back_path}

        # делаем бекап БД
        echo -e "* Резервное копирование \"${DbName}\" в \"$pgsqlks_back_path/$back_file\" запущено..." >> ${dks_bashfile_dir}/${bashfile_log_name}
        bash /opt/$pgsqlks_ver/utility/$pgsqlks_port/psql.sh -h 127.0.0.1 -t 36000 -c "select xp_pg_dump ( v_DbName := '${DbName}', v_Path := '$pgsqlks_back_path' ,v_File := '$back_file');" | sed 's/Ожидание завершения выполнения SQL команды.*сек.)//' | tee ${pgsqlks_back_path}/${back_log} | tee -a ${dks_bashfile_dir}/${bashfile_log_name}

        # удаляем старые бекапы
        echo -e "* Начато удаление старых копий в \"${pgsqlks_back_path}\" ..." >> ${dks_bashfile_dir}/${bashfile_log_name}
        # find ${pgsqlks_back_path} -maxdepth 1 -mount -mtime +${v_days} -name "${DbName}_*" -execdir echo -e $(date +"%d.%m.%Y %H:%M:%S") "Планируем удалить в текущем каталоге файлы старше ${v_days} дней: {}." \; -delete -execdir echo -e $(date +"%d.%m.%Y %H:%M:%S") "Файл удален: {}.\n" \; | tee -a ${pgsqlks_back_path}/${clean_log} | tee -a ${dks_bashfile_dir}/${bashfile_log_name}
        find ${pgsqlks_back_path} -maxdepth 1 -mount -mtime +${v_days} -name "${DbName}_*" -execdir echo -e $(date +"%d.%m.%Y %H:%M:%S") "Планируем удалить в текущем каталоге файлы старше ${v_days} дней: {}." \; -delete -execdir echo -e $(date +"%d.%m.%Y %H:%M:%S") "Файл удален: {}.\n" \; | tee -a ${dks_bashfile_dir}/${bashfile_log_name}
    else
        echo -e "* БД с именем ${DbName} не найдена!" >> ${dks_bashfile_dir}/${bashfile_log_name}
    fi
done
echo -e "* Выполнение скрипта завершено." >> ${dks_bashfile_dir}/${bashfile_log_name}
