#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"


while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -p|--port)
        port="$2"
        ;;
      -q|--quiet)
        quiet="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -p  | --port           5434           порт СУБД
 -q  | --quiet                         выполнение операции удаления без подтверждения
"
exit 1;
fi;

if [ -z "${port}" ]; then
  port="5434"
fi;

WarnColor='\033[0;33m'
NoColor='\033[0m'
uQY="[ ${WarnColor}Запрос${NoColor} ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~   Удаление контейнера СУБД-КС 14.13 порт ${port}"
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"


if [ -z "${quiet}" ]; then
  echo ""
  echo -n -e "${uQY}Вы действительно хотите удалить контейнер по порту \"${port}\"?
           ([да;y]/[N;нет;n]): "

  read item
  case "$item" in
    y|Y|да)
        ;;
    n|N|нет|"") echo -e "${emptE}Операция удаления прервана."; echo "";
        exit;
        ;;
    *) echo -e "${emptE}Операция удаления прервана."; echo "";
        exit;
        ;;
  esac
fi;

bash ${dks_bashfile_dir}/sh/dks_remove.sh "${port}"

exit;

