#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -id|--node_id)
        node_id="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -id  | --node_id                      Идентификатор исключаемого standby узла

"
exit 1;
fi;

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~  Исключение standby узла СУБД-КС @tag_ver@   "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""


# sudo
is_root=$EUID
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi


if [ -z  "${node_id}" ]; then
  echo -e "${eRR}Проверка входных параметров"
  echo -e "${emptE}Не задан параметр-идентификатор \"-id\" исключаемого standby узла."
  exit 1;
fi


# Константы каталогов pgsqlks
db_bin_path="@db_bin_path@"

# Запускаем разрегистрацию узла на мастере
bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr standby unregister -f /etc/repmgr/repmgr.conf --node-id=${node_id}" \
                                 "Исключение standby узла из состава репликации" \
                                 "top"                                           \
                                 "postgres"


# Для полной очистки от репликации на бывшем standby узле
#1) удаляем файл /data/standby.signal
#2) удаляем файл /data/conf.d/pgsqlks_sr.conf
#3) перезапускаем  СУБД


echo ""

exit;




