#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -id|--node_id)
        node_id="$2"
        ;;

      -t|--test)
        test="--dry-run"
        ;;

      -f|--force)
        force="--force"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -id | --node_id                       Идентификатор исключаемого standby узла
 -t  | --test                          Режим проверки возможности исключения
 -f  | --force                         Принудительное исключение, режим --force

"
exit 1;
fi;

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~  Исключение primary узла СУБД-КС @tag_ver@   "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""


# sudo
is_root=$EUID
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi


if [ -z  "${node_id}" ]; then
  echo -e "${eRR}Проверка входных параметров"
  echo -e "${emptE}Не задан параметр-идентификатор "-id" исключаемого primary узла."
  exit 1;
fi


# Константы каталогов pgsqlks
db_bin_path="@db_bin_path@"

# Запускаем разрегистрацию узла на мастере
bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr primary unregister -f /etc/repmgr/repmgr.conf --node-id=${node_id} ${test} ${force}" \
                                 "Исключение primary узла из состава репликации" \
                                 "top"                                           \
                                 "postgres"


echo ""

exit;




