#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -h|--host)
        db_host="$2"
        ;;

      -t|--test)
        test="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   --------------------------------------------------------
 -h | --host                           ip адрес текущего stanby узла, переключаемого в primary
 -t | --test                           Проверка возможности выполнения операции switchover

 Операцию ручного переключения \"failover\" необходимо строго выполнять на текущем хосте standby.

"
exit 1;
fi;

# Константы каталогов pgsqlks
db_bin_path="@db_bin_path@"
db_data_path="@db_data_path@"
db_kslib_path="@db_kslib_path@"


# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
emptE="           "


echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~    Переключение standby yзла в primary       "
echo "           ~            СУБД-КС @tag_ver@                 "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""


# sudo
is_root=$EUID
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  echo ""
  exit 1;
fi;

if [ -z "${db_host}" ]; then
  echo -e "${eRR}Проверка ip адреса standby узла."
  echo -e "${emptE}Для выполнения операции переключения необходимо указать ip адрес standby узла."
  echo -e "${emptE}Например: ./sr_switchover_standby.sh -h 192.168.1.2"
  echo ""
  exit 1;
fi;

# Тестирование
if ! [ -z "${test}" ]; then
  echo -e "${sOK}Запуск тестирования условий переключения."
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf standby switchover --siblings-follow --dry-run" \
                                   "Информация о результатах тестирования" \
                                   "top"                                   \
                                   "postgres"

  #if [ $? -eq 1 ]; then echo ""; exit 1; fi;
  echo -e "${sOK}Тестирование завершено."
  echo ""
  exit 1;
fi;


echo -e "${sOK}Запуск операции переключения."

# Если СУБД не запущена, то запускаем
if ! [ -f ${db_data_path}/data/postmaster.pid ]; then
  # Запускаем СУБД в работающем контейнере
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/pg_ctl start -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                   "Запуск СУБД-КС standby узла." \
                                   "top"                          \
                                   "postgres"

  if [ $? -eq 1 ]; then echo ""; exit 1; fi;

fi;

# Собственно переключение
bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf standby switchover --siblings-follow" \
                                 "Выполнение операции переключения СУБД" \
                                 "top"                                   \
                                 "postgres"

if [ $? -eq 1 ]; then echo ""; exit 1; fi;

# "Ручное" выполнение failover для переключения пуллеров
bash ${dks_bashfile_dir}/bash.sh "${db_kslib_path}/pg_promote ${db_host}"    \
                                 "Выполнение операции переключения пуллеров" \
                                 "top"                                       \
                                 "postgres"

if [ $? -eq 1 ]; then echo ""; exit 1; fi;


exit;

