#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -h|--pg_host)
        pg_host="$2"
        ;;

      -p|--pg_port)
        pg_port="$2"
        ;;

      -pwd|--pg_pwd)
        pg_pwd="$2"
        ;;

      -f|--force)
        force="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


# Работа с удаленными хостами
pg_db="repmgr"
pg_user="repmgr"


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры                   по умолчанию   описание
 ------------------------    ------------   ------------------------------------------------------
 -h   | --pg_host                           ip удаленного хоста c СУБД
 -p   | --pg_port            @db_port@           порт СУБД
 -pwd | --pg_pwd             1              пароль пользователя repmgr
 -f   | --force                             принудительная генерация файлов id_rsa
"
exit 1;
fi;

if [ -z "${pg_port}" ];   then pg_port="@db_port@"; fi;
if [ -z "${pg_pwd}" ];    then pg_pwd="1";     fi;


pg_db="repmgr"
pg_user="repmgr"
db_data_path="@db_data_path@"
container_ssh_port="2222"
dks_stdout="${dks_bashfile_dir}/dks.stdout"

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
wOK="[  \033[1;33mИнфо\033[0m  ] "
emptE="           "
emptEsh="###########"

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~  Формирование SSH файлов СУБД-КС @tag_ver@   "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""

function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}



# sudo
is_root=$EUID
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  echo ""
  exit 1;
fi;


if [ -z "${pg_host}" ]; then
  echo -e "${eRR}Проверка входных параметров."
  echo -e "${emptE}Не указан пареметр -h -> ip адрес удаленного хоста."
  echo ""
  exit 1;
fi;



# Если задана принудительная перегенерация или файла не существует, то запускаем генерацию ключа
if [[ ! -z "${force}" || ! -f "${db_data_path}/.ssh/id_rsa" ]]; then

  # создание каталога
  bash ${dks_bashfile_dir}/bash.sh "mkdir -p /home/postgres/.ssh"  \
                                   "Проверка и создание каталога /home/postgres/.ssh"   \
                                   "top"                                                \
                                   "postgres"

  #Удаление при принудительной перегенерации
  bash ${dks_bashfile_dir}/bash.sh "if [ -f \"/home/postgres/.ssh/id_rsa\" ]; then rm -f /home/postgres/.ssh/id_rsa; fi; " \
                                   "Проверка и удаление предыдущих файлов /home/postgres/.ssh/id_rsa*"                     \
                                   "top"                                                                                   \
                                   "postgres"

  # Генерация ключа
  bash ${dks_bashfile_dir}/bash.sh "ssh-keygen -t rsa -P \"\" -f /home/postgres/.ssh/id_rsa" \
                                   "Генерация\перегенерация ключа id_rsa"                        \
                                   "top"                                                         \
                                   "postgres"


  # Коррекция прав доступа
  bash ${dks_bashfile_dir}/bash.sh "chmod 600 /home/postgres/.ssh/id_rsa*"                     \
                                   "Коррекция прав доступа /home/postgres/.ssh/id_rsa* (600)"  \
                                   "top"



  # Копируем в каталог данных СУБД, чтоб достать с хоста
  bash ${dks_bashfile_dir}/bash.sh "cp -r /home/postgres/.ssh/. ${db_data_path}/.ssh" \
                                   "Копирование ключа id_rsa в ${db_data_path}/.ssh"  \
                                   "top"                                              \
                                   "postgres"


  # Открываем порт для ssh сервера в контейнере
  # Анализируем наличие FireWall и пытаемся добавить правило для открытия порта СУБД
  if hash firewall-cmd 2>/dev/null; then
    if systemctl -q is-active firewalld; then
      echo -e "${sOK}FireWall: Создание\проверка правила для разрешения соединений по порту ${container_ssh_port}."
      firewall-cmd --add-port=${container_ssh_port}/tcp  --permanent >/dev/null 2>${dks_stdout}
      fn_file_echo ${dks_stdout} ${emptEsh}
      firewall-cmd --reload >/dev/null 2>${dks_stdout}
      #показываем ошибки
      fn_file_echo ${dks_stdout} ${emptEsh}
      fn_file_clr ${dks_stdout}
    else
      echo -e "${wOK}Firewalld не запущен."
      echo -e "${emptE}Возможно после его запуска нужно будет создать правило для разрешения соединений по портy ${container_ssh_port}."
      echo -e "${emptE}firewall-cmd --add-port=${container_ssh_port}/tcp  --permanent"
      echo -e "${emptE}firewall-cmd --reload"
    fi;
  fi;
  if [ -f "${dks_stdout}" ]; then rm -f ${dks_stdout}; fi;
else

  echo -e "${sOK}Проверка наличия фалов ключей id_rsa."
  echo -e "${emptE}Файлы ключей уже существуют. См. каталог ${db_data_path}/.ssh."
  echo -e "${emptE}Генерация не требуется и будет пропущена."

fi;


# Создание на удаленном хосте /home/postgres/.ssh/authorized_keys
file_content=$(cat ${db_data_path}/.ssh/id_rsa.pub)

shell_cmd="echo \\\"${file_content}\\\" >> /home/postgres/.ssh/authorized_keys"
sql_cmd="select xp_bashshell('"${shell_cmd}"');"

bash ${dks_bashfile_dir}/psql.sh -h ${pg_host} -p ${pg_port} -d ${pg_db} -U ${pg_user} -pwd ${pg_pwd} -c "${sql_cmd}" \
                            -m "Запись данных в /home/postgres/.ssh/authorized_keys на удаленном хосте ${pg_host}"    \
                            -s "top"                                                                                  \
                            -k "-t"

shell_cmd="chmod 600 /home/postgres/.ssh/authorized_keys"
sql_cmd="select xp_bashshell('"${shell_cmd}"');"

bash ${dks_bashfile_dir}/psql.sh -h ${pg_host} -p ${pg_port} -d ${pg_db} -U ${pg_user} -pwd ${pg_pwd} -c "${sql_cmd}" \
                            -m "Коррекция прав доступа файла authorized_keys (600) на удаленном хосте ${pg_host}"     \
                            -s "top"                                                                                  \
                            -k "-t"


echo -e "${sOK}Примечание."
echo -e "${emptE}После окончания настроек ssh соединений на всех узлах, не забудьте перезагрузить кластер в целом."
echo -e "${emptE}Перезагрузку необходимо выполнить с хоста, на котором расположен primary узел c помощью команд:"
echo -e "${emptE}./sr_run_cluster.sh \"stop\" и ./sr_run_cluster.sh \"start\""

echo ""

exit;







