#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"


action=$1

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
emptE="           "


if [ -z "${action}" ]; then
  action="start"
fi;

echo ""

if [[ "${action}" != "start" && "${action}" != "stop" ]]; then
  echo -e "${eRR}Неверный параметр действия."
  echo -e "${emptE}Доcтупные значения параметра: start или stop."
  echo ""
  exit 1;
fi;

if [ "${action}" = "start" ]; then
  title_action="Запуск"
else
  title_action="Остановка"
fi;

# Константы-переменные
db_bin_path="@db_bin_path@"
db_data_path="@db_data_path@"
host_cmd="bash ${db_data_path}/sr_ctl/psr_repmgrd.sh ${action}"
host_cmd="'"${host_cmd}"'"

# получение данных участников репликации
sql_cmd="select conninfo from repmgr.nodes order by node_id"
file_result=${dks_bashfile_dir}/sql_stdout.tmp
node_list=${dks_bashfile_dir}/node_list.tmp

${dks_bashfile_dir}/psql.sh -d repmgr -U repmgr -c "${sql_cmd}" > ${file_result}

if ! [ -f ${file_result} ]; then
  echo -e "${eRR}Отсутствует информация об узлах."
  echo -e "${emptE}Запрос \"${sql_cmd}\" не вернул ни одной записи."
  echo ""
  exit 1;
fi;

# Вытаскиваем данные соединения
grep -F "host="  ${file_result} > ${node_list}

if ! [ -s ${node_list} ]; then
  echo -e "${eRR}Некорректная информация о параметрах соединения узлов."
  echo -e "${emptE}Отсутствуют записи вида: host=* port=* dbname=* user=*."
  echo ""
  exit 1;
fi;

while read LINE
do
   conn_str="$LINE";
   conn_str=$(echo  ${conn_str} | sed 's/host=/-h /g');
   conn_str=$(echo  ${conn_str} | sed 's/port=/-p /g');
   conn_str=$(echo  ${conn_str} | sed 's/dbname=/-d /g');
   conn_str=$(echo  ${conn_str} | sed 's/user=/-U /g');

   host_ip=$(echo $LINE | sed -r 's/port.+//');

   ${dks_bashfile_dir}/psql.sh ${conn_str} -c "select xp_bashshell(${host_cmd});" -m "${title_action} repmgrd ${host_ip}" -s "top" -k "-t";


done < ${node_list}

# Удаление временных файлов
rm -f ${node_list}
rm -f ${file_result}

exit;


