#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

type_node=$1   # тип узла
m_ip=$2        # ip primary
m_port=$3      # порт primary
ip=$4          # ip standby   не используется, зарезервировано 
port=$5        # порт standby не используется, зарезервировано
password=$6    # пароль пользователя репликации repmgr
force_reg=$7   # признак принудительного выполнения действия регистрации

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~      РЕГИСТРАЦИЯ ${type_node} узла           "
echo "           ~            СУБД-КС @tag_ver@                 "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""


# sudo
is_root=$EUID
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi

# Константы каталогов pgsqlks
db_bin_path="@db_bin_path@"
db_data_path="@db_data_path@"
host_kslib_path="@db_kslib_path@/@db_port@"

force_key_reg=""
if [ ${force_reg} = "1" ]; then force_key_reg="--force"; fi;



if [ "${type_node}" = "standby" ]; then

  # Запуск клонирования
  echo -e "${sOK}Запуск операции клонирования."
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -h ${m_ip} -p ${m_port} -U repmgr -d repmgr -f /etc/repmgr/repmgr.conf standby clone --force" \
                                   "Статус выполнения операции клонирования" \
                                   ""                                        \
                                   "postgres"

  if [ $? -eq 1 ]; then exit 1; fi;


  # Запускаем СУБД в работающем контейнере
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/pg_ctl start -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                   "Запуск СУБД-КС" \
                                   ""               \
                                   "postgres"
  if [ $? -eq 1 ]; then exit 1; fi;


  # Запускаем регистрацию узла на мастере
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -h ${m_ip} -p ${m_port} -U repmgr -d repmgr -f /etc/repmgr/repmgr.conf standby register ${force_key_reg}" \
                                   "Регистрация standby узла на мастере" \
                                   ""                                    \
                                   "postgres"
  if [ $? -eq 1 ]; then exit 1; fi;

else

  if [[ "${type_node}" = "primary" || "${type_node}" = "witness" ]]; then

    # Для регистрации primary или witness - запускаем СУБД
    if [ ! -f ${db_data_path}/data/postmaster.pid ]; then
      bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/pg_ctl start -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                       "Запуск СУБД-КС в контейнере" \
                                       ""                            \
                                       "postgres"

    fi;

    # Создаем БД и пользователя для репликации (предварительно экранируем символ " в пароле)
    password=$(echo  ${password} | sed 's/\"/\\"/g')
    bash ${dks_bashfile_dir}/psql.sh -c "create role repmgr superuser login password '${password}';" -m "Создание пользователя repmgr"  -s "noshow"
    bash ${dks_bashfile_dir}/psql.sh -c "alter role repmgr with password '${password}';"             -m "Коррекция пользователя repmgr" -s "noshow"
    bash ${dks_bashfile_dir}/psql.sh -c "create database repmgr owner repmgr;"                       -m "Создание БД repmgr"            -s "noshow"

    if [ "${type_node}" = "primary" ]; then

      # Запускаем регистрацию primary узла на мастере
      bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf master register ${force_key_reg}" \
                                       "Регистрация primary узла на мастере" \
                                       ""                                    \
                                       "postgres"


      if [ $? -eq 1 ]; then exit 1; fi;

    else

      # Запускаем регистрацию witness узла на мастере
      bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -h ${m_ip} -p ${m_port} -U repmgr -d repmgr -f /etc/repmgr/repmgr.conf witness register ${force_key_reg}" \
                                       "Регистрация witness узла на мастере" \
                                       ""                                    \
                                       "postgres"

      if [ $? -eq 1 ]; then exit 1; fi;

    fi;

    # Создаем функции
    bash ${dks_bashfile_dir}/psql.sh -f "${db_data_path}/sr_ctl/sql/dks_sr_funcs.sql" -d repmgr      -m "Создание функций и процедур"   -s "noshow"

  fi;
fi;


# Формирование файла ../kslib/pg_promote из шаблона pg_promote.t
if [[ "${type_node}" = "primary" || "${type_node}" = "standby" ]]; then

  cp ${dks_bashfile_dir}/pg_promote.t ${host_kslib_path}/pg_promote
  chown ks-postgres:ks-postgres ${host_kslib_path}/pg_promote
  chmod 777 ${host_kslib_path}/pg_promote

fi;


exit;




