#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

action=$1

if [ -z "${action}" ]; then
  action="start"
fi;

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
emptE="           "

echo ""

# sudo
is_root=$EUID
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  echo ""
  exit 1;
fi

if [[ "${action}" != "start" && "${action}" != "stop" ]]; then
  echo -e "${eRR}Неверный параметр действия."
  echo -e "${emptE}Доcтупные значения параметра: start или stop."
  echo ""
  exit 1;
fi;

# Константы каталогов pgsqlks
db_bin_path="@db_bin_path@"


# инфо
if [ "${action}" = "start" ]; then

  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf daemon start" \
                                   "Запуск агента repmgrd" \
                                   "top;no_error"          \
                                   "postgres"

  bash ${dks_bashfile_dir}/bash.sh "if [ -z \"\$(pidof /usr/sbin/sshd)\" ]; then /usr/sbin/sshd; fi;" \
                                   "Запуск SSH сервера" \
                                   "top;no_error"       \
                                   "postgres"

else

  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf daemon stop" \
                                   "Остановка агента repmgrd" \
                                   "top;no_error"             \
                                   "postgres"

  bash ${dks_bashfile_dir}/bash.sh "if ! [ -z \"\$(pidof /usr/sbin/sshd)\" ]; then kill -9 \$(pidof /usr/sbin/sshd); fi;" \
                                   "Остановка SSH сервера" \
                                   "top;no_error"          \
                                   "postgres"
fi;

echo ""

exit;

