#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -h|--pg_host)
        pg_host="$2"
        ;;

      -p|--pg_port)
        pg_port="$2"
        ;;

      -t|--test)
        test="--dry-run"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -h  | --pg_host                       ip primary узла СУБД
 -p  | --pg_port        @db_port@           порт СУБД primary узла
 -t  | --test                          режим тестирования возможности переподключения --dry-run

"
exit 1;
fi;

if [ -z "${pg_port}" ];      then pg_port="@db_port@";     fi;


# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~  АКТИВАЦИЯ неактивного узла в кластере как standby   "
echo "           ~                 СУБД-КС @tag_ver@                    "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""


# Константы каталогов pgsqlks
db_bin_path="@db_bin_path@"
db_data_path="@db_data_path@"
pg_db="repmgr"
pg_user="repmgr"
is_running="0"

# sudo
is_root=$EUID
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi;

# -h
if [ -z "${pg_host}" ]; then
  echo -e "${eRR}Проверка входных параметров."
  echo -e "${emptE}Не указан пареметр -h -> ip адрес удаленного хоста."
  echo ""
  exit 1;
fi;

if [ -z "${test}" ]; then
  echo -e "${sOK}Запуск операции переподключения."
else
  echo -e "${sOK}Запуск операции переподключения (ТЕСТИРОВАНИЕ)."
fi;

if [ -f ${db_data_path}/data/postmaster.pid ]; then
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/pg_ctl stop -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                   "Остановка СУБД-КС" \
                                   "top"               \
                                   "postgres"
  if [ $? -eq 1 ]; then exit 1; fi;
  is_running="1"
fi;

bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf node rejoin ${test} -d 'host=${pg_host} port=${pg_port} dbname=${pg_db} user=${pg_user}'" \
                                 "Выполнение операции переподключения (rejoin)" \
                                 "top"                                          \
                                 "postgres"
if [ $? -eq 1 ]; then exit 1; fi;

if [[ ! -z "${test}" && is_running="1" ]]; then
  # если было тестирование, то запускаем СУБД, если было запущено
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/pg_ctl start -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                   "Запуск СУБД-КС" \
                                   "top"            \
                                   "postgres"
  if [ $? -eq 1 ]; then exit 1; fi;
else
  # Запускаем repmgrd и ssh сервер
  bash ${dks_bashfile_dir}/sr_repmgrd.sh "start"
  if [ $? -eq 1 ]; then exit 1; fi;
fi;

exit;








