#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"


while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -tn|--type_node)
        type_node="$2"
        ;;
      -mi|--m_ip)
        m_ip="$2"
        ;;
      -mp|--m_port)
        m_port="$2"
        ;;

      -id|--id)
        id="$2"
        ;;
      -n|--name)
        name="$2"
        ;;
      -i|--ip)
        ip="$2"
        ;;

      -p|--port)
        port="$2"
        ;;
      -s|--slot)
        slot="$2"
        ;;
      -pwd|--password)
        password="$2"
        ;;

      -f|--force_register)
        force_reg="1"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done


if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -tn  | --type_node      standby        тип узла

 -mi  | --m_ip           0.0.0.0        ip primary узла
 -mp  | --m_port         @db_port@           порт primary узла

 -id  | --id             101            идентификатор узла в реестре репликации
 -n   | --name           Srv+id         наименование узла в реестре репликации

 -i   | --ip                            ip standby узла
 -p   | --port           @db_port@           порт standby узла
 -s   | --slot           1              слот репликации
 -pwd | --password       1              пароль пользователя СУБД repmgr

 -f   | --force_reg                     принудительная перезапись информации об узле,
                                        если он существует

"
exit 1;
fi;

if [ -z "${type_node}" ]; then
  type_node="standby"
else
  if [[ "${type_node}" != "primary" && "${type_node}" != "witness" ]]; then type_node="standby"; fi;
fi;

if [ -z "${m_ip}" ];      then m_ip="0.0.0.0";     fi;
if [ -z "${m_port}" ];    then m_port="@db_port@"; fi;
if [ -z "${id}" ];        then id="101";           fi;
if [ -z "${name}" ];      then name="Srv${id}";    fi;
if [ -z "${port}" ];      then port="@db_port@";   fi;
if [ -z "${slot}" ];      then slot="1";           fi;
if [ -z "${password}" ];  then password="1";       fi;
if [ -z "${force_reg}" ]; then force_reg="0";      fi;


# Подготовка к репликации
bash ${dks_bashfile_dir}/sr_prepare.sh "${type_node}" \
                                       "${m_ip}"      \
                                       "${m_port}"    \
                                       "${id}"        \
                                       "${name}"      \
                                       "${ip}"        \
                                       "${port}"      \
                                       "${slot}"      \
                                       "${password}"

if [ $? -eq 1 ]; then echo ""; exit 1; fi;


# Инициализация
bash ${dks_bashfile_dir}/sr_run.sh     "${type_node}" \
                                       "${m_ip}"      \
                                       "${m_port}"    \
                                       "${ip}"        \
                                       "${port}"      \
                                       "${password}"  \
                                       "${force_reg}"
if [ $? -eq 1 ]; then echo ""; exit 1; fi;

# Получение информации
bash ${dks_bashfile_dir}/sr_info.sh
if [ $? -eq 1 ]; then echo ""; exit 1; fi;

exit;





