#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

type_node="standby"
while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -mi|--m_ip)
        m_ip="$2"
        ;;
      -mp|--m_port)
        m_port="$2"
        ;;

      -id|--id)
        id="$2"
        ;;
      -n|--name)
        name="$2"
        ;;
      -i|--ip)
        ip="$2"
        ;;
      -p|--port)
        port="$2"
        ;;
      -pwd|--password)
        password="$2"
        ;;

      --help)
        show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${show_help}" ]; then

echo -e "
 параметры              по умолчанию   описание
 -------------------    ------------   ------------------------------------------------------
 -mi  | --m_ip           0.0.0.0        ip primary узла
 -mp  | --m_port         @db_port@           порт primary узла

 -id  | --id             101            идентификатор узла в реестре репликации
 -n   | --name           "Srv"+id       наименование узла в реестре репликации

 -i   | --ip                            ip standby узла
 -p   | --port           @db_port@           порт standby узла
 -pwd | --password       1              пароль пользователя СУБД repmgr

"
exit 1;
fi;

type_node="standby"

if [ -z "${m_ip}" ];     then m_ip="0.0.0.0";     fi;
if [ -z "${m_port}" ];   then m_port="@db_port@";      fi;
if [ -z "${id}" ];       then id="101";           fi;
if [ -z "${name}" ];     then name="Srv${id}";    fi;
if [ -z "${port}" ];     then port="@db_port@";        fi;
if [ -z "${password}" ]; then password="1";       fi;




# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
emptE="           "

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~  Восстановление сбойного узла как standby    "
echo "           ~              СУБД-КС @tag_ver@               "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""


# sudo
is_root=$EUID
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi

# Константы каталогов pgsqlks
db_bin_path="@db_bin_path@"
db_data_path="@db_data_path@"

# архивируем каталог с данными -- PGDATA
#cp -r ${db_data_path}/data ${db_data_path}/data_$(date +"%Y%m%d_%H%M%S")_archive


# Если запущен repmgrd, то останавливаем
if [ -f "${db_data_path}/data/repmgrd.pid" ]; then ${dks_bashfile_dir}/sr_repmgrd.sh "stop"; fi;

# Убираем признак, что база read_only (перезапустить СУБД чтобы применилось)
if [ -f "${db_data_path}/data/standby.signal" ]; then  rm -f ${db_data_path}/data/standby.signal; fi;


# Перезапускаем, если запущен или просто запускаем если нет
if [ -f ${db_data_path}/data/postmaster.pid ]; then
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/pg_ctl stop -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                   "Остановка СУБД-КС" \
                                   ""                  \
                                   "postgres"
  if [ $? -eq 1 ]; then exit 1; fi;
fi;

bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/pg_ctl start -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                   "Запуск СУБД-КС" \
                                   ""               \
                                   "postgres"

if [ $? -eq 1 ]; then exit 1; fi;


# удаляем базу repmgr, т.к. она содержит неверные данные
${dks_bashfile_dir}/psql.sh -c "drop database repmgr with ( force );" -m "Удаление информации о репликации" -s "top;no_error"

# Запускаем стандартную установку standby узла
${dks_bashfile_dir}/sr_register.sh -mi "${m_ip}"      \
                                   -mp "${m_port}"    \
                                   -id "${id}"        \
                                   -n "${name}"       \
                                   -i "${ip}"         \
                                   -p "${port}"       \
                                   -pwd "${password}" \
                                   -f
if [ $? -eq 1 ]; then exit 1; fi;

if [ ! -f ${db_data_path}/data/postmaster.pid ]; then
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/pg_ctl start -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                   "Запуск СУБД-КС" \
                                   ""               \
                                   "postgres"

  if [ $? -eq 1 ]; then exit 1; fi;
fi;


# Запускаем агента repmgrd и ssh
bash ${dks_bashfile_dir}/bash.sh "${db_data_path}/sr_ctl/psr_repmgrd.sh start" \
                                 "Запуск демона repmgrd" \
                                 "top"                   \
                                 "postgres"

if [ $? -eq 1 ]; then exit 1; fi;

echo ""

exit;








