#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Переданные параметры

type_node=$1  # тип узла (может быть только 3 типа)
m_ip=$2       # ip мастер
m_port=$3     # port мастер

id=$4         # id узла
name=$5       # нименование узла в реестре мастера

ip=$6         # ip standby узла"
port=$7       # порт standby узла
slot=$8       # слот репликации
password=$9   # пароль пользователя СУБД repmgr


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

echo ""
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo "           ~        Подготовка узла к регистрации         "
echo "           ~           СУБД-КС @tag_ver@                  "
echo "           ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
echo ""

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
emptE="           "


# Константы каталогов pgsqlks
dks_serv_name="@dks_serv_name@"
db_bin_path="@db_bin_path@"
db_data_path="@db_data_path@"
db_kslib_path="@db_kslib_path@"

# sudo
is_root=$EUID
if [ "$is_root" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  echo -e "${emptE}Операция подготовки прервана."
  echo ""
  exit 1;
fi

if systemctl -q is-active ${dks_serv_name}; then
  echo -e "${sOK}Проверка запуска сервиса ${dks_serv_name}."
else
  systemctl start  ${dks_serv_name}
  if systemctl -q is-active ${dks_serv_name}; then
    echo -e "${sOK}Запуск сервиса ${dks_serv_name}."
  else
    echo -e "${eRR}Запуск сервиса ${dks_serv_name}."
    echo -e "${emptE}Была предпринята неудачная попытка запуска сервиса ${dks_serv_name}."
    echo -e "${emptE}Обязательно свяжитесь со свои системным администратором."
    echo -e "${emptE}Операция подготовки прервана."
    exit;
  fi;
fi;


echo -e "${sOK}Конфигурирование repmgr -> repmgr.conf"
# Файл конфига repmgr (смонтирован на хост)
cat > /opt/@tag_name@/repmgr/@db_port@/repmgr.conf << EOF
node_id=${id}
node_name=${name}
conninfo='host=${ip} port=@db_port@ dbname=repmgr user=repmgr'
data_directory='${db_data_path}/data/'
use_replication_slots=true
pg_bindir='${db_bin_path}/'
log_file='/etc/repmgr/repmgr.log'


failover='automatic'
promote_command='${db_kslib_path}/pg_promote ${ip}'
follow_command='${db_bin_path}/repmgr standby follow -f /etc/repmgr/repmgr.conf --log-to-file --upstream-node-id=%n'

primary_visibility_consensus=true
standby_disconnect_on_failover=true

repmgrd_service_start_command='${db_bin_path}/repmgrd -f /etc/repmgr/repmgr.conf --pid-file ${db_data_path}/data/repmgrd.pid'
repmgrd_service_stop_command='kill \`cat ${db_data_path}/data/repmgrd.pid\`'

service_start_command='${db_bin_path}/pg_ctl  start   -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log'
service_stop_command='${db_bin_path}/pg_ctl  stop    -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log'
service_restart_command='${db_bin_path}/pg_ctl  restart -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log'
service_reload_command='${db_bin_path}/pg_ctl  reload  -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log'

monitoring_history=yes
monitor_interval_secs=2
connection_check_type='ping'
reconnect_attempts=4
reconnect_interval=8

log_status_interval=60

ssh_options='-q -p 2222 -o StrictHostKeyChecking=no -o ConnectTimeout=10'

EOF

# Файл логов запуска repmgr
cat > /opt/@tag_name@/repmgr/@db_port@/repmgr.log << EOF
EOF

chown ks-postgres:ks-postgres /opt/@tag_name@/repmgr/@db_port@/repmgr.*
chmod 644 /opt/@tag_name@/repmgr/@db_port@/repmgr.*


# Наличие модуля logrotate
if ! [ -f "/etc/cron.daily/logrotate" ] && ! [ -f "/etc/rwtab.d/logrotate" ]; then
  echo -e "${wOK}Настройка ротации логов repmgr."
  echo -e "${emptE}Отсутствует утилита logrotate."
  echo -e "${emptE}Операция настройки ротации логов будет пропущена."
else

  logrotateconf="/etc/logrotate.d/repmgr_@db_port@.conf"

  cat > ${logrotateconf} << EOF
    /opt/@tag_name@/repmgr/@db_port@/repmgr.log {
     missingok
     daily
     copytruncate
     rotate 7
     size 100M
     compress
     delaycompress
     create 0644 ks-postgres ks-postgres
    }

  #    missingok         - Не выдавать ошибки, если лог файла не существует
  #    daily             - Производить ротацию раз в день
  #    copytruncate      - Создать копию оригинального log-файла, а потом его 'обнулить',
  #                        таким образом сам файл не удаляется и не меняется его дескриптор
  #    rotate 3          - Количество хранимых файлов
  #    size 10K          - Производить ротацию, если log-файл превысил указанный размер
  #                        указывается в байтах, килобайтах (k), мегабайтах (M)
  #    compress          - Архивировать файлы (по умолчанию gzip)
  #    delaycompress     - Не сжимать 'свеже' созданный архив
  #

EOF
  echo -e "${sOK}Настройка ротации логов repmgr."
fi;



# Файл пароля для psql в контейнере
# ./pgpass
# hostname:port:database:username:password

bash ${dks_bashfile_dir}/bash.sh "cat > /home/postgres/.pgpass <<EOF
*:*:*:repmgr:${password}
EOF
" "Создание файла /home/postgres/.pgpass"
bash ${dks_bashfile_dir}/bash.sh "chown postgres:postgres /home/postgres/.pgpass" "Установка owner на /home/postgres/.pgpass"
bash ${dks_bashfile_dir}/bash.sh "chmod 600 /home/postgres/.pgpass" "Установка маски доступа на /home/postgres/.pgpass"

# Останавливаем если запущен
if [ -f ${db_data_path}/data/postmaster.pid ]; then
  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/pg_ctl stop -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                   "Остановка СУБД-КС в контейнере" \
                                   ""                               \
                                   "postgres"
fi;

if [ ! -f ${db_data_path}/data/pg_hba.conf ]; then
  echo -e "${eRR}Отсутствует файл ${db_data_path}/data/pg_hba.conf."
  echo -e "${emptE}Возможно СУБД-КС была установлена некорректно."
  echo -e "${emptE}Операция подготовки прервана."
  exit 1;
fi;


echo -e "${sOK}Конфигурирование СУБД-КС -> pg_hba.conf"

if [ "$type_node" = "primary" ]; then
  ip_replication="0.0.0.0"
else
  ip_replication=${m_ip}
fi;

# Прописываем доступ с primary сервера в pg_hba.conf (добавляем в конец файла)
# Удаляем строку, содержащую
sed -i "/host replication repmgr/ d"  ${db_data_path}/data/pg_hba.conf
# Пишем новую
cat << EOF >> ${db_data_path}/data/pg_hba.conf
host replication repmgr ${ip_replication}/0 md5
EOF


if [ "$type_node" = "primary" ]; then
  # создаем свой файл конфига для репликации в каталог conf.d
  cat > ${db_data_path}/data/conf.d/pgsqlks_sr.conf << EOF
# Репликация
max_wal_senders = 10
max_replication_slots = 10
wal_level = 'replica'
hot_standby = on
archive_mode = on
archive_command = '/bin/true'
wal_log_hints = on
EOF

  chown ks-postgres:ks-postgres ${db_data_path}/data/conf.d/pgsqlks_sr.conf
  chmod 644 ${db_data_path}/data/conf.d/pgsqlks_sr.conf
fi;

exit;