#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

type=$1
filt=$2 #--event=repmgrd_start

# Цвета
sOK="[   \033[0;32mOK\033[0m   ] "
eRR="[ \033[1;31mОшибка\033[0m ] "
WarnColor='\033[0;33m'
NoColor='\033[0m'
emptE="           "

if [ -z ${type} ]; then
  type="show";
fi;
if [ ! -z "${filt}" ]; then
  filt="--event=${filt}";
fi;

echo ""

# sudo
is_root=$EUID
if [ "${is_root}" -ne 0 ]; then
  echo -e "${eRR}Проверка прав суперпользователя."
  echo -e "${emptE}Для выполнения текущей операции необходимы права суперпользователя."
  exit 1;
fi

# Константы каталогов pgsqlks
db_bin_path="@db_bin_path@"
dks_path="/opt/dks-pgsqlks-@tag_ver@"

if [[ -f "${dks_path}/info.sh"  &&  "${type}" = "full_show" ]]; then
  bash ${dks_path}/info.sh -p "@db_port@";
fi;


# инфо
if [[ "${type}" = "show" || "${type}" = "full_show" ]]; then

  echo ""
  echo -e "${WarnColor}Запрос информации о состоянии репликации:${NoColor}"
  echo -e "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf cluster show" \
                                   "NoMsg"              \
                                   "notshow;notshift"   \
                                   "postgres"
  echo ""
  exit;
fi;

if [ "${type}" = "event" ]; then

  echo ""
  echo -e "${WarnColor}Запрос информации о событиях режимов репликации:${NoColor}"
  echo -e "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"

  bash ${dks_bashfile_dir}/bash.sh "${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf cluster event ${filt}" \
                                   "NoMsg"             \
                                   "notshow;notshift"  \
                                   "postgres"
  echo ""
  exit;
fi;


echo -e "${eRR}Некорректные параметры."
echo -e "${emptE}Допустимые параметры: show и event."
echo ""

exit 1;




