#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

action=$1

if [ -z "${action}" ]; then
  action="start"
fi;

emptE="           "

echo ""

if [[ "${action}" != "start" && "${action}" != "stop" ]]; then
  echo "${emptE}Неверный параметр действия."
  echo "${emptE}Доcтупные значения параметра: start или stop."
  echo ""
  exit 1;
fi;

# Константы каталогов pgsqlks
db_bin_path="@db_bin_path@"

# инфо
if [ "${action}" = "start" ]; then
  ${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf daemon start

  # Запуск ssh сервера
  sshd_pid=$(pidof /usr/sbin/sshd)
  if [ -z "${sshd_pid}" ]; then
    /usr/sbin/sshd
    echo "Запуск сервера sshd"
  else
    echo "Сервер sshd уже запущен pid=${sshd_pid}"
  fi;

else
  ${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf daemon stop

  # Остановка ssh сервера
  sshd_pid=$(pidof /usr/sbin/sshd)
  if ! [ -z "${sshd_pid}" ]; then
    kill -9 ${sshd_pid}
    echo "Остановка сервера sshd pid=${sshd_pid}"
  fi;

fi;

echo ""

exit;

