#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

db_host="$1"
switch_mode="$2"

if [ -z "${db_host}" ]; then
  echo "Не указан ip адрес сервера СУБД для продвижения."
  echo "Укажите ip адрес первым параметром при вызове ../kslib/pg_promote."
  echo ""
  exit 1;
fi;


db_bin_path="@db_bin_path@"
db_kslib_path="@db_kslib_path@"

db_port="@db_port@"
ssh_port="2222"

file_result="${db_kslib_path}/psql_exec.tmp"
pgb_list="${db_kslib_path}/pgb_list.tmp"
rm -f ${file_result}
rm -f ${pgb_list}


# 1. Автоматическое продвижение текущего узла от standby до primary, если передан пустой параметр {switch_mode}.
#    При ручном переключении rjvfyle - ../repmgr standby promote выполнять не нужно, 
#    поэтому в параметр {switch_mode} для ручного переключения передается значение 'switch'
if [ -z "${switch_mode}" ]; then
  ${db_bin_path}/repmgr standby promote -f /etc/repmgr/repmgr.conf --log-to-file
fi;


# 2. Переконфигурирование и перегрузка зарегистрированных пуллеров
sql_cmd="select 'host=postgres@'||trim(pgb_ip)||' -p "${ssh_port}" -o StrictHostKeyChecking=no /opt/'||trim(pgb_app)||'/ctl/pgb_promote.sh' as cmd_detail from repmgr.pgb_nodes;"
${db_bin_path}/psql -h 127.0.0.1  \
                    -p ${db_port} \
                    -U postgres   \
                    -d repmgr -t  \
                    -c "${sql_cmd}" >> ${file_result}


# Вытаскиваем данные соединения
grep -F "host=" ${file_result} > ${pgb_list}

if ! [ -s ${pgb_list} ]; then
  echo "Не удалось определить список зарегистрированных пуллеров."
  echo "Отсутствуют данные или ошибка их получения в таблице repmgr.pgb_nodes."
  echo ""
  exit 1;
fi;

# Были какие-то непонятные баги с использованием конструкции
# while read LINE - запуск ssh выполнялся только для первой команды из {pgb_list}
# поэтому, сделано через массив {Arr} и дальнейший его перебор c выбором
# элементов по индексу

n=0
while read LINE
do
   fencing_cmd="$LINE";
   fencing_cmd=$(echo  ${fencing_cmd} | sed 's/host=/ssh /g');
   fencing_cmd="${fencing_cmd} \"${db_host}\"";
   Arr[${n}]=${fencing_cmd}
   n=$(($n+1))
done < ${pgb_list}

for ((i=0;i<${n};i++))
do
  ${Arr[i]}
done

rm -f ${file_result}
rm -f ${pgb_list}

exit;





