#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) @tag_year@, ООО Кейсистемс
###
### Версия @tag_ver@

param_in=$1

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

#========== Переменные костанты =========================
tag_name=$($dks_bashfile_dir/dks_const_var.sh tag_name)
dks_inst_name=$($dks_bashfile_dir/dks_const_var.sh dks_inst_name)
db_inst_name=$($dks_bashfile_dir/dks_const_var.sh db_inst_name)
db_kslib_path=$($dks_bashfile_dir/dks_const_var.sh db_kslib_path)
util_path=$($dks_bashfile_dir/dks_const_var.sh util_path)
repmgr_path=$($dks_bashfile_dir/dks_const_var.sh repmgr_path)
#========================================================

# Порт-идентификатор
# Чтобы различить разные инстансы, каталоги, службы и контейнеры
db_port="@db_port@"

# Таймаут завершения работы сервера СУБД
shutdown_wait=600


# Контейнер
dks_cont_name="${tag_name}_${db_port}"
dks_serv_name="${tag_name}_${db_port}.service"
dks_image_tar_file="@typeOS@_${tag_name}_image.tar"
dks_image_code="@typeOS@"
contsoft="@contsoft@"

# СУБД
db_data_path="/var/lib/${db_inst_name}_${db_port}"
db_pwd="@db_pwd@"

# Пути psql.sh
util_path="${util_path}/${db_port}"

# Файл обмена
# Создаем Файл обмена, пути с хоста через дополнительный каталог
# с номером порта ...lib/kslib/<порт>, пути внутри контейнера как обычно ...lib/kslib
dks_stdout="${db_kslib_path}/${db_port}/dks.stdout"
dks_stdout_cont="${db_kslib_path}/dks.stdout"
#==========================================================

case ${param_in} in
      tag_name)
          param_out=${tag_name}
          ;;

      contsoft)
          param_out=${contsoft}
          ;;
      dks_cont_name)
          param_out=${dks_cont_name}
          ;;
      dks_serv_name)
          param_out=${dks_serv_name}
          ;;
      dks_image_tar_file)
          param_out=${dks_image_tar_file}
          ;;
      dks_image_code)
          param_out=${dks_image_code}
          ;;
      dks_stdout)
          param_out=${dks_stdout}
          ;;
      dks_stdout_cont)
          param_out=${dks_stdout_cont}
          ;;

      repmgr_path)
          param_out=${repmgr_path}
          ;;
      util_path)
          param_out=${util_path}
          ;;


      db_data_path)
          param_out=${db_data_path}
          ;;
      db_port)
          param_out=${db_port}
          ;;
      db_pwd)
          param_out=${db_pwd}
          ;;

      shutdown_wait)
          param_out=${shutdown_wait}
          ;;


     *)
          param_out="Неизвестный параметр ${param_in}."
          ;;
esac

echo ${param_out}

exit;
