-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getversion
-----------------------------------------------------------------------------------------------------------
--  
-- select dbo.xp_getversion();
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_getversion()
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_getversion'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getbuildnumber01
-----------------------------------------------------------------------------------------------------------
--  
-- select dbo.xp_getbuildnumber01();
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_getbuildnumber01()
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_getbuildnumber01'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getvernumber
-----------------------------------------------------------------------------------------------------------
--  
-- select dbo.xp_getvernumber();
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_getvernumber()
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_getvernumber'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_checkdigt01
-----------------------------------------------------------------------------------------------------------
--  
/*insert into dbo.SYS_SIGN (rid,link,siglink,signature,text)
select 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11'::uuid,-1,-1,'MIIFZwYJKoZIhvcNAQcCoIIFWDCCBVQCAQExDDAKBgYqhQMCAgkFADALBgkqhkiG9w0BBwGgggP3
MIID8zCCA6CgAwIBAgIKEm5EVwAAAADZ9DAKBgYqhQMCAgMFADCBxDEjMCEGCSqGSIb3DQEJARYU
cm9vdEBuYWxvZy50ZW5zb3IucnUxCzAJBgNVBAYTAlJVMRswGQYDVQQHDBLQr9GA0L7RgdC70LDQ
stC70YwxLTArBgNVBAoMJNCe0J7QniDQmtC+0LzQv9Cw0L3QuNGPINCi0LXQvdC30L7RgDEwMC4G
A1UECwwn0KPQtNC+0YHRgtC+0LLQtdGA0Y/RjtGJ0LjQuSDRhtC10L3RgtGAMRIwEAYDVQQDEwlU
RU5TT1JDQTEwHhcNMDgxMjAzMDExNjAwWhcNMDkxMjAzMDEyNTAwWjCCAQgxJjAkBgkqhkiG9w0B
CQEWFzI4MDExMjc5MDFAZW8udGVuc29yLnJ1MQswCQYDVQQGEwJSVTEhMB8GA1UEBwwY0JHQu9Cw
0LPQvtCy0LXRidC10L3RgdC6MXMwcQYDVQQKDGrQnNCjICfQptC10L3RgtGA0LDQu9C40LfQvtCy
0LDQvdC90LDRjyDQsdGD0YXQs9Cw0LvRgtC10YDQuNGPINGD0YfRgNC10LbQtNC10L3QuNC5INC+
0LHRgNCw0LfQvtCy0LDQvdC40Y8nMTkwNwYDVQQDDDDQlNC40LzQuNGC0YDRjtC6INCd0LDRgtCw
0LvRjNGPINCY0LLQsNC90L7QstC90LAwYzAcBgYqhQMCAhMwEgYHKoUDAgIkAAYHKoUDAgIeAQND
AARAhAW9O0hVveWbzVoNtX60o/eFUAZPpUUxkJHCUxhuxqoUF/vm8EBFyvJkAGTlFOk2aApCuiEe
sc2LLz1B7Fao+aOCAScwggEjMA4GA1UdDwEB/wQEAwIE8DAmBgNVHSUEHzAdBggrBgEFBQcDBAYH
KoUDAgIiBgYIKwYBBQUHAwIwHQYDVR0OBBYEFF6FaSTbviR/05fKk6CEKBvOq9tlMB8GA1UdIwQY
MBaAFLpz2TJbyW5S8lPVOcwYy9YenWGQMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly90YXgyLnRl
bnNvci5ydS9SQS9DRFAvYmE3M2Q5MzI1YmM5NmU1MmYyNTNkNTM5Y2MxOGNiZDYxZTlkNjE5MC5j
cmwwTQYIKwYBBQUHAQEEQTA/MD0GCCsGAQUFBzAChjFodHRwOi8vdGF4Mi50ZW5zb3IucnUvUkEv
Y2VydGVucm9sbC9URU5TT1JDQTEuY3J0MAoGBiqFAwICAwUAA0EAaFFqyzzhDpyGkLCQ8uGKS0LB
C08ipj7A1trZEbAHIHhSUUEbkn9lk8xMa4Qow3WAHLy6xI6/O2Pvvm3EfdVGVDGCATcwggEzAgEB
MIHTMIHEMSMwIQYJKoZIhvcNAQkBFhRyb290QG5hbG9nLnRlbnNvci5ydTELMAkGA1UEBhMCUlUx
GzAZBgNVBAcMEtCv0YDQvtGB0LvQsNCy0LvRjDEtMCsGA1UECgwk0J7QntCeINCa0L7QvNC/0LDQ
vdC40Y8g0KLQtdC90LfQvtGAMTAwLgYDVQQLDCfQo9C00L7RgdGC0L7QstC10YDRj9GO0YnQuNC5
INGG0LXQvdGC0YAxEjAQBgNVBAMTCVRFTlNPUkNBMQIKEm5EVwAAAADZ9DAKBgYqhQMCAgkFADAK
BgYqhQMCAhMFAARAM/wKKl1E62EN6qiKTBqSAacoD4P3WdrZF/U8NXFSeHNJMmvRH/VG46VRBgCV
kRuTw0fYDqm/hxQ65VEb8dbu5Q==',
'41549|11.08.2009|1400.00|041012001|      . .||40204810000000000088|2801022842|280101001|    (  ,   67)|041012603|  N 8636 .|30101810200000000603|40702810903010100117|2801018878|280101001| "  "|(007-0701-4209900-001-340=1400.00/02233008620/03007017660)/  .179142 23.07.09  -  179142 23.07.09        - 127,27|||||||||6|41549|11.08.2009|03007017660|02233008620|2801031290||40702810903010100117|3|007|0701|4209900|001|340||||||1400.00|/  .179142 23.07.09  -  179142 23.07.09        - 127,27||'

do
$$
declare
v_RID uuid := 'a0eebc99-9c0b-4ef8-bb6d-6bb9bd380a11'::uuid;
v_certKeysServerAddr text := 'yura';
v_nastrRevList int;
v_nastrLocStorage int;
v_nastrChDi text;
v_nastr int;
v_result int;
begin
 --v_nastrRevList := 2-dbo.get_val_case('NASTR_EDS_CHK_REVOCATION_LIST', null, 0);
 v_nastrRevList := 2;
  --v_nastrLocStorage := 2-dbo.get_val_case('NASTR_EDS_CHECK_LOCAL_STORAGE', null, 0); 
 v_nastrLocStorage := 2;
  v_nastrChDi := dbo.get_val('NASTR_EDS_CHDI','CHAR_VALUE',0);
  v_nastr := ( ( (v_nastrRevList*2 | v_nastrLocStorage*4) | 16) | 16384);
  raise notice 'v_nastr = %', v_nastr;
  raise notice 'v_nastrChDi = %', v_nastrChDi;
v_result := dbo.xp_checkdigt01(v_rid, v_certKeysServerAddr, null, v_nastr, v_nastrChDi, null, null);
  raise notice 'v_result = %', v_result;
end;
$$

select * from dbo.sys_sign;
*/
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_checkdigt01
(v_rid uuid, v_server text, v_checktime text, v_options integer, v_addition text, v_debug integer, v_version text)
RETURNS integer AS
'$libdir/kslib/libxpks.so', 'xp_checkdigt01'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_checkdigt02
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_checkdigt02(v_rid uuid, v_server text, v_debug integer, v_dataType integer, v_timeout integer);
DROP FUNCTION IF EXISTS dbo.xp_checkdigt02(v_rid uuid, v_server text, v_debug integer, v_dataType integer, v_timeout integer, v_verifyHost integer);
DROP FUNCTION IF EXISTS dbo.xp_checkdigt02(v_rid uuid, v_server text, v_debug integer, v_dataType integer, v_timeout integer, v_verifyHost integer, v_checkRevoked integer);
DROP FUNCTION IF EXISTS dbo.xp_checkdigt02(v_rid uuid, v_server text, v_debug integer, v_dataType integer, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer);

CREATE OR REPLACE FUNCTION dbo.xp_checkdigt02
(v_rid uuid, v_server text, v_debug integer, v_dataType integer, v_timeout integer, v_verifyHost integer default null, v_checkRevoked integer default null, v_verifyPeer integer default null)
RETURNS integer AS
'$libdir/kslib/libxpks.so', 'xp_checkdigt02'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getnewhash
-----------------------------------------------------------------------------------------------------------
--  
-- select dbo.xp_getnewhash(null);
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_getnewhash(v_cparam text)
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_getnewhash'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_setnewkey
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_setnewkey
(v_cKey text)
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_setnewkey'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getlicenseinfo01
-----------------------------------------------------------------------------------------------------------
--  
/*create temp table getlicenseinfo
(
  last_update varchar(50),
  max_users int,
  max_date varchar(50),
  crc varchar(20),
  max_users_web int,
  max_date_web varchar(50),
  max_users_smart int,
  max_date_smart varchar(50),
  org_id int,
  param varchar(4000),
  client_id varchar(4000)
);

select dbo.xp_getlicenseinfo01(0, 'web');
select * from getlicenseinfo;
*/
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_getlicenseinfo01
(v_nWPID int, v_cConnector text)
RETURNS integer AS
'$libdir/kslib/libxpks.so', 'xp_getlicenseinfo01'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getlicenseinfo02
-----------------------------------------------------------------------------------------------------------
--  
/*create temp table getlicenseinfo
(
  last_update varchar(50),
  max_users int,
  max_date varchar(50),
  crc varchar(20),
  max_users_web int,
  max_date_web varchar(50),
  max_users_smart int,
  max_date_smart varchar(50),
  org_id int,
  param varchar(4000),
  client_id varchar(4000),
  pro int,
  remote int,
  web int
);

select dbo.xp_getlicenseinfo02(0, 'web');
select * from getlicenseinfo;
*/
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_getlicenseinfo02
(v_nWPID int, v_cConnector text)
RETURNS integer AS
'$libdir/kslib/libxpks.so', 'xp_getlicenseinfo02'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getupdatedate
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_getupdatedate
(v_cObjCode text)
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_getupdatedate'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getlicensetable
-----------------------------------------------------------------------------------------------------------
--  
/*
create temp table getlicensetable
(
  ID int,
  UPDDATE varchar(50),
  MAXDATE varchar(50),
  MAXDATEWEB varchar(50),
  MAXDATESMART varchar(50),
  MAXUSERS int,
  MAXUSERSWEB int,
  MAXUSERSSMART int,
  REMOTE int,
  PRO int,
  WEB int
);

insert into dbo.sys_link(RID, LINK, OBJECT) values('a0eebc99-9c0b-4ef8-bb6d-6b69bd380a11'::uuid, 0, null);

delete from getlicensetable;
select dbo.xp_getlicensetable('a0eebc99-9c0b-4ef8-bb6d-6b69bd380a11'::uuid, 'ID,UPDDATE,MAXDATE,MAXDATEWEB,MAXDATESMART,MAXUSERS,MAXUSERSWEB,MAXUSERSSMART,REMOTE,PRO,WEB');
select * from getlicensetable;

delete from dbo.sys_link where RID = 'a0eebc99-9c0b-4ef8-bb6d-6b69bd380a11'::uuid;
*/
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_getlicensetable(v_RID uuid, v_Fields in varchar)
RETURNS int AS
'$libdir/kslib/libxpks.so', 'xp_getlicensetable'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getlicenseparam
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_getlicenseparam(v_nWPID int, v_cConnector varchar, v_cParamName varchar)
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_getlicenseparam'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_checksubkey
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_checksubkey(v_cSign text, v_cDate text, v_cSubKey text, v_cFuncId text, v_iMode int);

CREATE OR REPLACE FUNCTION dbo.xp_checksubkey(v_cSign text, v_cDate text, v_cSubKey text, v_cFuncId text, v_iMode int)
RETURNS int AS
'$libdir/kslib/libxpks.so', 'xp_checksubkey'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- xp_logincomplex
-----------------------------------------------------------------------------------------------------------
--  
/*create temp table logincomplex
(
  ret_code int,
  id int,
  title varchar(4000),
  group_name varchar(4000),
  work_mask int,
  work_mask2 int,
  appname varchar(4000)
);

select xp_logincomplex01(v_cAppName := 'smart', v_nMode := 0);
select * from logincomplex;
*/
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_logincomplex
(v_cAppName text, v_nMode int)
RETURNS int AS
'$libdir/kslib/libxpks.so', 'xp_logincomplex'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_logindbconnect
-----------------------------------------------------------------------------------------------------------
drop FUNCTION IF EXISTS dbo.xp_logindbconnect (v_cclientid text, v_nexistsconnection integer, v_cappname text);
drop FUNCTION IF EXISTS dbo.xp_logindbconnect (v_cClientId text, v_nExistsConnection int, v_cAppName text, v_nComplexid int, v_cHostIP text);

CREATE OR REPLACE FUNCTION dbo.xp_logindbconnect
(v_cClientId text, v_nExistsConnection int, v_cAppName text, v_nComplexid int default 0, v_cHostIP text default null)
RETURNS int AS
'$libdir/kslib/libxpks.so', 'xp_logindbconnect'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_logindbdisconnect
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_logindbdisconnect()
RETURNS int AS
'$libdir/kslib/libxpks.so', 'xp_logindbdisconnect'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
--  dbo.xp_parse_inner
-----------------------------------------------------------------------------------------------------------
--  
-- delete from sys_regedbo.xp_result;
-- select dbo.xp_parse_inner('a0eebc99-9c0b-4ef8-bb6d-6b69bd380a11'::uuid, '12345a12341', 'kodbp');
-- select * from sys_regedbo.xp_result;
-----------------------------------------------------------------------------------------------------------
drop FUNCTION IF EXISTS dbo.xp_parse_inner (v_RID uuid, v_Links text, v_String text, v_Fields text, v_FieldsInto text);
drop FUNCTION IF EXISTS dbo.xp_parse_inner (v_RID uuid, v_Links text, v_String text, v_Fields text, v_FieldsInto text, v_nMode int);

create or replace function dbo.xp_parse_inner
(v_RID uuid, v_Links text, v_String text, v_Fields text, v_FieldsInto text, v_nMode int)
returns int as
'$libdir/kslib/libxpks.so', 'xp_parse_inner'
language c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_parse_tab_inner
-----------------------------------------------------------------------------------------------------------
--  
-- delete from sys_regexp;
-- insert into sys_regexp values ('a0eebc99-9c0b-43f8-bb6d-6bb9bd380a11'::uuid, 1, '12345a12341');
-- delete from sys_regedbo.xp_result;
-- select dbo.xp_parse_tab_inner('a0eebc99-9c0b-43f8-bb6d-6bb9bd380a11'::uuid);
-- select * from sys_regedbo.xp_result;
-----------------------------------------------------------------------------------------------------------
drop FUNCTION IF EXISTS dbo.xp_parse_tab_inner (v_RID uuid, v_Links text, v_Fields text, v_FieldsInto text);
drop FUNCTION IF EXISTS dbo.xp_parse_tab_inner (v_RID uuid, v_Links text, v_Fields text, v_FieldsInto text, v_String text, v_Regexp text, v_Receiver text);
drop FUNCTION IF EXISTS dbo.xp_parse_tab_inner (v_RID uuid, v_Links text, v_Fields text, v_FieldsInto text, v_String text, v_Regexp text, v_Receiver text, v_nMode int);

create or replace function dbo.xp_parse_tab_inner
(v_RID uuid, v_Links text, v_Fields text, v_FieldsInto text, v_String text, v_Regexp text, v_Receiver text, v_nMode int)
returns int as
'$libdir/kslib/libxpks.so', 'xp_parse_tab_inner'
language c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_iskeyavail
-----------------------------------------------------------------------------------------------------------
--   
/*
select dbo.xp_iskeyavail(0);
*/
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_iskeyavail
(v_nWPID int)
RETURNS int AS
'$libdir/kslib/libxpks.so', 'xp_iskeyavail'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_call_service
-----------------------------------------------------------------------------------------------------------
create or replace function dbo.xp_call_service
(v_BpmsServiceUrl text, v_BpmsDbServer text, v_BpmsDbName text, v_BpmsDbType text,
v_ApplicationServiceUrl text, v_DbServer text, v_DbName text, v_DbType text,
v_Timeout int, v_XmlData text, v_Async int, v_CertId text, v_Login text)
returns text as
'$libdir/kslib/libxpks.so', 'xp_call_service'
language c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_rms_sendmessage
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_rms_sendmessage(v_servAddress text, v_virtAddress text, v_msgLink int, v_timeout integer);
DROP FUNCTION IF EXISTS dbo.xp_rms_sendmessage(v_servAddress text, v_virtAddress text, v_msgLink int, v_timeout integer, v_verifyHost integer, v_checkRevoked integer);
DROP FUNCTION IF EXISTS dbo.xp_rms_sendmessage(v_servAddress text, v_virtAddress text, v_msgLink int, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer);

CREATE OR REPLACE FUNCTION dbo.xp_rms_sendmessage
(v_servAddress text, v_virtAddress text, v_msgLink int, v_timeout integer default 15, v_verifyHost integer default null, v_checkRevoked integer default null, v_verifyPeer integer default null)
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_rms_sendmessage'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_rms_getserviceinfo
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_rms_getserviceinfo(v_servAddress text, v_timeout integer);
DROP FUNCTION IF EXISTS dbo.xp_rms_getserviceinfo(v_servAddress text, v_timeout integer, v_verifyHost integer, v_checkRevoked integer);
DROP FUNCTION IF EXISTS dbo.xp_rms_getserviceinfo(v_servAddress text, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer);

CREATE OR REPLACE FUNCTION dbo.xp_rms_getserviceinfo
(v_servAddress text, v_timeout integer default 15, v_verifyHost integer default null, v_checkRevoked integer default null, v_verifyPeer integer default null)
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_rms_getserviceinfo'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_rms_getchannelinfo
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_rms_getchannelinfo(v_servAddress text, v_virtAddress text, v_timeout integer);
DROP FUNCTION IF EXISTS dbo.xp_rms_getchannelinfo(v_servAddress text, v_virtAddress text, v_timeout integer, v_verifyHost integer, v_checkRevoked integer);
DROP FUNCTION IF EXISTS dbo.xp_rms_getchannelinfo(v_servAddress text, v_virtAddress text, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer);

CREATE OR REPLACE FUNCTION dbo.xp_rms_getchannelinfo
(v_servAddress text, v_virtAddress text, v_timeout integer default 15, v_verifyHost integer default null, v_checkRevoked integer default null, v_verifyPeer integer default null)
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_rms_getchannelinfo'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_savesubkey
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_savesubkey(v_cSign text, v_cSubKey text, v_iMode int);

CREATE OR REPLACE FUNCTION dbo.xp_savesubkey(v_cSign text, v_cSubKey text, v_iMode int)
RETURNS int AS
'$libdir/kslib/libxpks.so', 'xp_savesubkey'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_checksinglecmd
-----------------------------------------------------------------------------------------------------------
--  
-- select dbo.xp_checksinglecmd('select 1;select 2')
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_checksinglecmd(v_context text)
RETURNS integer AS
'$libdir/kslib/libxpks.so', 'xp_checksinglecmd'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_parse
-- version=10
-----------------------------------------------------------------------------------------------------------
--  
-- delete from sys_regedbo.xp_result;
-- select dbo.xp_parse('a0eebc99-9c0b-4ef8-bb6d-6b69bd380a11'::uuid, '12345a12341', 'kodbp');
-- select * from sys_regedbo.xp_result;
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_parse(uuid, text, text, text, text);
DROP FUNCTION IF EXISTS dbo.xp_parse(uuid, text, text, text, text, int);

create or replace function dbo.xp_parse
(v_RID uuid, v_String text, v_Fields text = null, v_Links text = null, v_FieldsInto text = null, v_nMode int = null)
returns integer as
$$
declare
result int;
begin	
  select dbo.xp_parse_inner(v_RID, v_Links, v_String, v_Fields, v_FieldsInto, v_nMode) into result;
  return result;
end;
$$
language plpgsql security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_parse_tab
-- version=10
-----------------------------------------------------------------------------------------------------------
--  
-- delete from sys_regexp;
-- insert into sys_regexp values ('a0eebc99-9c0b-43f8-bb6d-6bb9bd380a11'::uuid, 1, '12345a12341');
-- delete from sys_regedbo.xp_result;
-- select dbo.xp_parse_tab('a0eebc99-9c0b-43f8-bb6d-6bb9bd380a11'::uuid);
-- select * from sys_regedbo.xp_result;
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_parse_tab(uuid, text, text, text);
DROP FUNCTION IF EXISTS dbo.xp_parse_tab(uuid, text, text, text, text, text, text);
DROP FUNCTION IF EXISTS dbo.xp_parse_tab(uuid, text, text, text, text, text, text, int);

create or replace function dbo.xp_parse_tab
(v_RID uuid, v_Fields text = null, v_Links text = null, v_FieldsInto text = null, v_String text = null, v_Regexp text = null, v_Receiver text = null, v_nMode int = null)
returns integer as
$$
declare
result int;
begin	
  select dbo.xp_parse_tab_inner(v_RID, v_Links, v_Fields, v_FieldsInto, v_String, v_Regexp, v_Receiver, v_nMode) into result;  
  return result;
end;
$$
language plpgsql security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_check
-- version=10
-----------------------------------------------------------------------------------------------------------
CREATE OR REPLACE FUNCTION dbo.xp_check(v_cObjCode varchar(30) = '', v_dtDate varchar(8) = '', v_cAppName varchar(128) = '')
RETURNS int AS
'$libdir/kslib/libxpks.so', 'xp_check'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getcertinfo
-- version=10
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_getcertinfo(v_rid uuid, v_server text, v_debug integer, v_timeout integer);
DROP FUNCTION IF EXISTS dbo.xp_getcertinfo(v_rid uuid, v_server text, v_debug integer, v_timeout integer, v_verifyHost integer, v_checkRevoked integer);
DROP FUNCTION IF EXISTS dbo.xp_getcertinfo(v_rid uuid, v_server text, v_debug integer, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer);

CREATE OR REPLACE FUNCTION dbo.xp_getcertinfo
(v_rid uuid, v_server text, v_debug integer default 0 , v_timeout integer default 15, v_verifyHost integer default null, v_checkRevoked integer default null, v_verifyPeer integer default null)
RETURNS integer AS
'$libdir/kslib/libxpks.so', 'xp_getcertinfo'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getfeaturelist
-- version=10
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_getfeaturelist(v_rid uuid, v_server text, v_timeout integer);
DROP FUNCTION IF EXISTS dbo.xp_getfeaturelist(v_rid uuid, v_server text, v_timeout integer, v_verifyHost integer, v_checkRevoked integer);
DROP FUNCTION IF EXISTS dbo.xp_getfeaturelist(v_rid uuid, v_server text, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer);

CREATE OR REPLACE FUNCTION dbo.xp_getfeaturelist
(v_rid uuid, v_server text, v_timeout integer default 15, v_verifyHost integer default null, v_checkRevoked integer default null, v_verifyPeer integer default null)
RETURNS integer AS
'$libdir/kslib/libxpks.so', 'xp_getfeaturelist'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_assemblesignature
-- version=10
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_assemblesignature(v_rid uuid, v_server text, v_timeout integer);
DROP FUNCTION IF EXISTS dbo.xp_assemblesignature(v_rid uuid, v_server text, v_timeout integer, v_verifyHost integer, v_checkRevoked integer);
DROP FUNCTION IF EXISTS dbo.xp_assemblesignature(v_rid uuid, v_server text, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer);

CREATE OR REPLACE FUNCTION dbo.xp_assemblesignature
(v_rid uuid, v_server text, v_timeout integer default 15, v_verifyHost integer default null, v_checkRevoked integer default null, v_verifyPeer integer default null)
RETURNS integer AS
'$libdir/kslib/libxpks.so', 'xp_assemblesignature'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_setconfparam
-- version=10
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_setconfparam(v_paramName text, v_paramValue text);

CREATE OR REPLACE FUNCTION dbo.xp_setconfparam
(v_paramName text, v_paramValue text)
RETURNS integer AS
'$libdir/kslib/libxpks.so', 'xp_setconfparam'
LANGUAGE c security definer;

-----------------------------------------------------------------------------------------------------------
-- dbo.xp_rms_getmessagecontent
-- version=10
-----------------------------------------------------------------------------------------------------------
DROP FUNCTION IF EXISTS dbo.xp_rms_getmessagecontent(v_servAddress text, v_virtAddress text, v_msgLink int, v_msgGuid text, v_direction text, v_contentLink int, v_contentName text, v_decode int, v_timeout integer, v_verifyHost integer, v_checkRevoked integer);
DROP FUNCTION IF EXISTS dbo.xp_rms_getmessagecontent(v_servAddress text, v_virtAddress text, v_msgLink int, v_msgGuid text, v_direction text, v_contentLink int, v_contentName text, v_decode int, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer);

DROP FUNCTION IF EXISTS dbo.xp_rms_getmsgcontent_inner(v_servAddress text, v_virtAddress text, v_msgLink int, v_msgGuid text, v_direction text, v_contentLink int, v_contentName text, v_decode int, v_timeout integer, v_verifyHost integer, v_checkRevoked integer);

DROP FUNCTION IF EXISTS dbo.xp_rms_getmsgcontent_inner(v_servAddress text, v_virtAddress text, v_msgLink int, v_msgGuid text, v_direction text, v_contentLink int, v_contentName text, v_decode int, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer);

CREATE OR REPLACE FUNCTION dbo.xp_rms_getmsgcontent_inner
(v_servAddress text, v_virtAddress text, v_msgLink int, v_msgGuid text, v_direction text, v_contentLink int, v_contentName text, v_decode int, v_timeout integer, v_verifyHost integer, v_checkRevoked integer, v_verifyPeer integer)
RETURNS text AS
'$libdir/kslib/libxpks.so', 'xp_rms_getmessagecontent'
LANGUAGE c security definer;

CREATE OR REPLACE FUNCTION dbo.xp_rms_getmessagecontent
(v_servAddress text, v_virtAddress text, v_msgLink int default NULL, v_msgGuid text default NULL, v_direction text default NULL, v_contentLink int default NULL, v_contentName text default NULL, v_decode int default NULL, v_timeout integer default 15, v_verifyHost integer default null, v_checkRevoked integer default null, v_verifyPeer integer default null)
RETURNS text AS $$
begin
	return dbo.xp_rms_getmsgcontent_inner(v_servAddress, v_virtAddress, v_msgLink, v_msgGuid, v_direction, v_contentLink, v_contentName, v_decode, v_timeout, v_verifyHost, v_checkRevoked, v_verifyPeer);
end
$$ LANGUAGE plpgsql security definer;


-----------------------------------------------------------------------------------------------------------
-- dbo.xp_getlicensekeys
--  
-- select dbo.xp_getlicensekeys();
--    ,  \n
-----------------------------------------------------------------------------------------------------------
do $$begin
if dbo.xp_getvernumber() > '200' or dbo.xp_getbuildnumber01() >= '174' then
	execute('CREATE OR REPLACE FUNCTION dbo.xp_getlicensekeys()
	RETURNS text AS
	''$libdir/kslib/libxpks.so'', ''xp_getlicensekeys''
	LANGUAGE c security definer;');
end if;
end$$;


-----------------------------------------------------------------------------------------------------------
-- dbo.xp_sklonstr
-----------------------------------------------------------------------------------------------------------
--  
-- select dbo.xp_sklonstr('', 2);
--     
-----------------------------------------------------------------------------------------------------------
do $$begin
if dbo.xp_getvernumber() > '200' or dbo.xp_getbuildnumber01() >= '178' then
	execute('CREATE OR REPLACE FUNCTION dbo.xp_sklonstr(v_cString text, v_nPadezh int)
	RETURNS text AS
	''$libdir/kslib/libxpks.so'', ''xp_sklonstr''
	LANGUAGE c security definer;');
end if;
end$$;


-----------------------------------------------------------------------------------------------------------
-- dbo.xp_sklonadd
-----------------------------------------------------------------------------------------------------------
--  
-- select dbo.xp_sklonadd('');
-----------------------------------------------------------------------------------------------------------
do $$begin
if dbo.xp_getvernumber() > '200' or dbo.xp_getbuildnumber01() >= '178' then
	execute('CREATE OR REPLACE FUNCTION dbo.xp_sklonadd(v_cString text)
	RETURNS int AS
	''$libdir/kslib/libxpks.so'', ''xp_sklonadd''
	LANGUAGE c security definer;');
end if;
end$$;