-- public.xp_bashshell         function
-- repmgr.pgb_nodes            table
-- repmgr.pgb_nodes_manage     function

do $$
declare
  v_sql text = '';
begin
  create extension if not exists plpython3u;

  drop function if exists public.xp_bashshell(text,text);
  v_sql = '
create or replace function public.xp_bashshell(cmd text, run_type text = ''sr'')
returns text
as $'||'$
	import subprocess

	rs = plpy.execute("select current_setting(''is_superuser'') as ret", 1)
	is_allow = rs[0]["ret"]
	if is_allow == ''off'':
		return ("Отсутствует доступ на выполнение данной операции.")

	if run_type == ''sr'':
		# full msg output, no parsed arguments, wait command
		process = subprocess.run(cmd, shell=True, check=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True, encoding=''utf-8'')
		if process.returncode == 0:
			return (process.stdout)
		else:
			return (process.stderr)

	else:
		# full msg output, parsed arguments, no wait command
		process = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True, encoding=''utf-8'')

		try:
			stdout, stderr = process.communicate()
		except process.SPIError:
			return (stderr)
		else:
			return (stdout)

$'||'$ language plpython3u security invoker;
';


  if coalesce(v_sql, '') <> '' then
    execute v_sql;
    alter function public.xp_bashshell(text,text) owner to postgres;
  end if;

  exception when others then
    raise info '%', 'Нет возможности создать объекты расширения plpython3u.';
end;
$$;


--select * from pg_class where relnamespace in (select oid from pg_namespace where nspname='repmgr') and relkind in ('r', 'v')
--select * from repmgr.events
--select * from repmgr.nodes
--select * from repmgr.show_nodes
--select * from repmgr.replication_status
--select count(*) from repmgr.monitoring_history limit 10

--select repmgr.pgb_nodes_manage('insert', '10.38.46.62', '6434', 'pgbouncer-1.15.0')
--select * from repmgr.pgb_nodes

do $$
begin
  if not exists(select * from pg_class where relname = 'pgb_nodes') then
    create table repmgr.pgb_nodes (pgb_ip text, pgb_port text, pgb_app text);
    alter table repmgr.pgb_nodes owner to repmgr;
  end if;
end;$$
;

drop function if exists repmgr.pgb_nodes_manage(text, text, text, text);

create function repmgr.pgb_nodes_manage (in v_mode text, in v_pgb_ip text, in v_pgb_port text = '6434', in v_pgb_app text = 'pgbouncer-1.15.0')
returns void
as $$
begin

  -- модификация возможна только активном на primary, т.к. на standby позволены только read-only транзакции
  if exists (select * from repmgr.nodes where conninfo like '%'||trim(host(inet_server_addr())::text)||'%' and type='standby')
             or
     exists (select * from repmgr.nodes where conninfo like '%'||trim(host(inet_server_addr())::text)||'%' and type='primary' and not active)
  then
    raise info '%', 'Хост не является активным primary узлом, режимы регистрации будут пропущены.';
    return;
  end if;

  if v_mode = 'delete' then
    if exists (select * from repmgr.pgb_nodes where pgb_ip = v_pgb_ip) then
      delete from repmgr.pgb_nodes where pgb_ip = v_pgb_ip;
    end if;
  else
    if exists (select * from repmgr.pgb_nodes where pgb_ip = v_pgb_ip) then
      update repmgr.pgb_nodes
        set  pgb_port = v_pgb_port
            ,pgb_app  = v_pgb_app
          where pgb_ip = v_pgb_ip;
    else
      insert into repmgr.pgb_nodes (pgb_ip, pgb_port, pgb_app)
      values(v_pgb_ip, v_pgb_port, v_pgb_app);
    end if;
  end if;

end;
$$ language plpgsql security definer;

alter function repmgr.pgb_nodes_manage (text, text, text, text) owner to repmgr;

