-- rev 1.61


do
$plperlu$
begin
  create extension if not exists plperlu schema pg_catalog;
  return;
  exception
    when sqlstate '42710' then
      drop language if exists plperlu;
      create extension if not exists plperlu schema pg_catalog;
    when others then
    raise info '%', 'Нет возможности создать расширени plperlu.';
  
end;
$plperlu$ language plpgsql;

do
$plpython3u$
begin
  create extension if not exists plpython3u schema pg_catalog;
  exception when others then
    raise info '%', 'Нет возможности создать расширени plpython3u.';
end;
$plpython3u$;

do
$dblink$
begin
  create extension if not exists dblink schema public;
  exception when others then
    raise info '%', 'Нет возможности создать расширени dblink.';
end;
$dblink$;

--xp_getlibdir.prc

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_getlibdir';
    head := '-- select * from xp_getlibdir()
-- удаляем старую версию функции только если изменится кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземпляра SetupSrv к серверу).
-- drop function if exists public.xp_getlibdir();

create or replace function public.xp_getlibdir()
returns table (ret integer, msg text)
as
$$
';
    body := '
declare 
  v_OS       text := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin32'' else ''linux'' end;
  v_libdir   text;
begin
  create temporary table tmp_xp_getlibdir (ret int, msg text) on commit drop;
  if current_setting(''is_superuser'') = ''off'' then
    insert into tmp_xp_getlibdir (ret, msg) values(-1, ''Выполнение доступно только пользователю - SUPERUSER.'');
  else
    
    begin
      v_libdir := current_setting(''ks.libdir'');
      insert into tmp_xp_getlibdir (ret, msg) values(0, v_libdir);
    exception when others then
      insert into tmp_xp_getlibdir (ret, msg) values(-1, ''Не установлен параметр конфигурации ks.bindir'');
    end;
  
  end if;
  return query(select t.ret, t.msg from tmp_xp_getlibdir t);
end;

';
    tail := '$$ language plpgsql security invoker;
alter function public.xp_getlibdir()  owner to postgres;

';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;

--xp_cmdshell.prc

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_cmdshell';
    head := '-- select xp_cmdshell(''pg_config --libdir'', 0);
-- select xp_cmdshell(''pg_config'', 0);
-- select xp_cmdshell(''pg_restore -d fns_1602_1220_razr45 -e -1 /u01/PostgreSQL/9.4/backups/fns_1602_1220_razr2222.bak'', 0)
-- select xp_cmdshell(''pg_restore1 -d fns_1602_1220_razr45 -e -1 /u01/PostgreSQL/9.4/backups/fns_1602_1220_razr2.bak'', 0)
/*
Минное поле с utf8 (неделя):
  При запуске в qx// (aka backticks) (вместо system в Денисовом варианте) команды с перенаправлением вывода в файл, в файл писалось в Latin-1.
  Причем такое поведение только при запуске джоба. При запуске из PgAdmin или редактора запросов Смарт выполняется нормально и пишется нормальная кириллица.
  Пишут, что для STDOUT, STDIN & STDERR работу с utf8 надо включать явно. Но ни один из этих вариантов не помог:
        use open qw/:std :utf8/;
        или
        binmode(STDOUT, ":utf8");          #treat as if it is UTF-8
        binmode(STDIN, ":encoding(utf8)"); #actually check if it is UTF-8
        
   Проверка Encode::is_utf8($cmd) всегда возвращала true что бы я с $cmd ни делал.
   
   "фыва".$cmd > log.txt выводил фыва в кириллице, а $cmd (где было echo "что-то на кириллице") уже превращался в байты Latin-1 (хотя, опять же, Encode::is_utf8 выдает true)
   
   Остается перед запуском декодировать $cmd..В этом случае при запуске из джоба все работает нормально, а то же самое из PgAdmin наоборот -портится.
   
   Вывод: пока не разобрался из-за чего такая разница при запуске из под джоба и из под обычной сессии, оставлю 2 функции xp_cmdshell и xp_cmdshell_1. В джобе использую xp_cmdshell.

   С xp_send_mail похоже тоже самое!
   
*/
-- удаляем старую версию функции только если изменится кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземпляра SetupSrv к серверу).
-- drop function if exists public.xp_cmdshell(text, integer);

create or replace function public.xp_cmdshell(
   v_cmd        text
  ,v_no_output  integer = 1
  ,v_Ret        out integer
  ,v_Msg        out text
)
as
$$
';
    body := '
declare 
  v_PerlExec text;
  v_OS        text := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin32'' else ''linux'' end;
begin

  if current_setting(''is_superuser'') = ''off'' then
    v_Ret  := -1;
    v_Msg  := ''Выполнение доступно только пользователю - SUPERUSER.'';
    raise ''%'', v_Msg; 
    return;
  end if;

  if coalesce(v_cmd, '''') = '''' then
    v_Ret  := -1;
    v_Msg  := ''Пустая команда для выполнения.'';
    raise ''%'', v_Msg; 
    return;
  end if;

  drop table if exists tmp_xp_cmdshell;
  create temporary table tmp_xp_cmdshell (ret int, msg text) on commit drop;

    v_PerlExec :=''
  do
  $perlexec$
    use strict;
    use utf8;
    use Encode;
    
    #квотим двойные кавычки, доллар и сам символ квотирования
    #backticks do not affect standard error, поэтому stderr надо направить в stdout (http://perldoc.perl.org/perlop.html#Quote-Like-Operators)
    my $cmd       = ''''''||replace(v_cmd,'''''''',''\'''''')||'' 2>&1'''';
    my $no_output = ''||v_no_output::text||'';
    
    #отличие xp_cmdshell от xp_cmdshell_1 в этой строке
    $cmd = decode("utf8", $cmd);
    
    my $cmdoutput = qx/$cmd/;
    my $result = $?;
    
    if ($no_output == 0) {          
        # trim 
        $cmdoutput =~ s/^\s+|\s+$//g;
        $cmdoutput = decode("'' || case when v_OS = ''linux'' then ''utf8'' else ''cp1251'' end ||''", $cmdoutput);
    }
    else {
       if($result == 0) {$cmdoutput = "Вывод данных отключен";}
       else {$cmdoutput = "Ошибка выполнения: $cmd";}
    }
    #задваиваем одинарные кавычки для sql
    $cmdoutput =~ s/''''/''''''''/g;
    
    my $Query = "insert into tmp_xp_cmdshell (ret, msg) values ($result, ''''".$cmdoutput."'''')";
    spi_exec_query($Query);

    $perlexec$ language plperlu'';

  execute v_PerlExec;

  --raise info ''%'', v_PerlExec;

  select ret, msg 
    into v_ret, v_msg
      from tmp_xp_cmdshell;

  raise notice ''% - % '', v_ret, v_msg;

end;
$$ language plpgsql security invoker
;
alter function public.xp_cmdshell(text, integer)  owner to postgres
;




drop function if exists public.xp_cmdshell_1(text, integer);

create or replace function public.xp_cmdshell_1(
   v_cmd        text
  ,v_no_output  integer = 1
  ,v_Ret        out integer
  ,v_Msg        out text
)
as
$$
declare 
  v_PerlExec text;
  v_OS        text := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin32'' else ''linux'' end;
begin

  if current_setting(''is_superuser'') = ''off'' then
    v_Ret  := -1;
    v_Msg  := ''Выполнение доступно только пользователю - SUPERUSER.'';
    raise ''%'', v_Msg; 
    return;
  end if;

  if coalesce(v_cmd, '''') = '''' then
    v_Ret  := -1;
    v_Msg  := ''Пустая команда для выполнения.'';
    raise ''%'', v_Msg; 
    return;
  end if;

  drop table if exists tmp_xp_cmdshell;
  create temporary table tmp_xp_cmdshell (ret int, msg text) on commit drop;

    v_PerlExec :=''
  do
  $perlexec$
    use strict;
    use utf8;
    use Encode;
    
    #квотим двойные кавычки, доллар и сам символ квотирования
    #backticks do not affect standard error, поэтому stderr надо направить в stdout (http://perldoc.perl.org/perlop.html#Quote-Like-Operators)
    my $cmd       = ''''''||replace(v_cmd,'''''''',''\'''''')||'' 2>&1'''';
    my $no_output = ''||v_no_output::text||'';
    
    
    my $cmdoutput = qx/$cmd/;
    my $result = $?;
    
    if ($no_output == 0) {          
        # trim 
        $cmdoutput =~ s/^\s+|\s+$//g;
        $cmdoutput = decode("'' || case when v_OS = ''linux'' then ''utf8'' else ''cp1251'' end ||''", $cmdoutput);
    }
    else {
       if($result == 0) {$cmdoutput = "Вывод данных отключен";}
       else {$cmdoutput = "Ошибка выполнения: $cmd";}
    }
    
    #задваиваем одинарные кавычки для sql
    $cmdoutput =~ s/''''/''''''''/g;
    
    my $Query = "insert into tmp_xp_cmdshell (ret, msg) values ($result, ''''".$cmdoutput."'''')";
    spi_exec_query($Query);

    $perlexec$ language plperlu'';

  execute v_PerlExec;

  --raise info ''%'', v_PerlExec;

  select ret, msg 
    into v_ret, v_msg
      from tmp_xp_cmdshell;

  raise notice ''% - % '', v_ret, v_msg;

end;

';
    tail := '$$ language plpgsql security invoker
;
alter function public.xp_cmdshell_1(text, integer)  owner to postgres
;


';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;

--xp_getdir.prc

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_getdir';
    head := '--  select * from public.xp_getdir(''/u01'', 3)

-- удалЯем старую версию функции только если изменитсЯ кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземплЯра SetupSrv к серверу).
-- drop function if exists public.xp_getdir(text, integer);

create or replace function public.xp_getdir(
   v_Dir        text = '''' 
  ,v_mask       integer = 1       -- 1- каталоги, 2 - файлы 3- и те и другие
)
returns table (subdirectory text, is_file integer)
as $$
';
    body := '
declare
  v_PerlExec text;
  v_OS       text := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin32'' else ''linux'' end;
begin

  v_mask := coalesce(nullif(coalesce(v_mask, 1), 0), 1);
  create temp table tmp_xp_getdir (id serial, pfolder text, subdirectory text, is_file integer) on commit drop;
  v_Dir := case when coalesce(v_Dir, '''') = '''' then ''/'' else v_Dir end;

  if v_OS = ''mswin32'' then
    v_Dir := replace(v_Dir, ''\'', ''\\'');
  else
    null;
  end if;


  -- каталоги
  if v_Mask & 1 > 0 then
    v_PerlExec :=''
    do
    $perlexec$
      
      my $dir = "''||v_Dir||''";
      opendir (DIR, $dir) or return;
      my @files = sort grep {!/^\.+$/ and (-d $dir."//$_")} readdir DIR;
      closedir DIR;
      foreach my $file (@files) { 
        $query  = "insert into tmp_xp_getdir (pfolder, subdirectory, is_file) values (''''$dir'''',''''$file'''', 0)";
        spi_exec_query($query);
      }
    $perlexec$ language plperlu'';
    execute v_PerlExec;
  end if;

  -- файлы
  if v_Mask & 2 > 0 then
    v_PerlExec :=''
    do
    $perlexec$
      my $dir = "''||v_Dir||''";
      opendir (DIR, $dir) or return;
      my @files = sort grep {!/^\.+$/ and !(-d $dir."//$_")} readdir DIR;
      closedir DIR;
      foreach my $file (@files) { 
        $query  = "insert into tmp_xp_getdir (pfolder, subdirectory, is_file) values (''''$dir'''',''''$file'''', 1)";
        spi_exec_query($query);
      }
    $perlexec$ language plperlu'';
    execute v_PerlExec;
  end if;

  --raise info ''%'', v_PerlExec;
  return query(select case when t.is_file = 0 and v_OS = ''linux'' then ''/'' else '''' end || t.subdirectory as name, t.is_file as is_file from tmp_xp_getdir t order by id);
  -- Путь текущего директория
  --use Cwd;
  --my $dir = getcwd;

end;

';
    tail := '$$ language plpgsql security invoker
;
alter function public.xp_getdir(text, integer) owner to postgres
;

';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;

--xp_getrootmedia.prc

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_getrootmedia';
    head := '--  select * from public.xp_getrootmedia()

-- удаляем старую версию функции только если изменится кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземпляра SetupSrv к серверу).
-- drop function if exists public.xp_getrootmedia();

create or replace function public.xp_getrootmedia()
returns table (name text) 
as $$
';
    body := '
declare
  v_PerlExec  text;
  v_OS        text := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin32'' else ''linux'' end;

begin

  if v_OS = ''linux'' then
    return query (select subdirectory as name from xp_getdir (v_Dir := ''/'', v_mask := 1));
  end if;


  if v_OS = ''mswin32'' then
    create temp table tmp_xp_getrootmedia (id serial, pfolder text, subdirectory text, is_file integer) on commit drop;

    v_PerlExec :=''
    do
    $perlexec$
    use strict;
    use Win32API::File qw(
        getLogicalDrives GetVolumeInformation );

    my $query;
    my @Drives = getLogicalDrives();
    foreach my $Drive (@Drives) {
        $query  = "insert into tmp_xp_getrootmedia (subdirectory, is_file) values (''''$Drive'''', 0)";
        spi_exec_query($query);

        #my @x= (undef)x7;
        #GetVolumeInformation($d, @x);
        #print "$d $x[0] ($x[5])\n";
    }
    $perlexec$ language plperlu'';
--    execute v_PerlExec;
--    return query(select subdirectory as name from tmp_xp_getrootmedia order by id);

    v_PerlExec :=''
    do
    $perlexec$
      my $query;
      my $Drive;
      $Drive = "b";
      until ($Drive eq "z") 
      {
        ++$Drive;
        my $DriveL = uc($Drive);
        if ((-d "$Drive:\\") && (-w "$Drive:\\")) 
        {
          $query  = "insert into tmp_xp_getrootmedia (subdirectory, is_file) values (''''$DriveL:\\'''', 0)";
          spi_exec_query($query);
         } 
       }
    $perlexec$ language plperlu'';
    execute v_PerlExec;
    return query(select subdirectory as name from tmp_xp_getrootmedia order by id);

  end if;

end;

';
    tail := '$$ language plpgsql security invoker
;
alter function public.xp_getrootmedia() owner to postgres
;

';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;

--xp_pg_backup_space.prc

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_pg_backup_space';
    head := '-- удаляем старую версию функции только если изменится кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземпляра SetupSrv к серверу).
-- drop function if exists public.xp_pg_backup_space(text, text);

create or replace function public.xp_pg_backup_space (v_DBName text, v_FullPath text, v_ResultSet out refcursor)
as $$
';
    body := '
declare
  v_dbsize_mb int;
  v_OS        text := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin'' else ''linux'' end;
begin
  v_dbsize_mb := pg_database_size(v_DBName) / 1024 / 1024;
  
  v_FullPath := case when coalesce(v_FullPath, '''') = '''' then ''/'' else v_FullPath end;

  if v_OS = ''mswin32'' then
    v_FullPath := replace(v_FullPath, ''\'', ''\\'');
    perform xp_cmdshell(''dir'', 0);
  else
    perform xp_cmdshell(''df -P'', 0);
  end if;
  
  --Не доделано из-за проблем с кодировкой
  
  open v_ResultSet 
    for select cast(1 as integer) as ret, ''Успешно!''::text as msg;
end;

';
    tail := '$$ language plpgsql security invoker
;
alter function public.xp_pg_backup_space(text, text) owner to postgres
;




';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;

--xp_pg_copydb.prc

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_pg_copydb';
    head := '-- select public.xp_pg_copydb(v_DbName := ''fns_1602_1220_razr'', v_DbNameCopy := ''fns_1602_1220_razr2'', v_Option := 1);
-- удаляем старую версию функции только если изменится кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземпляра SetupSrv к серверу).
-- drop function if exists public.xp_pg_copydb(text, text, text, text, integer);

create or replace function public.xp_pg_copydb(
   v_DbName      text
  ,v_DbNameCopy  text   = ''''
  ,v_PathBackup  text   = ''''
  ,v_PathFileDB  text   = ''''
  ,v_Option      integer = 0 -- 1 бит удалить файл резервной копии
  ,v_Result      out integer
  ,v_ErrorMsg    out text    
)
as $$
';
    body := '
declare
  v_OS          text;
  v_FileBackup  text ='''';
  v_cmd         text;
begin
  v_OS        := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin32'' else ''linux'' end;
  v_Result    := 0;
  v_ErrorMsg  :='''';

  if current_setting(''is_superuser'') = ''off'' then
    v_Result    := -1;
    v_ErrorMsg  := ''Выполнение доступно только пользователю - SUPERUSER.'';
    raise ''#MSG#%'', v_ErrorMsg; 
    return;
  end if;

  if coalesce(v_PathBackup, '''') = '''' then
    v_PathBackup := current_setting(''data_directory'') || case when v_OS = ''linux'' then ''/'' else ''\'' end;
  end if;

  if coalesce(v_DbNameCopy, '''') = '''' then
    v_DbNameCopy := v_DbName || ''_test'';
  end if;

  if left(reverse(v_PathBackup), 1) = ''/'' or left(reverse(v_PathBackup), 1) = ''\'' then
    v_FileBackup := v_DbName || ''_'' || to_char(current_timestamp, ''YYYYMMDDHHMMSS'') || ''.bak'';
  end if;

  if exists(select * from pg_database where lower(datname) = lower(v_DbNameCopy)) then
    v_ErrorMsg  := ''База данных с именем ''|| v_DbNameCopy ||'' уже существует.'';
    raise ''#MSG#%'', v_ErrorMsg; 
    return;
  end if;


  perform xp_pg_dump      (v_DbName := v_DbName, v_Path := v_PathBackup, v_File := v_FileBackup);
  perform xp_pg_createdb  (v_DbName := v_DbNameCopy); 
  perform xp_pg_restore   (v_DbName := v_DbNameCopy, v_Path := v_PathBackup, v_File := v_FileBackup, v_Option := 0);

  if v_Option & 1 > 0 then
    if v_OS = ''linux'' then 
      v_cmd := ''rm '' || v_PathBackup || coalesce(v_FileBackup, '''');
    else
      -- почему-то параметр data_directory в Windows выдает через прямой слеш. Заменим на виндовый backskash.
      v_PathBackup := replace(v_PathBackup, ''/'', ''\'');
      -- экранируем слеш для perl
      v_PathBackup := replace(v_PathBackup, ''\'', ''\\'');
      v_cmd := ''del "'' || v_PathBackup || coalesce(v_FileBackup, '''')||''"'';
    end if;
    --perform xp_cmdshell(v_cmd);
    
    select p.v_ret, p.v_msg from xp_cmdshell(v_Cmd, 0) p into v_Result, v_ErrorMsg;
    if v_Result <> 0 then
      raise ''#MSG#xp_cmdshell: Error: %, Cmd: %'', coalesce(v_ErrorMsg, ''''), v_Cmd;
      return;
    end if; 

  end if;

end;

';
    tail := '$$ language plpgsql security invoker
;
alter function public.xp_pg_copydb(text, text, text, text, integer) owner to postgres
;



';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;

--xp_pg_createdb.prc

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_pg_createdb';
    head := 'drop function if exists public.xp_pg_createdb(text, text, text);
-- удаляем старую версию функции только если изменится кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземпляра SetupSrv к серверу).
-- drop function if exists public.xp_pg_createdb(text);
/*
select * from xp_pg_createdb (v_DbName := ''fns_1602_1220_razr3'');
Фиг знает для чего она сама по себе, т.к. без xp_pg_restore она бессмысленна.
*/
create or replace function public.xp_pg_createdb(
  v_DbName    text
 ,v_Result    out integer
 ,v_ErrorMsg  out text    
)
as $$
';
    body := '
declare
  v_Cmd               text;
  v_FullPathFile      text;
  v_OS                text;
  v_ExecStmtCreateDb  text;
  v_ExecStmtCreateDbKSRoles text;
  v_ExecStmtCreateDbRevoke  text;
  
  v_ExecStmtNewDb     text;
  v_CurDbName         text := lower(current_database());
  v_CurConnectDbLink  text;
  v_StrConnectDbLink  text;
  v_Host              text := host(inet_server_addr());
  v_Port              text := inet_server_port()::text;
  v_User              text := coalesce(current_setting(''auth.v_user'',true), session_user);
  v_Password          text := current_setting(''auth.v_password'',true);
  
begin
  create extension if not exists dblink;

  v_OS        := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin32'' else ''linux'' end;
  v_Result    := -1;
  v_ErrorMsg  := '''';
  v_DbName    := lower(v_DbName);
  
  -- имя оборачиваем в двойной символ {''} и экранируем {''} на {\''} внутри имени БД и пароля
  --зы: такое оборачивание нужно везде, где возможно появление одиночной кавычки - видимо особенности парсинга dblink. Т.е. добавить ещё и к паролю (попробую квотинг долларами).
  --зызы: квотинг долларами не работает
  
  --UPD: если мы запускаем xp_pg_restore только под dbo(проверка на super и invoker), то можем разрешить доступ в pg_hba и соединяться по сокету/localhost.
  --     оставим возможность передать v_User и v_Password на всякий случай (хотя, собственно говоря, передавать имя и пароль через контекст не обязательно/не нужно, если есть trust в pg_hba)

  --v_CurConnectDbLink := ''hostaddr=''||v_Host||coalesce('' port=''||v_Port,'''')||'' dbname='''''' || replace(replace(v_CurDbName, ''\'', ''\\''), '''''''', ''\'''''') || '''''''' || coalesce('' user=''||quote_literal(v_User),'''') || coalesce('' password='''''' || replace(replace(v_Password, ''\'', ''\\''), '''''''', ''\'''''') || '''''''','''');
  --v_StrConnectDbLink := ''hostaddr=''||v_Host||coalesce('' port=''||v_Port,'''')||'' dbname='''''' || replace(replace(v_DbName   , ''\'', ''\\''), '''''''', ''\'''''') || '''''''' || coalesce('' user=''||quote_literal(v_User),'''') || coalesce('' password='''''' || replace(replace(v_Password, ''\'', ''\\''), '''''''', ''\'''''') || '''''''','''');

  v_CurConnectDbLink := coalesce('' port=''||v_Port,'''')||'' dbname='''''' || replace(replace(v_CurDbName, ''\'', ''\\''), '''''''', ''\'''''') || '''''''' || coalesce('' user=''||quote_literal(v_User),'''') || coalesce('' password='''''' || replace(replace(v_Password, ''\'', ''\\''), '''''''', ''\'''''') || '''''''','''');
  v_StrConnectDbLink := coalesce('' port=''||v_Port,'''')||'' dbname='''''' || replace(replace(v_DbName   , ''\'', ''\\''), '''''''', ''\'''''') || '''''''' || coalesce('' user=''||quote_literal(v_User),'''') || coalesce('' password='''''' || replace(replace(v_Password, ''\'', ''\\''), '''''''', ''\'''''') || '''''''','''');

  if current_setting(''is_superuser'') = ''off'' then
    v_ErrorMsg  := ''Выполнение доступно только пользователю - SUPERUSER.'';
    raise ''#MSG#%'', v_ErrorMsg; 
  end if;

  -- предварительные проверки
  -- 1. Существование БД

  if exists(select * from pg_database where lower(datname) = v_DbName) then
    v_ErrorMsg  := ''База данных c именем ''||quote_ident(v_DbName)||'' уже существует.'';
    raise ''#MSG#%'', v_ErrorMsg; 
    return;
  end if;

  if v_OS = ''linux'' then
     --в Убунту(Архангельск) кластер создавался менеджером пакетов с collate и ctype = UTF-8 (с дефисом). Создание БД (по-умолчанию на основе template1) с явным указанием ru_RU.UTF8 ругается.
     --ОШИБКА: 22023: новое правило сортировки (ru_RU.UTF8) несовместимо с правилом в шаблоне базы данных (ru_RU.UTF-8)
     --Хотя, в чем там различие никому не известно и скорее всего оно просто отсутствует.
     --Вариант: либо создавать на основе template0 и принципиально писать ru_RU.UTF8, либо наследовать от template1(и желательно проверять, точно ли там utf-8/utf8)
    v_ExecStmtCreateDb := ''
    create database ''||quote_ident(v_DbName)||''
            with owner            = dbo
                 encoding         = ''''UTF8''''
                 --lc_collate       = ''''ru_RU.UTF8''''
                 --lc_ctype         = ''''ru_RU.UTF8''''
                 connection limit = -1'';
  else
    v_ExecStmtCreateDb := ''
    create database ''||quote_ident(v_DbName)||''
            with owner            = dbo
                 encoding         = ''''UTF8''''
                 lc_collate       = ''''Russian_Russia.1251''''
                 lc_ctype         = ''''Russian_Russia.1251''''
                 connection limit = -1'';

  end if;
  
  --------------------------------------------------------------------------------------------------------------------------------------
  -- Настройка ролей для вновь созданной базы--------------------------------------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------------
  v_ExecStmtCreateDbKSRoles := ''  
  do
  $rol$
  begin
    
  ----ks_users----
    
    if exists(select 1 from pg_roles where rolname=''''ks_users'''') then
      --ks_users существует
      alter role ks_users nosuperuser nocreatedb nocreaterole nologin noreplication;
    else
      --создаем ks_users 
      create role ks_users nosuperuser nocreatedb nocreaterole nologin noreplication;
    end if;

    
  ----ks_sysadmins----

    if exists(select 1 from pg_roles where rolname=''''ks_sysadmins'''') then
      --ks_sysadmins существует
      alter role ks_sysadmins nosuperuser nocreatedb nocreaterole nologin noreplication;
    else
      --создаем ks_sysadmins 
      create role ks_sysadmins nosuperuser nocreatedb nocreaterole nologin noreplication;
      grant dbo to ks_sysadmins;
    end if;


  ----ks_dbowners----

    if exists(select 1 from pg_roles where rolname=''''ks_dbowners'''') then
      --ks_dbowners существует
      alter role ks_dbowners nosuperuser nocreatedb nocreaterole nologin noreplication;
    else
      --создаем ks_dbowners 
      create role ks_dbowners nosuperuser nocreatedb nocreaterole nologin noreplication;
    end if;


  ----ks_ddlcontrol----

    if exists(select 1 from pg_roles where rolname=''''ks_ddlcontrol'''') then
      --ks_ddlcontrol существует
      alter role ks_ddlcontrol nosuperuser nocreatedb nocreaterole nologin noreplication;
    else
      --создаем ks_ddlcontrol 
      create role ks_ddlcontrol nosuperuser nocreatedb nocreaterole nologin noreplication;
    end if;
    
  ----ks_rms----

    if exists(select 1 from pg_roles where rolname=''''ks_rms'''') then
      --ks_rms существует
      alter role ks_rms nosuperuser nocreatedb nocreaterole login noreplication;
    else
      --создаем ks_rms 
      create role ks_rms nosuperuser nocreatedb nocreaterole login noreplication;
    end if;
    
  ----ks_connect_<DATABASE>----
    
    if exists(select 1 from pg_roles where rolname=''''ks_connect_''||v_DbName||'''''') then
      --ks_connect_<DATABASE> существует
      execute ''''alter role ''||quote_ident(''ks_connect_''||v_DbName)||'' nosuperuser nocreatedb nocreaterole nologin noreplication'''';
    else
      --создаем ks_connect_<DATABASE>
      execute ''''create role ''||quote_ident(''ks_connect_''||v_DbName)||'' nosuperuser nocreatedb nocreaterole nologin noreplication'''';
    end if;
    
    begin
      execute ''''alter database ''||quote_ident(v_DbName)||'' owner to dbo'''';
    end;
    
  end;
  $rol$'';
  
    --------------------------------------------------------------------------------------------------------------------------------------
    -- Настройка привилегий на уровне кластера и в БД postgres----------------------------------------------------------------------------
    --------------------------------------------------------------------------------------------------------------------------------------
    v_ExecStmtCreateDbRevoke := ''do 
    $gr$ 
    begin 
      execute ''''grant temporary on database ''||quote_ident(v_DbName)||'' to ks_users'''';
      execute ''''grant connect on database ''||quote_ident(v_DbName)||'' to ''||quote_ident(''ks_connect_''||v_DbName)||'''''';
      execute ''''revoke all on database ''||quote_ident(v_DbName)||'' from public'''';
      revoke create on schema public from public;
      revoke all privileges on database template1,postgres from public;
      grant connect on database postgres to ks_sysadmins;
      grant temp on database postgres to ks_sysadmins;
      --204066
      grant pg_monitor to ks_sysadmins;
      grant execute on function pg_read_file(text) to ks_sysadmins;
      
      if to_regnamespace(''''pgagent'''') is not null then
        execute ''''grant all on schema pgagent to ks_sysadmins'''';
        execute ''''grant all on all tables in schema pgagent to ks_sysadmins'''';
        execute ''''grant all on all sequences in schema pgagent to ks_sysadmins'''';
        execute ''''grant all on all functions in schema pgagent to ks_sysadmins'''';
      end if;
      --ks_rms
      execute ''''grant ''||quote_ident(''ks_connect_''||v_DbName)||'' to ks_rms'''';
      --ks_ddlcontrol (не помню зачем так сделано..возможно пересмотреть, т.к. права раздаются явно для ks_ddlcontrol в xp_pg_restore)
      grant ks_ddlcontrol to ks_users;
      
    end; 
    $gr$;'';
    --------------------------------------------------------------------------------------------------------------------------------------
  
  
  -- скрипт создания дополнительных объектов в прикладной базе данных
  v_ExecStmtNewDb := ''
  do $add$
  begin
    --Настройка привилегий для вновь созданной базы выполняется в xp_pg_restore. ВОЗМОЖНО НУЖНО И ЗДЕСЬ.
    --Нельзя здесь создавать схему dbo и соответственно давать права на неё, т.к. схема создается при pg_restore. Можно было бы использовать опцию -clean, но это потенциально опасно. Поэтому раздачу прав на схему dbo надо оставить только в xp_pg_restore (они уже были там на всякий случай).
    --После этого возникает вопрос чем нам эта процедура полезна без xp_pg_restore, без схем dbo, ks_ddlcontrol, ks_rms, ks_img, ks_msg?
  
    -- создание необходимых расширений
    create extension if not exists adminpack    schema pg_catalog;
    create extension if not exists dblink       schema public;
    create extension if not exists pgcrypto     schema public;
    create extension if not exists plperlu      schema pg_catalog;
    create extension if not exists postgres_fdw schema public;
    create extension if not exists tablefunc    schema public;
    create extension if not exists xml2         schema public;
    create extension if not exists hstore       schema public;
    create extension if not exists pgrowlocks   schema public;

    begin
      create extension if not exists plpython3u   schema pg_catalog;
    exception when others then
      raise info ''''%'''', ''''Нет возможности создать расширение plpython3u.'''';
    end;

  end;$add$'';

  -- Создаем БД
  perform dblink_connect(v_CurConnectDbLink);  
  perform dblink_exec(v_ExecStmtCreateDb);
  perform dblink_exec(v_ExecStmtCreateDbKSRoles);
  perform dblink_exec(v_ExecStmtCreateDbRevoke);
  perform dblink_disconnect();  

  -- создаем дополнительные расширения
  --perform dblink_connect(''dbname='' || v_StrConnectDbLink || '''''''');  
  perform dblink_connect(v_StrConnectDbLink);  
  perform dblink_exec(v_ExecStmtNewDb);
  perform dblink_disconnect();  

  v_Result    := 0;
  v_ErrorMsg  := ''База данных ''||lower(v_DbName)||'' успешно создана.'';
end;

';
    tail := '$$ language plpgsql security invoker
;
alter function public.xp_pg_createdb(text)  owner to postgres
;

';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;

--xp_pg_dump.prc

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_pg_dump';
    head := 'drop function if exists public.xp_pg_dump(text, text, text);
-- удаляем старую версию функции только если изменится кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземпляра SetupSrv к серверу).
-- drop function if exists public.xp_pg_dump(text, text, integer, text);
/*
select * from xp_pg_dump (v_DbName := ''fns_1602_1220_razr'', v_Path := ''/u01/PostgreSQL/9.4/backups1/'', v_File := ''fns_1602_1220_razr1.bak'');
select * from xp_pg_dump (v_DbName := ''fns_1602_1220_razr2'', v_Path := ''/u01/PostgreSQL/9.4/backups/fns_1602_1220_razr1233333.bak'');
Входные параметры:
  v_Option -  1 бит - не сжимать файл бэкапа (по-умолчанию, в угоду скорости)
              2 бит - выгружать в текстовый бэкап

Примечание:
  v_File заведем переменные @timestamp_id и @dbname_id, которые распарсятся в коде.
  v_File после отработки функции будет содержать полное имя файла
*/
create or replace function public.xp_pg_dump(
  v_DbName          text
 ,v_Path            text 
 ,v_Option          integer = 1
 ,v_File     in out text = '''' 
 ,v_Result      out integer
 ,v_ErrorMsg    out text
 ,v_backup_info out text
)
as $$
';
    body := '
declare
  v_Cmd               text;
  v_FullPathFile      text;
  v_Output            text [];
  v_OS                text;
  v_StrConnectDbLink  text;
  v_DbComment         text;
  v_Host     text := host(inet_server_addr());
  v_Port     text := inet_server_port()::text;
  v_User     text := coalesce(current_setting(''auth.v_user'',true), session_user);
  v_Password text := current_setting(''auth.v_password'',true);
  v_bindir   text;
  v_libdir   text;
begin
  v_File := coalesce(v_File,'''');
  v_OS          := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin32'' else ''linux'' end;
  v_ErrorMsg    := '''';

  begin
    v_bindir := current_setting(''ks.bindir'');
  exception when others then
    v_ErrorMsg := ''Не установлен параметр конфигурации ks.bindir'';
    raise ''%'', v_ErrorMsg;
  end;
  
  begin
    v_libdir := current_setting(''ks.libdir'');
  exception when others then
    v_ErrorMsg := ''Не установлен параметр конфигурации ks.libdir'';
    raise ''%'', v_ErrorMsg;
  end;
  
  -- имя оборачиваем в двойной символ {''} и экранируем {''} на {\''} внутри имени
  --UPD: если мы запускаем xp_pg_dump только под dbo(проверка на super и invoker), то можем разрешить доступ в pg_hba и соединяться по сокету/localhost.
  --     оставим возможность передать v_User и v_Password на всякий случай (хотя, собственно говоря, передавать имя и пароль через контекст не обязательно/не нужно, если есть trust в pg_hba)
  --v_StrConnectDbLink := ''hostaddr=''||v_Host||coalesce('' port=''||v_Port,'''')||'' dbname='''''' || replace(v_DbName, '''''''', ''\'''''') || ''''''''||coalesce('' user=''||quote_literal(v_User),'''')||coalesce('' password=''||quote_literal(v_Password),'''');
  v_StrConnectDbLink := ''dbname='''''' || replace(replace(v_DbName, ''\'', ''\\''), '''''''', ''\'''''') || '''''''' || coalesce('' user='' || quote_literal(v_User),'''') || coalesce('' password='''''' || replace(replace(v_Password, ''\'', ''\\''), '''''''', ''\'''''') || '''''''','''') || coalesce('' port='' || v_Port,'''');

  if current_setting(''is_superuser'') = ''off'' then
    v_Result    := -1;
    v_ErrorMsg  := ''Выполнение доступно только пользователю - SUPERUSER.'';
    raise ''#MSG#%'', v_ErrorMsg; 
    return;
  end if;
  

  -- резервное копирование с сжатием, для запуска в db_restore (делается в разы дольше чем pg_dump)
  -- pg_dump -d test_backup_gary_del -Fc -f /u01/PostgreSQL/9.4/backups/test_backup_gary_del.bak -n dbo -n ks_ddlcontrol
  
  -- исключаем посхемное бэкапирование, ибо в бэкап не попадает создание foreign server (чье определение хранится, вероятно, в схеме pg_catalog) для foreign tables, которые точно будут у Хранинлища.
  -- для истории: -n ks_ddlcontrol -n ks_msg -n ks_img -n ks_rms
  if v_OS = ''linux'' then
    v_Cmd := rtrim(v_libdir, ''/'') ||''/kslib/pg_dump -bindir '' || quote_literal(v_bindir) || '' -d '' || quote_literal(v_DbName) || coalesce('' -U ''||quote_literal(v_User), '''') || '' -h 127.0.0.1 '' || coalesce('' -p '' || v_Port, '''') || case when v_Option & 2 > 0 then '' -Fp '' else '' -Fc '' end || case when v_Option & 1 > 0 then ''-Z0 '' else '''' end;
    if coalesce(v_File, '''') <> '''' then
      v_Path := rtrim(v_Path, ''/'') || ''/'';
    end if;
  else
    v_Cmd := ''"'' || rtrim(v_libdir, ''\'') || ''\kslib\pg_dump.bat" -bindir "'' || v_bindir || ''" -d '' || v_DbName || coalesce('' -U ''||v_User, '''') || '' -h 127.0.0.1 '' || coalesce('' -p '' || v_Port, '''') || '' -Fc -n dbo -n ks_ddlcontrol -n ks_msg -n ks_img -n ks_rms'';
    if coalesce(v_File, '''') <> '''' then
      v_Path := rtrim(v_Path, ''\'') || ''\'';
    end if;

    -- экранируем слеш для perl
    v_Cmd  := replace(v_Cmd, ''\'', ''\\'');
    v_Path := replace(v_Path, ''\'', ''\\'');
  end if;

  --замена переменных на значение
  v_File := replace(v_File, ''@dbname_id'', lower(v_DbName));
  v_File := replace(v_File, ''@timestamp_id'', to_char(statement_timestamp(),''yyyymmdd_hh24miss''));
  
  v_FullPathFile := v_Path || v_File;
  v_File := v_FullPathFile;



  -- Предварительная коррекция бакапа 
  -- 1. все что в схеме dbo - переводим на собственника dbo
  perform dblink_connect(v_StrConnectDbLink);  
  perform dblink_exec(''do $fn$ begin if exists(select * from pg_proc where lower(proname) = ''''alter_owner_all'''') then perform dbo.alter_owner_all(); end if; end;$fn$;'');
  perform dblink_disconnect();  
  -----------------------------------
  

  -- 2. Формирование таблицы s_tab_id для последующего исправления tab_id в восстановленной базе
  --------------------------------------------------------------------------------------------------------------------------------------
  raise notice ''%'', ''Восстановление tab_id'';
  perform dblink_connect(v_StrConnectDbLink);
  perform dblink_exec(''do $tabid$ begin if exists(select * from pg_proc where lower(proname) = ''''tab_id_backup'''') then perform dbo.tab_id_backup(); end if; end; $tabid$;'');
  perform dblink_disconnect();  
  --------------------------------------------------------------------------------------------------------------------------------------  

  -- 3. Вызов прикладной х.п. xp_pg_dump_assist
  --------------------------------------------------------------------------------------------------------------------------------------
  raise notice ''%'', ''xp_pg_dump_assist'';
  perform dblink_connect(v_StrConnectDbLink);
  perform dblink_exec(''do $fn$ begin if exists(select * from pg_proc where lower(proname) = ''''xp_pg_dump_assist'''') then perform dbo.xp_pg_dump_assist(); end if; end;$fn$;'');
  perform dblink_disconnect();  
  --------------------------------------------------------------------------------------------------------------------------------------  
  
  v_Cmd := v_Cmd||'' -f "'' || v_FullPathFile || ''" '';
  --v_Cmd := ''pg_dump -d '' || v_DbName || '' -Fc -f '' || v_FullPathFile || '' -n dbo -n ks_ddlcontrol -n ks_msg -n ks_img'';
  raise notice ''%'', v_Cmd;

  select p.v_ret, p.v_msg from xp_cmdshell(v_Cmd, 0) p into v_Result, v_ErrorMsg;
  if v_Result <> 0 then
    raise ''#MSG#xp_cmdshell: %'', coalesce(v_ErrorMsg, '''');
    return;
  end if; 

  --была просьба дать доступ всем
  if v_OS = ''linux'' then
    v_Cmd := ''chmod o+rwx "'' || v_FullPathFile || ''" '';
    select p.v_ret, p.v_msg from xp_cmdshell(v_Cmd, 0) p into v_Result, v_ErrorMsg;
    if v_Result <> 0 then
      raise ''#MSG#chmod: %'', coalesce(v_ErrorMsg, '''');
      return;
    end if; 
  end if;
  
  select coalesce(shobj_description(pd.oid,''pg_database''),''Комментарий к БД отсутствует'') into v_DbComment
  from pg_database pd
  where lower(pd.datname)=lower(v_DbName);

  
  if v_OS = ''linux'' then
    select p.v_ret, ''Имя БД: '' ||coalesce(v_DbName,''<пусто>'')||''
    Комментарий к БД: ''|| v_DbComment ||''
    Имя файла: ''|| coalesce(v_FullPathFile,''<пусто>'') ||''
    Размер файла: ''|| coalesce(p.v_msg,''<пусто>'')
    from xp_cmdshell(''ls -sh ''||quote_literal(v_FullPathFile)||''|cut -d " " -f1'', 0) p into v_Result, v_backup_info;
    if v_Result <> 0 then
      raise ''#MSG#ls: v_Result=%, v_msg=%'', v_Result, coalesce(v_backup_info, '''');
      return;
    end if; 
  else
    v_backup_info = ''Имя БД: '' ||coalesce(v_DbName,''<пусто>'')||''
    Комментарий к БД: ''|| v_DbComment ||''
    Имя файла: ''|| coalesce(v_FullPathFile,''<пусто>'');
  end if;
  
end;

';
    tail := '$$ language plpgsql security invoker
;
alter function public.xp_pg_dump(text, text, integer, text)  owner to postgres
;

';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;

--xp_pg_restore.prc

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_pg_restore';
    head := '-- удаляем старую версию функции только если изменится кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземпляра SetupSrv к серверу).
  -- drop function if exists public.xp_pg_restore(text, text, text, integer);
/*

select * from xp_pg_restore (v_DbName := ''slow_restore_test'', v_Path := ''/var/lib/pgsqlks-13.1_5432/backups'', v_File := ''slow_restore_test.bak'');
*/
create or replace function public.xp_pg_restore(
  v_DbName        text
 ,v_Path          text 
 ,v_File          text    = ''''
 ,v_Option        integer = 1 -- 1 бит - запускать восстановление пользователей, 2 бит - удалять бд в случае ошибки восстановления, 3 бит -  пропускать ошибки
 ,v_Result    out integer
 ,v_ErrorMsg  out text
)
as $$
';
    body := '
declare
  v_Cmd             text;
  v_FullPathFile    text;
  v_OS              text;
  v_ExecStmt        text;
  v_ExistsLDB       integer;
  v_NastrValue      text;
  v_Host            text := host(inet_server_addr());
  v_Port            text := inet_server_port()::text;
  v_User            text := coalesce(current_setting(''auth.v_user'',true), session_user);
  v_Password        text := current_setting(''auth.v_password'',true);
  v_StrConnectDbLink text;
  v_CurConnectDbLink text;
  v_CurDbName        text := lower(current_database());
  v_bindir          text;
  v_libdir   text;
begin

  v_Result      := -1;
  v_OS          := case when lower(current_setting(''lc_collate'')) like ''%1251%'' then ''mswin32'' else ''linux'' end;
  v_ErrorMsg    := '''';
  v_DbName      := lower(v_DbName);
  
  begin
    v_bindir := current_setting(''ks.bindir'');
  exception when others then
    v_ErrorMsg := ''Не установлен параметр конфигурации ks.bindir'';
    raise ''%'', v_ErrorMsg;
  end;
  
  begin
    v_libdir := current_setting(''ks.libdir'');
  exception when others then
    v_ErrorMsg := ''Не установлен параметр конфигурации ks.libdir'';
    raise ''%'', v_ErrorMsg;
  end;
  
  -- имя оборачиваем в двойной символ {''} и экранируем {''} на {\''} внутри имени
  --зы: такое оборачивание нужно везде, где возможно появление одиночной кавычки - видимо особенности парсинга dblink. Т.е. добавить ещё и к паролю (попробую квотинг долларами).
  --зызы: квотинг долларами не работает
  
  --UPD: если мы запускаем xp_pg_restore только под dbo(проверка на super и invoker), то можем разрешить доступ в pg_hba и соединяться по сокету/localhost.
  --     оставим возможность передать v_User и v_Password на всякий случай (хотя, собственно говоря, передавать имя и пароль через контекст не обязательно/не нужно, если есть trust в pg_hba)
  --v_StrConnectDbLink := ''hostaddr=''||v_Host||coalesce('' port=''||v_Port,'''')||'' dbname='''''' || replace(v_DbName, '''''''', ''\'''''') || ''''''''||coalesce('' user=''||quote_literal(v_User),'''')||coalesce('' password=''||quote_literal(v_Password),'''');

  v_StrConnectDbLink := ''dbname='''''' || replace(replace(v_DbName, ''\'', ''\\''), '''''''', ''\'''''') || '''''''' || coalesce('' user='' || quote_literal(v_User),'''') || coalesce('' password='''''' || replace(replace(v_Password, ''\'', ''\\''), '''''''', ''\'''''') || '''''''','''') || coalesce('' port='' || v_Port,'''');
  --нужен dblink к текущей бд postgres, т.к. create/drop database не может выполняться в транзакции
  v_CurConnectDbLink := '' dbname='''''' || replace(replace(v_CurDbName, ''\'', ''\\''), '''''''', ''\'''''') || '''''''' || coalesce('' user=''||quote_literal(v_User),'''') || coalesce('' password='''''' || replace(replace(v_Password, ''\'', ''\\''), '''''''', ''\'''''') || '''''''','''') || coalesce('' port=''||v_Port,'''');
  
  if current_setting(''is_superuser'') = ''off'' then
    v_Result    := -1;
    v_ErrorMsg  := ''Выполнение доступно только пользователю - SUPERUSER.'';
    raise ''%'', v_ErrorMsg; 
    return;
  end if;

  -- предварительные проверки
  -- 1. Существование БД
  if not exists(select * from pg_database where lower(datname) = v_DbName) then
    v_ErrorMsg  := ''База данных отсутствует. Восстановление возможно только в существующую базу.'';
    raise ''%'', v_ErrorMsg; 
    return;
  end if;

  if exists(select * from pg_database where lower(datname) = v_DbName and datallowconn = false) then
    v_ErrorMsg  := ''База данных закрыта для подключений. datallowconn = false.'';
    raise ''%'', v_ErrorMsg; 
    return;
  end if;

  -- для бэкапов сделанных в custom формате
  -- pg_restore -d test_restore_gary_del -e -1 /u01/PostgreSQL/9.4/backups/test_backup_gary_del.bak

  --при восстановлении бэкапа от 10 в 11 учитывать, что придется отключать флаг -e
  --https://www.postgresql.org/message-id/flat/15466-0b90383ff69c6e4b%40postgresql.org
  
  if v_OS = ''linux'' then
    v_Cmd := case when right(v_libdir,1) <> ''/'' then 
        v_libdir||''/kslib/pg_restore -bindir '' || quote_literal(v_bindir) || '' -d '' || quote_literal(v_DbName) || coalesce('' -U ''||quote_literal(v_User), '''') || '' -h 127.0.0.1 '' || coalesce('' -p '' || v_Port, '''') || case when v_Option & 4 = 0 then '' -e'' else '''' end || '' -j 4 ''
      else 
        v_libdir||''kslib/pg_restore -bindir '' || quote_literal(v_bindir) || '' -d '' || quote_literal(v_DbName) || coalesce('' -U ''||quote_literal(v_User), '''') || '' -h 127.0.0.1 '' || coalesce('' -p '' || v_Port, '''') || case when v_Option & 4 = 0 then '' -e'' else '''' end || '' -j 4 ''
      end;
    if coalesce(v_File, '''') <> '''' then
      v_Path := case when right(v_Path, 1) <> ''/'' then v_Path || ''/'' else v_Path end;
    end if;
  else
    v_Cmd := ''"'' || case when right(v_libdir,1) <> ''\'' then 
        v_libdir||''\kslib\pg_restore.bat" -bindir "'' || v_bindir || ''" -d '' || v_DbName || coalesce('' -U ''||v_User, '''') || '' -h 127.0.0.1 '' || coalesce('' -p '' || v_Port, '''') || case when v_Option & 4 = 0 then '' -e'' else '''' end || '' -j 4 ''
      else 
        v_libdir||''kslib\pg_restore.bat" -bindir "'' || v_bindir || ''" -d '' || v_DbName || coalesce('' -U ''||v_User, '''') || '' -h 127.0.0.1 '' || coalesce('' -p '' || v_Port, '''') || case when v_Option & 4 = 0 then '' -e'' else '''' end || '' -j 4 ''
      end;
    if coalesce(v_File, '''') <> '''' then
      v_Path := case when right(v_Path, 1) <> ''\'' then v_Path || ''\'' else v_Path end;
    end if;
    
    -- экранируем слеш для perl 
    v_Cmd  := replace(v_Cmd, ''\'', ''\\'');
    v_Path := replace(v_Path, ''\'', ''\\'');
  end if;

  v_FullPathFile := v_Path || v_File;

  v_Cmd := v_Cmd ||'' "'' ||v_FullPathFile ||''"'';
  raise notice ''%'', v_Cmd;

  select p.v_ret, p.v_msg from xp_cmdshell(v_Cmd, 0) p into v_Result, v_ErrorMsg;
  raise notice ''v_Result=%'', v_Result; 
  raise notice ''v_ErrorMsg=%'', v_ErrorMsg; 
  
  if v_Result = 0
  then 
    raise notice ''%'', v_ErrorMsg; 
    v_ErrorMsg  := ''База данных ''||lower(v_DbName)||'' успешно восстановлена.'';
    raise notice ''%'', v_ErrorMsg; 

    -- выполнить ANALYZE 
    raise notice ''%'', ''Запуск ANALYZE'';
    v_ExecStmt := ''ANALYZE'';
    perform dblink_connect(v_StrConnectDbLink);
    perform dblink_exec(v_ExecStmt);
    perform dblink_disconnect();  

    -- выполнить восстановление пользователей
    if v_Option & 1 > 0 then
      raise notice ''%'', ''Восстановление пользователей'';
      perform dblink_connect(v_StrConnectDbLink);  
      perform dblink_exec(''
      do $dblink$ 
      begin 
        if exists(select * from pg_proc where lower(proname) = ''''admin_restore_users'''') then
          perform dbo.admin_restore_users(); 
        end if;
      end;$dblink$'');
      perform dblink_disconnect();  
    end if;


    --------------------------------------------------------------------------------------------------------------------------------------
    -- Восстановление  tab_id-------------------------------------------------------------------------------------------------------------
    --------------------------------------------------------------------------------------------------------------------------------------
    raise notice ''%'', ''Восстановление tab_id'';
    perform dblink_connect(v_StrConnectDbLink);
    perform dblink_exec(''do $tabid$ begin if exists(select * from pg_proc where lower(proname) = ''''tab_id_recover'''') then perform dbo.tab_id_recover(); end if; end; $tabid$;'');
    perform dblink_disconnect();  
    --------------------------------------------------------------------------------------------------------------------------------------

    
    --------------------------------------------------------------------------------------------------------------------------------------
    -- Восстановление сервера хранения первички-------------------------------------------------------------------------------------------
    --------------------------------------------------------------------------------------------------------------------------------------
    raise notice ''%'', ''Восстановление хранилища первичных документов'';
    select id into v_ExistsLDB 
      from dblink(v_StrConnectDbLink, ''
          select c.oid::integer as id from pg_class c 
            where c.relname = ''''file_storage''''
                  and exists (select * from pg_authid a where a.rolname= ''''dbo'''' and a.oid::int = c.relowner)
      '') as t (id integer);
    -- Если v_ExistsLDB <> Null -- есть локальное хранилище - оставляем, только настройку меняем на свою БД,
    -- иначе - отсоединяемся от отдельной БД (fdw объекты не бекапируются, поэтому их нет, сносим только настройку)

    if v_ExistsLDB is not null then
      v_NastrValue := ''['' || v_Host || case when coalesce(v_Port, '''') <> '''' then '':'' || v_Port else '''' end || ''].''||v_DbName;
      v_NastrValue := replace(v_NastrValue, '''''''', '''''''''''');
    else
      v_NastrValue := '''';
    end if;

    perform dblink_connect(v_StrConnectDbLink);
    perform dblink_exec(''
      do $dblink$ 
      begin 
        if exists(select * from pg_proc where lower(proname) = ''''set_val'''') then
          perform dbo.set_val(v_cObj := ''''NASTR_PRIMARY_DOC_SQL'''', v_cProp := ''''CHAR_VALUE'''', v_value := ''''''||v_NastrValue||''''''); 
        end if;
      end;$dblink$'');
    perform dblink_disconnect();  
    --------------------------------------------------------------------------------------------------------------------------------------

    --------------------------------------------------------------------------------------------------------------------------------------
    -- Восстановление сервера сообщений --------------------------------------------------------------------------------------------------
    --------------------------------------------------------------------------------------------------------------------------------------
    raise notice ''%'', ''Восстановление сервера сообщений'';

    select id into v_ExistsLDB 
      from dblink(v_StrConnectDbLink, ''
          select c.oid::integer as id from pg_class c 
            where c.relname = ''''pm_box'''' and c.relkind <> ''''f''''
                  and exists (select * from pg_authid a where a.rolname= ''''dbo'''' and a.oid::int = c.relowner)
      '') as t (id integer);

    -- Если v_ExistsLDB <> Null -- есть локальные сообщения - оставляем, только настройку меняем на свою БД,
    -- иначе - удаляем fdw-объекты и сбрасываем настройку(отвязываем от бд сообщений) - все это есть в dbo.admin_pm_storage_manage(v_cMode := ''delete'') но только для того же кластера (т.к. совпадет имя fdw-сервера)
    -- При восстановлении на другом кластере у нас нет информации как должен называться fdw-сервер, поэтому будем удалять все сервера, начинающиеся на ksmsg_
    if v_ExistsLDB is not null then
      v_NastrValue := replace(v_DbName, '''''''', '''''''''''');
      perform dblink_connect(v_StrConnectDbLink);  
      perform dblink_exec(''
        do $dblink$ 
        begin 
          if exists(select * from pg_proc where lower(proname) = ''''set_val'''') then
            perform dbo.set_val(v_cObj := ''''NASTR_PM_SERVER'''', v_cProp := ''''CHAR_VALUE'''', v_value := ''''''||v_NastrValue||''''''); 
          end if;
        end;$dblink$'');
      perform dblink_disconnect();  
    else
      --connection not available при старой версии admin_pm_storage_manage < 1.57 и admin_jobs < 1.11
      --на переходный период (пока не обновятся все базы) проигнорируем ошибку "Восстановление сервера сообщений"
      perform dblink_connect(v_StrConnectDbLink);  
      perform dblink_exec(''
        do $dblink$ 
        declare
          rec record;
        begin 
          begin
            if exists(select * from pg_proc where lower(proname) = ''''admin_pm_storage_manage'''') then
              ''||coalesce(''perform set_config(''''auth.v_user'''', ''''''||v_User||'''''', false);'', '''') ||''
              ''||coalesce(''perform set_config(''''auth.v_password'''', $pass$''||v_Password||''$pass$, false); '', '''') ||''
              perform dbo.admin_pm_storage_manage(v_Host := ''''''|| coalesce(v_Host, '''') ||'''''', v_Port := ''''''|| coalesce(v_Port, '''') || '''''', v_cMode := ''''delete'''');
            end if;
          exception 
            when others then 
              begin      
                raise notice ''''Ошибка восстановления сервера сообщений. До версии 20.2 не критично.'''';
              end;
          end;
          
          for rec in (select srvname from pg_foreign_server where srvname like ''''ksmsg\_%'''') loop
            execute ''''drop server if exists '''' || rec.srvname || '''' cascade'''';
          end loop;
	  
          --если режим delete не отработал настройку все равно нужно сбросить
          if exists(select * from pg_proc where lower(proname) = ''''set_val'''') then
            perform dbo.set_val(v_cObj := ''''NASTR_PM_SERVER'''', v_cProp := ''''CHAR_VALUE'''', v_value := ''''''''); 
          end if;
      
        end;$dblink$'');
      perform dblink_disconnect();  
    end if;

    ------------------------------------------------------------------------------------------------------------------  

    --------------------------------------------------------------------------------------------------------------------------------------
    -- Настройка привилегий для вновь созданной базы--------------------------------------------------------------------------------------
    --------------------------------------------------------------------------------------------------------------------------------------
    raise notice ''%'', ''Настройка привилегий'';
    perform dblink_connect(v_StrConnectDbLink);
    perform dblink_exec(''do 
    $gr$ 
    declare
      rec record;
    begin 
      --определяем "наша" это база или "не наша".
      if all(to_regrole(''''dbo''''), to_regrole(''''ks_users''''), to_regrole(''''ks_sysadmins''''), to_regrole(''''ks_connect_''||v_DbName||'''''')) is not null 
        and to_regnamespace(''''dbo'''') is not null
      then
        execute ''''grant temporary on database ''||quote_ident(v_DbName)||'' to ks_users'''';
        execute ''''grant select on all tables in schema dbo to ks_users'''';
        execute ''''alter default privileges grant select on tables to ks_users'''';
        for rec in (select relname from pg_class where relowner=to_regrole(''''dbo'''')::oid and lower(relname) like ''''s_users%'''' and relkind=''''r'''') loop
          execute ''''revoke select on dbo.''''||rec.relname||'''' from ks_users'''';
          --признак, что БД локализуемая
          if dbo.col_length(''''dbo.''''||rec.relname, ''''lang_id'''') is not null then
            execute ''''grant select (uid, loginame, groups, lang_id) on table dbo.''''||rec.relname||'''' to ks_users'''';
          end if;
        end loop;
        execute ''''grant connect on database ''||quote_ident(v_DbName)||'' to ''||quote_ident(''ks_connect_''||v_DbName)||'''''';
        execute ''''revoke create on schema public from public'''';
        execute ''''revoke all on database ''||quote_ident(v_DbName)||'' from public'''';
        execute ''''grant usage on schema dbo to ks_users'''';
        execute ''''grant all on schema dbo to ks_sysadmins'''';
        --204066
        execute ''''grant execute on function pg_read_file(text) to ks_sysadmins'''';
      else
        --этот raise не вернется из dblink. просто для себя.
        raise notice ''''Пропущено восстановление привилегий. Если восстанавливается база ПК Кейсистемс, то это ошибка. Необходимо обратиться к разработчикам.'''';
      end if;
    end; 
    $gr$;'');
    perform dblink_disconnect();  
    --------------------------------------------------------------------------------------------------------------------------------------
    
    --------------------------------------------------------------------------------------------------------------------------------------
    -- Настройка привилегий для вновь созданной базы. Схема KS_RMS------------------------------------------------------------------------
    --------------------------------------------------------------------------------------------------------------------------------------
    raise notice ''%'', ''Настройка привилегий для ks_rms'';
    perform dblink_connect(v_StrConnectDbLink);
    perform dblink_exec(''do 
    $ks_rms$ 
    begin 
      if to_regrole(''''ks_rms'''') is not null and to_regnamespace(''''ks_rms'''') is not null then
        execute ''''grant usage on schema ks_rms to ks_users'''';
        execute ''''grant all on schema ks_rms to ks_sysadmins'''';
        execute ''''grant all on all tables in schema ks_rms to ks_sysadmins'''';
        execute ''''grant all on all sequences in schema ks_rms to ks_sysadmins'''';
        execute ''''grant all on all functions in schema ks_rms to ks_sysadmins'''';
        execute ''''alter default privileges in schema ks_rms grant all on tables to ks_sysadmins'''';
        execute ''''alter default privileges in schema ks_rms grant all on sequences to ks_sysadmins'''';
        execute ''''alter default privileges in schema ks_rms grant all on functions to ks_sysadmins'''';
        --привилегия connect дана через роль в xp_pg_createdb
      end if;
    end; 
    $ks_rms$;'');
    perform dblink_disconnect();  
    --------------------------------------------------------------------------------------------------------------------------------------
    
   
    --------------------------------------------------------------------------------------------------------------------------------------
    --Вызов прикладной х.п. xp_pg_restore_assist
    --------------------------------------------------------------------------------------------------------------------------------------
    perform dblink_connect(v_StrConnectDbLink);  
    perform dblink_exec(''
      do $dblink$ 
      begin 
        if exists(select * from pg_proc where lower(proname) = ''''xp_pg_restore_assist'''') then
          ''||coalesce(''perform set_config(''''auth.v_user'''', ''''''||v_User||'''''', false);'', '''') ||''
          ''||coalesce(''perform set_config(''''auth.v_password'''', $pass$''||v_Password||''$pass$, false); '', '''') ||''
          ''||coalesce(''perform set_config(''''auth.v_port'''', ''''''||v_Port||'''''', false);'', '''')  || ''
          perform dbo.xp_pg_restore_assist(); 
        end if;
      end;$dblink$'');
    perform dblink_disconnect();    
    --------------------------------------------------------------------------------------------------------------------------------------
    
  /*
  else
    -- удалить бд в случае ошибки восстановления
    if v_Option & 2 > 0 then
      raise notice ''%'', ''Удаление бд из-за ошибки восстановления'';
        -- Создаем dblink
        perform dblink_connect(v_CurConnectDbLink);  
        perform dblink_exec(''drop database ''||quote_ident(v_DbName));
        perform dblink_disconnect();  
    end if;
    
    --попробуем отдать ошибку на откуп клиенту
    --raise ''%'', v_ErrorMsg;
  */
  end if;

end;

';
    tail := '$$ language plpgsql security invoker
;
alter function public.xp_pg_restore(text, text, text, integer)  owner to postgres
;

';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;

--xp_send_mail3.sql

do
$f$
declare
    fname text;
    head text;
    body text;
    tail text;
begin
    fname := 'xp_send_mail3';
    head := '-- rev 1.1
-- select * from pg_available_extensions where name like ''plpython3u''

/*

 select  xp_send_mail3 (  
  v_server                      := ''192.168.0.7'',
  v_from                        := quote_ident(current_database())||''@''||host(inet_server_addr()),
  v_recipients                  := ''{"tsaregorodtsev@keysystems.ru"}'',
  v_subject                     := ''Например: Бэкап БД ''||quote_ident(current_database())||'' от ''||to_char(now(),''DD.MM.YYYY HH24:MI:SS''),
  v_body_plain                  := ''Текст письма'',
  --v_body_html
  v_user                        := '''',
  v_password                    := '''');

*/
                                                     

do $$
';
    body := '
declare
  v_sql text = '''';
begin
  create extension if not exists plpython3u;

  -- удаляем старую версию функции только если изменится кол-во или тип входных параметров (чтобы избежать cache lookup failed for function при подключении второго экземпляра SetupSrv к серверу).
  -- drop function if exists public.xp_send_mail3(text, text, text[], text, text, text, text, text, text[], text[]);
  v_sql = ''
create or replace function public.xp_send_mail3(
  v_server     text
 ,v_from       text
 ,v_recipients text[]
 ,v_subject    text
 ,v_body_plain text default ''''''''
 ,v_body_html  text default ''''''''
 ,v_user       text default '''''''' 
 ,v_password   text default ''''''''
 ,v_copy_recipients       text[] default array['''''''']
 ,v_blind_copy_recipients text[] default array['''''''']
)
returns int
as $'' || ''$ 
  import smtplib
  from email.mime.multipart import MIMEMultipart
  from email.mime.text import MIMEText

  v_email_msg   = MIMEMultipart(''''alternative'''')
  v_email_msg["Subject"]  = v_subject
  v_email_msg["From"] = v_from
  v_email_msg["To"] = '''', ''''.join(v_recipients)
  v_email_msg["Cc"] = '''', ''''.join(v_copy_recipients)

  if v_body_plain.replace('''' '''', '''''''')!='''''''':
    v_text = MIMEText(v_body_plain, ''''plain'''')
    v_email_msg.attach(v_text)

  if v_body_html.replace('''' '''', '''''''')!='''''''':
    v_html = MIMEText(v_body_html, ''''html'''')
    v_email_msg.attach(v_html)

  if v_body_html.replace('''' '''', '''''''')=='''''''' and v_body_plain.replace('''' '''', '''''''')=='''''''':
    plpy.info(''''Пустое содержимое письма. Операция отправки отменена.'''')
    return -1
  
  v_full_addr_list = []
  if v_recipients != ['''''''']:
    v_full_addr_list = v_recipients
  if v_copy_recipients != ['''''''']:
    v_full_addr_list = v_full_addr_list + v_copy_recipients
  if v_blind_copy_recipients != ['''''''']:
    v_full_addr_list = v_full_addr_list + v_blind_copy_recipients
  
  try:
    v_SMTPserver = smtplib.SMTP(v_server)
    v_SMTPserver.connect(v_server)
    plpy.info(''''Подключились к серверу SMTP'''')
  except Exception as e:
    plpy.info(''''Ошибка подключения к серверу SMTP: ''''+str(e))
    return -1

  if v_user.replace('''' '''', '''''''')!='''''''':
    try:
      v_SMTPserver.login(v_user, v_password)
    except Exception as e:
      plpy.info(''''Ошибка авторизации на сервере SMTP: ''''+str(e))
      v_SMTPserver.quit()
      return -1

  try:
    v_ErrMsg = v_SMTPserver.sendmail(v_from, v_full_addr_list,v_email_msg.as_string())
  except Exception as e:
    plpy.info(''''Ошибка отправки письма: ''''+str(e))
    v_SMTPserver.quit()
    return -1
  else:
    plpy.info(''''Письмо отправлено : ''''+str(v_ErrMsg))
    v_SMTPserver.quit()
    return 1
$''||''$ language plpython3u;
'';  


  if coalesce(v_sql, '''') <> '''' then
    execute v_sql;
    alter function public.xp_send_mail3(text, text, text[], text, text, text, text, text, text[], text[]) owner to postgres;
  end if;
  
  exception when others then
    raise info ''%'', ''Нет возможности создать объекты расширения plpython3u.'';
  
end;

';
    tail := '$$;


';
    if not exists (select * from pg_proc where proname = fname and lower(regexp_replace(prosrc, '\s', '', 'g')) = lower(regexp_replace(body, '\s', '', 'g'))) then
        execute head || body  || tail;
        raise notice '%', 'func created';
    else
        raise notice '%', 'nothing to do';
    end if;
end;
$f$ language plpgsql;
