#!/bin/bash

###
### Запуск команд в контейнере (ex)
###
### Copyright (c) 2022, ООО "Кейсистемс"
###
### Версия 1.0.2
###

while [[ "$#" -gt 0 ]]
  do
    case $1 in
      -cs)
        _oci_type="$2"
        ;;
      -cn)
        _cont_name="$2"
        ;;
      -c)
        _cmd_exec="$2"
        ;;
      -u)
        _user_exec="$2"
        ;;
      -d)
        _detach_mode="-d"
        ;;
      -noout)
        _no_stdout="yes"
        ;;
      -noerr)
        _no_err_stdout="yes"
        ;;

      --help)
        _show_help="1"
        ;;
    esac
    shift
done

if [ ! -z "${_show_help}" ]; then

echo -e "

    параметры     по умолчанию   описание
    ----------    ------------   ------------------------------------------------------
    -cs           docker         ПО контейнерезации (docker или podman)

    -cn                          наименование контейнера

    -c                           команда, выполняемая в контейнере

    -u                           пользователь, под которым выполняется команда
                                 (если не указан, то выполняется под текущим)

    -d                           выполнение команды в фоне
                                 (не возвращает информации о ходе выполнения или ошибках)

    -noout                       запрет вывода информации о результате выполнения команды
                                 (ошибки выполнения выводятся в файл sys_exec_cont_ex.err)

    -noerr                       не выводить информацию об ошибках в результате
                                 выполнения команды
"
exit 1;
fi;

# === Определяем каталог выполнения текущего скрипта ==========================
_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# файл констант
_const_file="${_bashfile_dir}/sys_const_var.sh"

_sOK=$(echo $(${_const_file} sOK) | tr '#' ' ')
_wOK=$(echo $(${_const_file} wOK) | tr '#' ' ')
_eRR=$(echo $(${_const_file} eRR) | tr '#' ' ')
_emptE=$(${_const_file} emptE)

function _fn_file_echo() {
local __LeftSpace=$2
__LeftSpace=$(echo ${__LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${__LeftSpace}$line"
 done
}

if [ -z "${_oci_type}" ]; then
  _oci_type="docker"
fi;

_exit_status=0
_stderrfilename="sys_exec_cont_ex.err"
_stderrfile="${_bashfile_dir}/${_stderrfilename}"
_stderr="2>${_stderrfile}"

# пользователь
if ! [ -z "${_user_exec}" ]; then _as_user="--user ${_user_exec}"; else _as_user=""; fi;

# вывод результата выполнения
if [ "${_no_stdout}" = "yes" ]; then _stdout=">/dev/null"; else _stdout=""; fi;
# вывод информации об ошибке
if [ "${_no_err_stdout}" = "yes" ]; then _stderr="2>/dev/null"; fi;

# запуск в фоне
if ! [ "${_detach_mode}" = "-d" ]; then _detach_mode=""; fi;


# составление команды
_cont_cmd="${_oci_type} exec ${_detach_mode} ${_as_user} ${_cont_name} /bin/bash -c \"${_cmd_exec}\" ${_stdout} ${_stderr}";

# собственно запуск
eval ${_cont_cmd}
if [ $? -eq 0 ]; then
  _exit_status=0;
else
  _exit_status=1;
  if ! [ "${_no_err_stdout}" = "yes" ]; then
    echo -e "${_eRR}Выполнение команды в контейнере ${_cont_name}: \"${_cmd_exec}\""
    _fn_file_echo ${_stderrfile} ${_emptE}
  fi;
fi;

# файл ошибок
rm -f ${_stderrfile}

exit ${_exit_status};
