#!/bin/bash

###
### Запуск команд в контейнере
###
### Copyright (c) 2022, ООО "Кейсистемс"
###
### Версия 1.0.0
###

_oci_type=$1
_cont_name=$2
_cmd_exec=$3
_user_exec=$4

_as_user_podman=""
_as_user_docker=""

if ! [ -z "${_user_exec}" ]; then
  _as_user_podman="--user ${_user_exec}"
  _as_user_docker="--user ${_user_exec}"
fi;


if [ "${_oci_type}" = "podman" ]; then

  #for debug
  #echo "podman exec -d ${_as_user_podman} ${_cont_name} /bin/bash -c \"${_cmd_exec}\""

  podman exec -d ${_as_user_podman} ${_cont_name} /bin/bash -c "${_cmd_exec}" >/dev/null 2>&1;

else

  #for debug
  #echo "docker exec -d ${_as_user_docker} ${_cont_name} /bin/bash -c \"${_cmd_exec}\""

  docker exec -d ${_cont_name} su - ${_user_exec} -c  "${_cmd_exec}" >/dev/null 2>&1;

fi;

exit;