#!/bin/bash

###
### Проверка портов
###
### Copyright (c) 2022, ООО "Кейсистемс"
###
### Версия 1.0.1
###

_check_type=$1
_check_port=$2" "
_target_text=$3
_min_value=$4
_max_value=$5

# === Определяем каталог выполнения текущего скрипта ==========================
_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# файл констант
_sys_const_file="${_bashfile_dir}/sys_const_var.sh"

_sOK=$(echo $(${_sys_const_file} sOK) | tr '#' ' ')
_wOK=$(echo $(${_sys_const_file} wOK) | tr '#' ' ')
_eRR=$(echo $(${_sys_const_file} eRR) | tr '#' ' ')
_emptE=$(echo $(${_sys_const_file} emptE) | tr '#' ' ')

# === Проверка "свободности" порта на хосте =================================
if [ "${_check_type}" = "free" ]; then

  _ssu_exists=$(ss -V | grep "ss utility")
  if [ ! -z "${_ssu_exists}" ]; then
    _port_exists=$(ss -lntup | grep ":${_check_port}")

    if [ ! -z "${_port_exists}" ]; then
      echo -e "${_eRR}Проверка доступности порта ${_check_port} ПО \"${_target_text}\"."
      echo -e "${_emptE}Команда проверки -> ss -lntup | grep \":${_check_port}\"."
      echo -e "${_emptE}Указанный порт уже используется другим приложением."
      echo -e "${_emptE}Операция установки будет прервана."
      echo -e ""
      exit 1;
    else
      echo -e "${_sOK}Проверка доступности порта ${_check_port} ПО \"${_target_text}\"."
    fi;
  fi;
fi;
#===========================================================================



# === Проверка отсутствия или диапазона порта на хосте =====================
if [ "${_check_type}" = "interval" ]; then
  # Проверка отсутствия порта
  if [ -z "${_check_port}" ]; then
    echo -e "${_eRR}Проверка корректности значения указанного порта ПО \"${_target_text}\"."
    echo -e "${_emptE}Не указан порт."
    echo -e "${_emptE}Значение порта должно быть в диапазоне [${_min_value}-${_max_value}]."
    echo -e "${_emptE}Операция установки будет прервана."
    echo -e ""
    exit 1;
  else
    # Проверка диапазона портов
    if ! ((${_min_value}<=${_check_port} && ${_check_port}<=${_max_value})); then
      echo -e "${_eRR}Проверка корректности значения указанного порта ПО \"${_target_text}\"."
      echo -e "${_emptE}Некорректное значение порта."
      echo -e "${_emptE}Значение порта должно быть в диапазоне [${_min_value}-${_max_value}]."
      echo -e "${_emptE}Операция установки будет прервана."
      echo -e ""
      exit 1;
    fi;
  fi;
fi;
#===========================================================================


exit 0;
