#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

dks_cont_name=$1
db_inst_name=$2
db_bin_path=$3
db_data_path=$4
db_port=$5

dks_init_var_file="dks_init_var_${db_port}.sh"

# Цвета
sOK=$(echo $($dks_bashfile_dir/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/dks_const_var.sh emptE) | tr '#' ' ')

# sudo
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "run"
if [ $? = "1" ]; then exit 1; fi;

# Файл обмена
dks_stdout=$($dks_bashfile_dir/${dks_init_var_file} dks_stdout)
dks_stdout_cont=$($dks_bashfile_dir/${dks_init_var_file} dks_stdout_cont)
contsoft=$(${dks_bashfile_dir}/${dks_init_var_file} contsoft)

function fn_file_clr(){
cat > $1 << EOF
EOF
}
fn_file_clr ${dks_stdout}
chmod 777 ${dks_stdout}
#====================================================================


# Если файл /etc/repmgr/repmgr.conf настроен, значит выполнялась настройка кластера
# исходя из этого пытаемся запустить демона repmgrd и ssh сервер
# /opt/pgsqlks-13.1/repmgr/5434
if ! [ -f "/opt/${db_inst_name}/repmgr/${db_port}/repmgr.conf" ]; then
  exit 0;
fi;


## --инфа, запущен ли repmgr
is_stop="0"
chk_cmd="echo \$(ps -ef | grep ${db_bin_path}/repmgr | grep -v root) > ${dks_stdout_cont}"

bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"


file_stdout=$(cat ${dks_stdout})
fn_file_clr ${dks_stdout}


if [ -z "${file_stdout}" ]; then
  echo -e "${wOK}Остановка демона repmgrd сервера СУБД ${db_inst_name}:${db_port}."
  echo -e "${emptE}Демон repmgrd уже остановлен."
  is_stop="1";
fi;


if [ "${is_stop}" == "0" ]; then
  # Останавливаем и потом проверяем

  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                   -cn "${dks_cont_name}" \
                                                   -c  "${db_bin_path}/repmgr -f /etc/repmgr/repmgr.conf daemon stop" \
                                                   -u  "postgres"
  if [ $? = "1" ]; then
    echo ""
    echo -e "${eRR}Остановка демона repmgrd сервера СУБД ${db_inst_name}:${db_port}."
    echo -e "${emptE}Была предпринята неуспешная попытка остановки демона repmgrd."
    exit 1;
  fi;

  echo -e "${sOK}Остановка демона repmgrd сервера СУБД ${db_inst_name}:${db_port}."
fi;


## --инфа, запущен ли ssh сервер
is_stop="0"
fn_file_clr ${dks_stdout}
chk_cmd="echo \$(ps -ef | grep /usr/sbin/sshd | grep -v root) > ${dks_stdout_cont}"

bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}" -cn "${dks_cont_name}" -c "${chk_cmd}"

file_stdout=$(cat $dks_stdout)

if [ -z "${file_stdout}" ]; then
  echo -e "${wOK}Остановка SSH сервера в контейнере ${db_cont_name}."
  echo -e "${emptE}SSH сервер уже остановлен."
  is_stop="1";
fi;


if [ "${is_stop}" == "0" ]; then
  # Останавливаем и потом проверяем
  bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                   -cn "${dks_cont_name}" \
                                                   -c  "kill -9 \\\$(pidof /usr/sbin/sshd)"

  if [ $? = "1" ]; then
    echo ""
    echo -e "${eRR}Остановка SSH сервера в контейнере ${dks_cont_name}."
    echo -e "${emptE}Была предпринята неуспешная попытка остановки SSH сервера в контейнере ${dks_cont_name}."
    exit 1;
  fi;

  echo -e "${sOK}Остановка SSH сервера в контейнере ${dks_cont_name}."
fi;

rm -f ${dks_stdout}

exit 0;

