#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

if [ -z "$1" ]; then
  db_port="5434"
else
  db_port=$1
fi

dks_init_var_file="dks_init_var_${db_port}.sh"


# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

#============== Основные переменные =====================
# Контейнер
dks_inst_path=$($dks_bashfile_dir/dks_const_var.sh dks_inst_path)

# СУБД
db_inst_name=$($dks_bashfile_dir/dks_const_var.sh db_inst_name)
db_bin_path=$($dks_bashfile_dir/dks_const_var.sh db_bin_path)

# Цвета
sOK=$(echo $($dks_bashfile_dir/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $($dks_bashfile_dir/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $($dks_bashfile_dir/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $($dks_bashfile_dir/dks_const_var.sh emptE) | tr '#' ' ')

# sudo
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "run"
if [ $? = "1" ]; then exit 1; fi;

function fn_file_clr(){
cat > $1 << EOF
EOF
}
#==========================================================

# Проверка файла переменных по переданному порту
if  [ ! -f "$dks_bashfile_dir/${dks_init_var_file}" ]; then
  echo -e ""
  echo -e "${eRR}Отсутствует файл инициализации переменных ${dks_init_var_file}."
  echo -e "${emptE}Возможно, что контейнер с указанным портом не создавался."
  echo -e ""
  exit 1;
fi;

dks_cont_name=$($dks_bashfile_dir/${dks_init_var_file} dks_cont_name)
db_data_path=$($dks_bashfile_dir/${dks_init_var_file} db_data_path)
contsoft=$(${dks_bashfile_dir}/${dks_init_var_file} contsoft)

echo ""
# Проверяем существование контейнера в d o c k e r или podman
dks_exists=$(${contsoft} container ls -a | grep ${dks_cont_name})
if [ -z "${dks_exists}" ]; then
  echo -e "${wOK}Остановка контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнера ${dks_cont_name} не существует."
  echo ""
  exit;
fi;

# Определяем запущен ли контейнера в d o c k e r или podman
dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

if [ "${dks_status}" = "false" ]; then
  echo -e "${wOK}Остановка контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнер ${dks_cont_name} не запущен."
  echo ""
  exit;
fi;


# ======================  Останавливаем repmgr ==============================
bash ${dks_bashfile_dir}/dks_stop_repmgr.sh ${dks_cont_name} \
                                            ${db_inst_name}  \
                                            ${db_bin_path}   \
                                            ${db_data_path}  \
                                            ${db_port}


# ======================  Останавливаем СУБД =================================
bash ${dks_bashfile_dir}/dks_stop_pgpid.sh ${dks_cont_name} \
                                           ${db_inst_name}  \
                                           ${db_bin_path}   \
                                           ${db_data_path}  \
                                           ${db_port}



# Останавливаем контейнер, если нет ошибки завершения работы СУБД
if [ $? = "0" ]; then
  ${contsoft} stop -t 1 ${dks_cont_name} >/dev/null
  echo -e "${sOK}Остановка контейнера ${dks_cont_name}."
else
  echo -e "${eRR}Остановка контейнера ${dks_cont_name} невозможна."
  echo -e "${emptE}Выполните корректную остановку сервера СУБД."
fi;

echo ""

exit;


