#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

dks_cont_name=$1
db_inst_name=$2
db_bin_path=$3
db_data_path=$4
db_port=$5

dks_init_var_file="dks_init_var_${db_port}.sh"


# Цвета
sOK=$(echo $(${dks_bashfile_dir}/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $(${dks_bashfile_dir}/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $(${dks_bashfile_dir}/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $(${dks_bashfile_dir}/dks_const_var.sh emptE) | tr '#' ' ')


# sudo
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "run"
if [ $? = "1" ]; then exit 1; fi;

# Файл обмена
dks_stdout=$(${dks_bashfile_dir}/${dks_init_var_file}      dks_stdout)
dks_stdout_cont=$(${dks_bashfile_dir}/${dks_init_var_file} dks_stdout_cont)
contsoft=$(${dks_bashfile_dir}/${dks_init_var_file}        contsoft)

# Ищем активный процесс запуска СУБД
chk_cmd="echo \$(ps -ef | grep \"${db_bin_path}/postgres -D ${db_data_path}/data\" | grep -v root) > ${dks_stdout}"

function fn_file_clr(){
cat > $1 << EOF
EOF
}
fn_file_clr ${dks_stdout}
chmod 777 ${dks_stdout}
#====================================================================

## --инфа, запущен ли сервер СУБД.
eval ${chk_cmd}

file_stdout=$(cat ${dks_stdout})

fn_file_clr ${dks_stdout}
if [ ! -z "${file_stdout}" ]; then
  echo -e "${wOK}Проверка запуска сервера СУБД ${db_inst_name}:${db_port} "
  echo -e "${emptE}Сервер СУБД ${db_inst_name}:${db_port} уже работает."
  exit 0;
fi;

# Запускаем и потом проверяем

bash ${dks_bashfile_dir}/sys/sys_exec_cont_ex.sh -cs "${contsoft}"      \
                                                 -cn "${dks_cont_name}" \
                                                 -c  "${db_bin_path}/pg_ctl start -D ${db_data_path}/data/ -l ${db_data_path}/data/pgsqlks_start.log" \
                                                 -u  "postgres"         \
                                                 -noout

if [ $? = "1" ]; then
  echo ""
  echo -e "${eRR}Запуск сервера СУБД ${db_inst_name}:${db_port}."
  echo -e "${emptE}Была предпринята неудачная попытка запуска сервера СУБД ${db_inst_name}:${db_port}."
  echo -e "${emptE}Информацию об ошибках запуска см. в файле ${db_data_path}/data/pgsqlks_start.log."
  exit 1;
fi;

echo -e "${sOK}Запуск сервера СУБД ${db_inst_name}:${db_port}."
exit 0;




