#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

if [ -z "$1" ]; then
  db_port="5434"
else
  db_port=$1
fi

dks_init_var_file="dks_init_var_${db_port}.sh"


#============== Основные переменные =====================
# Контейнер
dks_inst_path=$(${dks_bashfile_dir}/dks_const_var.sh dks_inst_path)

# СУБД
db_inst_name=$(${dks_bashfile_dir}/dks_const_var.sh db_inst_name)
db_bin_path=$(${dks_bashfile_dir}/dks_const_var.sh db_bin_path)

# Цвета
sOK=$(echo $(${dks_bashfile_dir}/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $(${dks_bashfile_dir}/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $(${dks_bashfile_dir}/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $(${dks_bashfile_dir}/dks_const_var.sh emptE) | tr '#' ' ')

# sudo
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "run"
if [ $? = "1" ]; then exit 1; fi;

function fn_file_clr(){
cat > $1 << EOF
EOF
}
#==========================================================


# Проверка файла переменных по переданному порту
if  [ ! -f "${dks_bashfile_dir}/${dks_init_var_file}" ]; then
  echo -e ""
  echo -e "${eRR}Отсутствует файл инициализации переменных ${dks_init_var_file}."
  echo -e "${emptE}Возможно, что контейнер с указанным портом не создавался."
  echo -e ""
  exit 1;
fi;

dks_cont_name=$(${dks_bashfile_dir}/${dks_init_var_file} dks_cont_name)
db_data_path=$(${dks_bashfile_dir}/${dks_init_var_file} db_data_path)
contsoft=$(${dks_bashfile_dir}/${dks_init_var_file} contsoft)

echo ""

# Проверяем существование контейнера в docker
dks_exists=$(${contsoft} container ls -a | grep ${dks_cont_name})
if [ -z "${dks_exists}" ]; then
  dks_exists="false"
  echo -e "${wOK}Проверка существования контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнер ${dks_cont_name} не существует. Операция запуска невозможна."
  echo ""
  exit;
else
    dks_exists="true"
fi

#= Подготовка к развертыванию окружения хоста==============
se_mode="Disabled"
# Проверка Selinux
if [ -f /etc/selinux/config ]; then
  se_mode=$(echo $(getenforce))
  if [ "${se_mode}" = "Enforcing" ]; then
    # переключаем в разрешительный :)
    setenforce Permissive
  fi;
fi;


# Определяем запущен ли контейнера в docker
dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

if [ "${dks_status}" = "false" ]; then

  # Запуск контейнера (процесса) в фоновом режиме
  ${contsoft} start ${dks_cont_name} >/dev/null

  dks_status=$(${contsoft} inspect -f '{{.State.Running}}' ${dks_cont_name})

  if [ "${dks_status}" = "true" ]; then
    echo -e "${sOK}Запуск контейнера ${dks_cont_name}."
  else
    echo -e "${eRR}Запуск контейнера ${dks_cont_name}."
    echo -e "${emptE}Контейнер ${dks_cont_name} не запустился. Операция запуска не прошла."
    echo ""

    # восстанавливаем значение для selinux
    if [ "${se_mode}" = "Enforcing" ]; then
      # переключаем обратно
      setenforce Enforcing
    fi;
    exit 1;
  fi;
else
  echo -e "${wOK}Запуск контейнера ${dks_cont_name}."
  echo -e "${emptE}Контейнер ${dks_cont_name} уже запущен."
fi;


# ======================  Запускаем СУБД ======================================
bash ${dks_bashfile_dir}/dks_start_pgpid.sh ${dks_cont_name} \
                                            ${db_inst_name}  \
                                            ${db_bin_path}   \
                                            ${db_data_path}  \
                                            ${db_port}

#==============================================================================

# ======================  Запускаем repmgr  ===================================
bash ${dks_bashfile_dir}/dks_start_repmgr.sh ${dks_cont_name} \
                                             ${db_inst_name}  \
                                             ${db_bin_path}   \
                                             ${db_data_path}  \
                                             ${db_port}

#==============================================================================




# восстанавливаем значение для selinux
if [ "${se_mode}" = "Enforcing" ]; then
  # переключаем обратно
  setenforce Enforcing
fi;

echo ""

exit;



