#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

service_action=$1

if [ -z "$2" ]; then
  db_port="5434"
else
  db_port=$2
fi

dks_init_var_file="dks_init_var_${db_port}.sh"

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

#============== Основные переменные =====================
# Контейнер
dks_inst_path=$(${dks_bashfile_dir}/dks_const_var.sh dks_inst_path)
dks_cont_name=$(${dks_bashfile_dir}/dks_const_var.sh dks_cont_name)

# Цвета
sOK=$(echo $(${dks_bashfile_dir}/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $(${dks_bashfile_dir}/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $(${dks_bashfile_dir}/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $(${dks_bashfile_dir}/dks_const_var.sh emptE) | tr '#' ' ')

# sudo
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "run"
if [ $? = "1" ]; then exit 1; fi;

function fn_file_clr(){
cat > $1 << EOF
EOF
}
#==========================================================

# Проверка файла переменных по переданному порту
if  [ ! -f "${dks_bashfile_dir}/${dks_init_var_file}" ]; then
  echo -e ""
  echo -e "${eRR}Отсутствует файл инициализации переменных ${dks_init_var_file}."
  echo -e "${emptE}Возможно, что контейнер с указанным портом не создавался."
  echo -e ""
  exit 1;
fi

dks_cont_name=$(${dks_bashfile_dir}/${dks_init_var_file} dks_cont_name)
dks_image_code=$(${dks_bashfile_dir}/${dks_init_var_file} dks_image_code)


# Файл обмена
dks_stdout=$(${dks_bashfile_dir}/${dks_init_var_file} dks_stdout)
dks_stdout_cont=$(${dks_bashfile_dir}/${dks_init_var_file} dks_stdout_cont)
contsoft=$(${dks_bashfile_dir}/${dks_init_var_file} contsoft)

fn_file_clr ${dks_stdout}
chmod 777 ${dks_stdout}


# Проверки передачи параметров
if [ -z "$1" ]; then
    echo -e "${eRR}Fatal error: Не указан параметр режима сервиса ('start' или 'stop')."
    echo -e "${emptE}Попытка запуска неизвестной операции."
    exit;
fi;

# Проверяем существование контейнера в d o c k e r или podman
dks_exists=$(${contsoft} container ls -a | grep ${dks_cont_name})
if [ -z "${dks_exists}" ]; then
    dks_exists="false"
else
    dks_exists="true"
fi;

# Контейнера нет, то создаем его (например, была перезагрузка хоста)
if [ "${dks_exists}" = "false" ]; then
    echo -e "${wOK}Проверка существования контейнера ${dks_cont_name}."
    echo -e "${emptE}Контейнер не существует. Запускаем создание контейнера ${dks_cont_name}..."
    bash ${dks_bashfile_dir}/dks_create.sh "${db_port}" "1" "${dks_image_code}"
    exit;
fi

if [ "$service_action" = "start" ]; then
  bash ${dks_bashfile_dir}/dks_start.sh ${db_port}
fi

if [ "$service_action" = "stop" ]; then
  bash ${dks_bashfile_dir}/dks_stop.sh ${db_port}
fi

exit;




