#!/bin/bash

### СУБД-КС "K"
###
### Copyright (c) 2024, ООО Кейсистемс
###
### Версия 14.13

if [ -z "$1" ]; then
  db_port="5434"
else
  db_port=$1
fi

dks_init_var_file="dks_init_var_${db_port}.sh"

# Определяем каталог выполнения текущего скрипта
dks_bashfile_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

#============== Основные переменные =====================
tag_name=$(${dks_bashfile_dir}/dks_const_var.sh tag_name)

# Контейнер
dks_inst_name=$(${dks_bashfile_dir}/dks_const_var.sh dks_inst_name)
dks_inst_path=$(${dks_bashfile_dir}/dks_const_var.sh dks_inst_path)

# Цвета
sOK=$(echo $(${dks_bashfile_dir}/dks_const_var.sh sOK) | tr '#' ' ')
wOK=$(echo $(${dks_bashfile_dir}/dks_const_var.sh wOK) | tr '#' ' ')
eRR=$(echo $(${dks_bashfile_dir}/dks_const_var.sh eRR) | tr '#' ' ')
emptE=$(echo $(${dks_bashfile_dir}/dks_const_var.sh emptE) | tr '#' ' ')
emptEsh=$(${dks_bashfile_dir}/dks_const_var.sh emptE)

# Цвета
ErrColor=$(${dks_bashfile_dir}/dks_const_var.sh ErrColor)
SuccColor=$(${dks_bashfile_dir}/dks_const_var.sh SuccColor)
WarnColor=$(${dks_bashfile_dir}/dks_const_var.sh WarnColor)
NoColor=$(${dks_bashfile_dir}/dks_const_var.sh NoColor)

# sudo
bash ${dks_bashfile_dir}/sys/sys_is_root.sh "uninstall"
if [ $? = "1" ]; then exit 1; fi;

function fn_file_clr(){
cat > $1 << EOF
EOF
}

function fn_file_echo() {
local LeftSpace=$2
LeftSpace=$(echo ${LeftSpace} | tr '#' ' ')
cat $1 | while read line
do
 echo -e "${LeftSpace}$line"
 done
}

#==========================================================

echo ""
stop_from_service="no"


# Проверка файла переменных по переданному порту
if  [ ! -f "${dks_bashfile_dir}/${dks_init_var_file}" ]; then
  echo -e ""
  echo -e "${emptE}${ErrColor}Отсутствует файл инициализации переменных ${dks_init_var_file}.${NoColor}"
  echo -e "${emptE}${ErrColor}Возможно, что контейнер с указанным портом не создавался.${NoColor}"
  echo -e ""
  exit 1;
fi;


# Контейнер (считываем наименование контейнера и сервиса)
dks_cont_name=$(${dks_bashfile_dir}/${dks_init_var_file} dks_cont_name)
dks_serv_name=$(${dks_bashfile_dir}/${dks_init_var_file} dks_serv_name)
contsoft=$(${dks_bashfile_dir}/${dks_init_var_file} contsoft)

db_kslib_path=$(${dks_bashfile_dir}/dks_const_var.sh db_kslib_path)
db_kslib_path_host="${db_kslib_path}/${db_port}"

util_path=$(${dks_bashfile_dir}/dks_const_var.sh util_path)
util_path_host="${util_path}/${db_port}"


# Файл обмена
dks_stdout=$(${dks_bashfile_dir}/${dks_init_var_file} dks_stdout)
dks_stdout_cont=$(${dks_bashfile_dir}/${dks_init_var_file} dks_stdout_cont)

fn_file_clr ${dks_stdout}
chmod 777 ${dks_stdout}


# Если есть сервис останавливаем через него, иначе через скрипт
if [ -f "/lib/systemd/system/${dks_serv_name}" ]; then
  if [ "$(systemctl is-active ${dks_serv_name})" = "active" ]; then
    echo -e "${sOK}Остановка контейнера через сервис ${dks_serv_name}."
    systemctl stop ${dks_serv_name}
    fn_file_echo ${dks_stdout} ${emptEsh}
    stop_from_service="yes"
  fi;

  systemctl disable ${dks_serv_name} >/dev/null 2>${dks_stdout}
  #показываем
  fn_file_echo ${dks_stdout} ${emptEsh}
  fn_file_clr ${dks_stdout}
  rm /lib/systemd/system/${dks_serv_name}
  systemctl daemon-reload

fi;

# Если через сервис не остановили, то останавливаем через скрипт
if [ "${stop_from_service}" = "no" ]; then
  bash ${dks_bashfile_dir}/dks_stop.sh ${db_port}
fi;

# Удаление принудительно контейнер+образ
${contsoft} container inspect ${dks_cont_name} >/dev/null 2>&1
if [ $? -eq 0 ]; then
  echo -e "${sOK}Удаление контейнера ${dks_cont_name}."
  ${contsoft} rm -f ${dks_cont_name} >/dev/null
fi;

${contsoft} image inspect ${dks_cont_name} >/dev/null 2>&1
if [ $? -eq 0 ]; then
  echo -e "${sOK}Удаление образа ${dks_cont_name}."
  ${contsoft} rmi -f ${dks_cont_name} >/dev/null
fi;

# Удаление вспомогательных каталогов хоста
rm -f  ${dks_stdout}
rm -Rf ${util_path_host}
rm -Rf ${db_kslib_path_host}

if [ `ls ${db_kslib_path} | wc -l` -eq 0 ];then
  if [ `ls ${util_path} | wc -l` -eq 0 ];then
    echo -e "${sOK}Удаление каталога /opt/${tag_name}."
    rm -Rf "/opt/${tag_name}"
  fi;
fi;

# Удаление файла инициализации
if [ -f ${dks_bashfile_dir}/${dks_init_var_file} ]; then
  rm ${dks_bashfile_dir}/${dks_init_var_file}
fi;

echo ""
exit;


